/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataAbstracts;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataTypeCategory;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataVariable;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfCovercross;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="24.1.22")
@CheckID(value="R.1351")
@CheckName(value="R.1351")
@CheckLabel(labels={RuleLabel.FUNCTIONAL_COVERAGE, RuleLabel.COVERPOINT})
@CheckTitle(value="Do not cross real coverpoints")
@CheckDescription(value="This rule checks that there are is no cross coverage specified between coverage points that cover real expressions as not all simulators support this.\n\nExamples:\n\nreal x, y;\nbit[0:7] a, b;\ncovergroup cg;\n  real1 : coverpoint x;\n  real2 : coverpoint y;\n\n  bit1 : coverpoint a;\n  bit2 : coverpoint b;\n\n  cross real1, real2;  // not allowed\n\n  cross bit1, bit2;  // allowed\nendgroup\n\nCheck supports pre-waiving.")
public class Check_R_1351
extends OVMComplianceCheck {
    public Check_R_1351(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement covergroup : this.fOVMProject.getAllCovergroups()) {
            List<RfCoverpoint> coverpoints = covergroup.getCoverpointsWithPrefix("", 2, 1);
            if (coverpoints == null || coverpoints.isEmpty()) continue;
            this.notifyCheckAlive();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(covergroup.getDeclaration().getParserPath(), this)) {
                return;
            }
            block1: for (RfCoverpoint coverpoint : coverpoints) {
                ListContainer rhValues;
                IHidObject mainExpression;
                if (!(coverpoint instanceof RfCovercross) || (mainExpression = coverpoint.getExpression()) == null || !(mainExpression instanceof RfHidOperator) || !((RfHidOperator)mainExpression).getOperatorText().equals(",") || (rhValues = ((RfHidOperator)mainExpression).getRHValues()) == null || rhValues.isEmpty()) continue;
                for (IHidObject rhValue : rhValues) {
                    SDataTypeCategory type;
                    ISDataAbstract resolvedType;
                    RfNamedElement finalType;
                    IRfNamedElement firstCoverpointElement;
                    IHidObject secondaryExpression;
                    RfNamedElement finalType2;
                    IRfNamedElement currentElement;
                    if (rhValue == null) continue;
                    if (rhValue instanceof RfHidAccess) {
                        rhValue = ((RfHidAccess)rhValue).getParentHid();
                    }
                    if (!(rhValue instanceof RfHid) || (currentElement = ((RfHid)rhValue).getElement()) == null) continue;
                    if (currentElement instanceof RfField && (finalType2 = LintUtils.getAssociatedFinalType((RfField)currentElement)) != null && LintUtils.REAL_BASE_TYPES.contains(finalType2.getName())) {
                        this.addHit(coverpoint, "Cross containing real expression " + LintUtils.getNamedElementFullName((RfNamedElement)currentElement) + "!");
                        continue block1;
                    }
                    if (!(currentElement instanceof RfCoverpoint) || (secondaryExpression = ((RfCoverpoint)currentElement).getExpression()) == null) continue;
                    if (secondaryExpression instanceof RfHidAccess) {
                        secondaryExpression = ((RfHidAccess)secondaryExpression).getParentHid();
                    }
                    if (secondaryExpression instanceof RfHid && (firstCoverpointElement = ((RfHid)secondaryExpression).getElement()) instanceof RfField && (finalType = LintUtils.getAssociatedFinalType((RfField)firstCoverpointElement)) != null && LintUtils.REAL_BASE_TYPES.contains(finalType.getName())) {
                        this.addHit(coverpoint, "Cross containing real expression " + LintUtils.getNamedElementFullName((RfNamedElement)currentElement) + "!");
                        continue block1;
                    }
                    if (!(secondaryExpression instanceof RfHidOperator) || !((resolvedType = ((RfHidOperator)secondaryExpression).getOperatorResolvedType()) instanceof SDataVariable) || !(type = SDataAbstracts.getOperandCategory((ISDataAbstract)resolvedType)).equals((Object)SDataTypeCategory.REAL) && !type.equals((Object)SDataTypeCategory.SHORTREAL)) continue;
                    this.addHit(coverpoint, "Cross containing real expression " + LintUtils.getNamedElementFullName((RfNamedElement)currentElement) + "!");
                    continue block1;
                }
            }
        }
    }
}

