/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="24.2.23")
@CheckID(value="R.1352")
@CheckName(value="R.1352")
@CheckLabel(labels={RuleLabel.MODPORT, RuleLabel.INTERFACE})
@CheckTitle(value="Do not use modports in hierarchical paths")
@CheckDescription(value="This check flags usages of modports in hierarchical paths.\nIt is recommended to pass the necessary interface references or signals explicitly through the module ports.\n\nExample:\n\ninterface intf;\n\tlogic a;\n\tmodport drv (output a);\nendinterface\n\nclass driver;\n\tvirtual intf vif;\n\ttask foo;\n\t\tvif.drv.a <= 0;\t\t// not allowed\n\tendtask\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1352
extends OVMComplianceCheck {
    private static final String ERROR_MESSAGE = "Modport ''{0}'' is used in hierarchical path!";

    public Check_R_1352(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        rfProject.visitHidObject(rfProject, new LocalHidVisitor());
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalHidVisitor
    extends RfHidVisitor {
        RfNamedElement scope;

        private LocalHidVisitor() {
        }

        public boolean visit(RfHid hidObject) {
            if (Check_R_1352.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            RfFileDef file = this.scope.getFile();
            if (file == null || Check_R_1352.this.fOVMProject.isOVMFile(file.getName())) {
                return true;
            }
            if (!hidObject.hasAccesses()) {
                return true;
            }
            ListContainer accesses = hidObject.getAccesses();
            boolean isHierarchyPath = false;
            for (HidAccess access : accesses) {
                if (access.getAccessKind() != 0) continue;
                isHierarchyPath = true;
                break;
            }
            if (!isHierarchyPath) {
                return true;
            }
            Check_R_1352.this.notifyCheckAlive();
            if (!(hidObject.getElement() instanceof RfModport)) {
                return true;
            }
            Check_R_1352.this.addHit(this.parserPath, hidObject, MessageFormat.format(Check_R_1352.ERROR_MESSAGE, LintUtils.getNamedElementFullName((RfModport)hidObject.getElement())));
            return true;
        }

        @Override
        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }
    }
}

