/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataAbstracts;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataTypeCategory;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataVariable;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="24.2.23")
@CheckID(value="R.1353")
@CheckName(value="R.1353")
@CheckLabel(labels={RuleLabel.FUNCTIONAL_COVERAGE, RuleLabel.COVERPOINT, RuleLabel.RANGE})
@CheckTitle(value="Bins in real coverpoints must contain only range values")
@CheckDescription(value="This rule checks that values of bins in real coverpoints are only defined as ranges using range selects as not all simulators support this.\n\nreal x;\ncovergroup cg;\n  real1 : coverpoint x {\n    bins b1 = {1, 2, 3};         // not allowed\n    bins b2 = {[0:7], [10:17]};  // allowed\n  }\nendgroup\n\nCheck supports pre-waiving.")
public class Check_R_1353
extends OVMComplianceCheck {
    public Check_R_1353(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement covergroup : this.fOVMProject.getAllCovergroups()) {
            List<RfCoverpoint> coverpoints = covergroup.getCoverpointsWithPrefix("", 2, 1);
            if (coverpoints == null || coverpoints.isEmpty()) continue;
            this.notifyCheckAlive();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(covergroup.getDeclaration().getParserPath(), this)) {
                return;
            }
            for (RfCoverpoint coverpoint : coverpoints) {
                SDataTypeCategory type;
                ISDataAbstract resolvedType;
                RfNamedElement finalType;
                IRfNamedElement firstCoverpointElement;
                IHidObject expression = coverpoint.getExpression();
                if (expression == null) continue;
                if (expression instanceof RfHidAccess) {
                    expression = ((RfHidAccess)expression).getParentHid();
                }
                if (expression instanceof RfHid ? !(!((firstCoverpointElement = ((RfHid)expression).getElement()) instanceof RfField) && !(firstCoverpointElement instanceof RfFunction) || (finalType = LintUtils.getAssociatedFinalType((RfAssociatedType)firstCoverpointElement)) != null && LintUtils.REAL_BASE_TYPES.contains(finalType.getName())) : expression instanceof RfHidOperator && (resolvedType = ((RfHidOperator)expression).getOperatorResolvedType()) instanceof SDataVariable && !(type = SDataAbstracts.getOperandCategory((ISDataAbstract)resolvedType)).equals((Object)SDataTypeCategory.REAL) && !type.equals((Object)SDataTypeCategory.SHORTREAL)) continue;
                coverpoint.visitHidObject(null, new BinsDeclarationVisitor(LintUtils.getNamedElementFullName(coverpoint)));
            }
        }
    }

    public class BinsDeclarationVisitor
    implements IHidVisitor<RfHidOperator> {
        private ParserPath parserPath;
        private String coverpointName;

        public BinsDeclarationVisitor(String coverpointName) {
            this.coverpointName = coverpointName;
        }

        public boolean visit(RfHidOperator hidOperator) {
            if (!hidOperator.isCovergroupRangeList()) {
                return true;
            }
            ListContainer rhHids = hidOperator.getRHValues();
            if (rhHids == null || rhHids.isEmpty()) {
                return true;
            }
            for (IHidObject hidObject : rhHids) {
                if (hidObject instanceof RfHidOperator && ((RfHidOperator)hidObject).isRangeOrPartSelect()) continue;
                HidOperatorOccurrence hidOccurrence = hidOperator.getOccurrence();
                if (hidOccurrence == null) {
                    return true;
                }
                Check_R_1353.this.addHit(this.parserPath, (HidOccurrence)hidOccurrence, "Value '" + HidUtils.toNiceString((IHidObject)hidObject) + "' in real coverpoint '" + this.coverpointName + "' is not a range select!");
            }
            return true;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }
    }
}

