/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import java.util.HashSet;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifier;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="24.2.23")
@CheckID(value="R.1354")
@CheckName(value="R.1354")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.ARRAY, RuleLabel.CLASS, RuleLabel.CONSTANT})
@CheckTitle(value="Do not use dynamic arrays and classes in constant functions")
@CheckDescription(value="This check flags usages of dynamic arrays and classes in constant functions because not all simulators support such usages.\n\nExample:\n\nclass my_class;\n\tint a;\nendclass\n\nmodule top;\n\tfunction automatic int foo(int arr[]);\t\t// not allowed\n\t\tautomatic int k;\n\t\tmy_class obj = new();\t\t\t\t\t\t// not allowed\n\tendfunction\n\n\tinitial begin\n\t\tlocalparam int ss = foo('{10,11,12,13})\n\tend\nendmodule\n\nCheck supports pre-waiving.")
public class Check_R_1354
extends OVMComplianceCheck {
    private static final String ERROR_MESSAGE = "Unsupported usage of {0} ''{1}'' in constant function ''{2}''!";

    public Check_R_1354(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        final HashSet allConstantFunctions = new HashSet();
        this.fOVMProject.getRfProject().visitHidObject(null, new RfHidVisitor(){

            public boolean visit(RfHid hidObject) {
                if (!hidObject.hasOccurrence(HidQualifier.HID_IS_IN_CONSTANT_EXPRESSION)) {
                    return true;
                }
                if (!(hidObject.getElement() instanceof RfFunction)) {
                    return true;
                }
                Check_R_1354.this.notifyCheckAlive();
                if (Check_R_1354.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                RfFunction function = (RfFunction)hidObject.getElement();
                allConstantFunctions.add(function);
                return true;
            }
        });
        for (RfFunction function : allConstantFunctions) {
            function.accept(null, new LocalFunctionVisitor(function));
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalFunctionVisitor
    implements IRfNamedElementVisitor {
        RfFunction function;

        public LocalFunctionVisitor(RfFunction function) {
            this.function = function;
        }

        @Override
        public boolean visit(RfNamedElement namedElement) {
            if (!(namedElement instanceof RfField)) {
                return true;
            }
            IRfNamedElement associatedType = ((RfField)namedElement).getAssociatedType();
            while (associatedType instanceof RfTypeAlias) {
                associatedType = ((RfTypeAlias)associatedType).getAssociatedType();
            }
            if (!(associatedType instanceof RfClass) && !RfListType.isDynamicArray((IRfScopeElement)associatedType)) {
                return true;
            }
            String type = associatedType instanceof RfClass ? "class variable" : "dynamic array";
            Check_R_1354.this.addHit(namedElement, MessageFormat.format(Check_R_1354.ERROR_MESSAGE, type, LintUtils.getNamedElementFullName(namedElement), LintUtils.getNamedElementFullName(this.function)));
            return true;
        }
    }
}

