/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.core.ELSpecializationWrapper;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="24.2.25")
@CheckID(value="R.1355")
@CheckName(value="R.1355")
@CheckLabel(labels={RuleLabel.FUNCTIONAL_COVERAGE, RuleLabel.COVERPOINT})
@CheckTitle(value="Unreachable cover bins")
@CheckDescription(value="This rule checks that there are no cover bins that are completely outside of the range of the coverpoint.\n\nExamples:\n\nbit [2:0] v;\ncovergroup cg;\n    cp : coverpoint v {\n        bins b1 = { [0 : 5] };  \t\t\t\t \t// allowed\n        bins b2 = { 3'b010, 4'b1111, [5 : 10] };  // allowed\n        bins b3 = { 4'b1100, 10, [15 : 20] };  \t// not allowed\n    }\nendgroup\n\nCheck supports pre-waiving.")
public class Check_R_1355
extends OVMComplianceCheck {
    private static final Pattern wildcards = Pattern.compile("[?xXzZ]");

    public Check_R_1355(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfCovergroup[] allCovergroups;
        RfProject rfProject = this.fOVMProject.getRfProject();
        ELManager manager = rfProject.getELManager();
        ELParamValuesHidEvaluator evaluator = ELParamValues.EMPTY.getHidEvaluator(manager);
        RfMixedLangProject mixedLangProject = rfProject.getMixedLangProjectParent();
        Map specsPerElement = mixedLangProject.getLinterElabSpecs();
        RfCovergroup[] rfCovergroupArray = allCovergroups = this.fOVMProject.getRfProject().getAllCovergroups();
        int n = allCovergroups.length;
        int n2 = 0;
        while (n2 < n) {
            RfCovergroup covergroup = rfCovergroupArray[n2];
            this.notifyCheckAlive();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(covergroup.getDeclaration().getParserPath(), this)) {
                return;
            }
            List<RfCoverpoint> coverpoints = covergroup.getLocalMembers(RfCoverpoint.class);
            if (coverpoints != null && !coverpoints.isEmpty()) {
                RfModule enclosingScope = covergroup.getEnclosingScope(RfModule.class);
                Map specializationWrappers = enclosingScope != null ? (Map)specsPerElement.get(enclosingScope) : null;
                for (RfCoverpoint coverpoint : coverpoints) {
                    RfHid hid;
                    IHidObject coverpointExpression = coverpoint.getExpression();
                    IHidObject expression = coverpointExpression;
                    if (expression instanceof RfHidAccess) {
                        expression = ((RfHidAccess)expression).getParentHid();
                    }
                    if (!(expression instanceof RfHid) || !((hid = (RfHid)expression).getElement() instanceof RfField)) continue;
                    RfField field = (RfField)hid.getElement();
                    DataType dataType = LintUtils.getAssociatedFinalDataType(field).getAssocDataType();
                    boolean is4State = DataType.is4State(dataType.getRawType());
                    String pathsText = null;
                    if (specializationWrappers != null && !specializationWrappers.isEmpty()) {
                        for (ELSpecializationWrapper wrapper : specializationWrappers.values()) {
                            if (!(wrapper.getHidEvaluator(manager) instanceof ELParamValuesHidEvaluator)) continue;
                            ELParamValuesHidEvaluator specializedEvaluator = (ELParamValuesHidEvaluator)wrapper.getHidEvaluator(manager);
                            pathsText = wrapper.getPathsText();
                            long[] dimensions = this.getDimensions(manager, specializedEvaluator, coverpointExpression, coverpoint);
                            if (dimensions == null) continue;
                            long smallBase10Dimension = dimensions[0];
                            long bigBase10Dimension = dimensions[1];
                            coverpoint.visitHidObject(null, new BinsDeclarationVisitor(smallBase10Dimension, bigBase10Dimension, LintUtils.getNamedElementFullName(coverpoint), LintUtils.getNamedElementFullName(covergroup), pathsText, manager, specializedEvaluator, is4State));
                        }
                        continue;
                    }
                    long[] dimensions = this.getDimensions(manager, evaluator, coverpointExpression, coverpoint);
                    if (dimensions == null) continue;
                    long smallBase10Dimension = dimensions[0];
                    long bigBase10Dimension = dimensions[1];
                    coverpoint.visitHidObject(null, new BinsDeclarationVisitor(smallBase10Dimension, bigBase10Dimension, LintUtils.getNamedElementFullName(coverpoint), LintUtils.getNamedElementFullName(covergroup), pathsText, manager, evaluator, is4State));
                }
            }
            ++n2;
        }
    }

    public Integer getHidImplicitIntValue(RfHidImplicit hidObject) {
        ELParamValueScope hidValue = ELUtils.evaluate((IHidObject)hidObject, (IHidEvaluator)new IHidEvaluator.NullHidEvaluator(), null, (IHidEvaluationGuardian)IHidEvaluationGuardian.DUMMY_EVAL_GUARDIAN);
        if (ELUtils.isUnsuccessfulEval((ELParamValueScope)hidValue)) {
            return null;
        }
        DVTNumber hidNumber = hidValue.getDVTNumber();
        if (!(hidNumber instanceof VlogBitVector)) {
            return null;
        }
        return hidNumber.intValue();
    }

    protected long[] getDimensions(ELManager elManager, ELParamValuesHidEvaluator evaluator, IHidObject hidObject, IRfNamedElement scope) {
        if (hidObject instanceof RfHid) {
            RfHid select = (RfHid)hidObject;
            IRfNamedElement counterElement = select.getElement();
            if (!(counterElement instanceof RfField)) {
                return null;
            }
            if (ELUtils.isVLOGConstant((IRfNamedElement)counterElement)) {
                IHidEvaluationGuardian guardianForEval = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)counterElement, null, (boolean)false, (ELManager)elManager);
                guardianForEval.updateElements(counterElement, scope);
                IELParamValue value = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)select, (IHidEvaluator)evaluator, null, (IHidEvaluationGuardian)guardianForEval));
                if (!ELUtils.isUnsuccessfulEval((IELParamValue)value) && value instanceof ELParamValues.ParamValueNumber) {
                    return new long[]{value.intValue()};
                }
            }
            int width = this.getMaxSize((IHidObject)select, counterElement, elManager, evaluator, scope);
            return this.getRange((RfField)counterElement, width);
        }
        if (hidObject instanceof RfHidImplicit && ((RfHidImplicit)hidObject).isNumber()) {
            RfHidImplicit select = (RfHidImplicit)hidObject;
            ELParamValueScope numberSelect = ELUtils.evaluate((IHidObject)select, (IHidEvaluator)new IHidEvaluator.NullHidEvaluator(), null, (IHidEvaluationGuardian)IHidEvaluationGuardian.DUMMY_EVAL_GUARDIAN);
            if (ELUtils.isUnsuccessfulEval((ELParamValueScope)numberSelect)) {
                return null;
            }
            DVTNumber numberForSize2 = numberSelect.getDVTNumber();
            if (!(numberForSize2 instanceof VlogBitVector)) {
                return null;
            }
            EnumMap masks = numberForSize2.getMasks();
            if (masks != null) {
                long[] lArray = new long[2];
                lArray[1] = -1L;
                return lArray;
            }
            int maxValueOfCounter = numberForSize2.intValue();
            return new long[]{maxValueOfCounter};
        }
        if (hidObject instanceof RfHidOperator) {
            RfHidOperator selectOperator = (RfHidOperator)hidObject;
            if (selectOperator.isRangeOrPartSelect()) {
                long[] leftSize = this.getDimensions(elManager, evaluator, selectOperator.getLHValue(), scope);
                long[] rightSize = this.getDimensions(elManager, evaluator, selectOperator.getFirstRHValue(), scope);
                if (leftSize == null || rightSize == null) {
                    return null;
                }
                if (leftSize.length == 2 && leftSize[0] > leftSize[1] || rightSize.length == 2 && rightSize[0] > rightSize[1]) {
                    long[] lArray = new long[2];
                    lArray[1] = -1L;
                    return lArray;
                }
                if (leftSize[0] > rightSize[0]) {
                    long aux = leftSize[0];
                    leftSize[0] = rightSize[0];
                    rightSize[0] = aux;
                }
                return new long[]{leftSize[0], rightSize[0]};
            }
            IELParamValue value = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)selectOperator, (IHidEvaluator)evaluator, null, (IHidEvaluationGuardian)IHidEvaluationGuardian.DUMMY_EVAL_GUARDIAN));
            if (!ELUtils.isUnsuccessfulEval((IELParamValue)value) && value instanceof ELParamValues.ParamValueNumber) {
                return new long[]{value.intValue()};
            }
        } else if (hidObject instanceof RfHidAccess) {
            RfHidAccess access = (RfHidAccess)hidObject;
            Hid parentHid = access.getParentHid();
            if (parentHid == null) {
                return null;
            }
            IRfNamedElement element = parentHid.getElement();
            if (!(element instanceof RfField)) {
                return null;
            }
            RfField field = (RfField)element;
            int width = this.getMaxSize(hidObject, field, elManager, evaluator, scope);
            return this.getRange(field, width);
        }
        return null;
    }

    protected int getMaxSize(IHidObject select, IRfNamedElement element, ELManager elManager, ELParamValuesHidEvaluator evaluator, IRfNamedElement scope) {
        IHidEvaluationGuardian guardianForSize = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)element, null, (boolean)true, (ELManager)elManager);
        guardianForSize.updateElements(element, scope);
        IHidEvaluationGuardian guardianForEval = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)element, null, (boolean)false, (ELManager)elManager);
        guardianForEval.updateElements(element, scope);
        ELParamValueScope paramValueForSize = ELUtils.evaluateForSize((IHidObject)select, (IHidEvaluator)evaluator, (IRfNamedElement)element, (IHidEvaluationGuardian)guardianForSize);
        if (ELUtils.isUnsuccessfulEval((ELParamValueScope)paramValueForSize)) {
            return this.getUnsuccessfulEvaluationDimensions((RfField)element, evaluator, guardianForEval);
        }
        DVTNumber numberForSize = paramValueForSize.getDVTNumber();
        if (!(numberForSize instanceof VlogBitVector)) {
            return -1;
        }
        if (numberForSize.hasSign()) {
            return numberForSize.getSize() - 1;
        }
        return numberForSize.getSize();
    }

    private int getUnsuccessfulEvaluationDimensions(RfField field, ELParamValuesHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
        DataType dataType = LintUtils.getAssociatedFinalDataType(field).getAssocDataType();
        if (dataType == null) {
            return -1;
        }
        List<IndexType> packed = dataType.getPackedDimension();
        if (packed == null || packed.isEmpty()) {
            return -1;
        }
        int[] packedDimensions = new int[packed.size() * 2];
        int i = 0;
        while (i < packed.size()) {
            IndexType indexType = packed.get(i);
            if (!(indexType.getRangeObject() instanceof RfHidOperator)) {
                return -1;
            }
            RfHidOperator operator = (RfHidOperator)indexType.getRangeObject();
            if (!operator.isRangeOrPartSelect()) {
                return -1;
            }
            ListContainer rhValues = operator.getRHValues();
            if (rhValues == null || rhValues.size() != 1) {
                return -1;
            }
            BitVectorContext dummyContextOrigin = BitVectorContext.of((IRfNamedElement)field.getEnclosingScope(), (boolean)false);
            IELParamValue lhValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)operator.getLHValue(), (IHidEvaluator)evaluator, (BitVectorContext)dummyContextOrigin, (IHidEvaluationGuardian)guardian));
            if (ELUtils.isUnsuccessfulEval((IELParamValue)lhValue) || !(lhValue instanceof ELParamValues.ParamValueNumber)) {
                return -1;
            }
            IELParamValue rhValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)((IHidObject)rhValues.get(0)), (IHidEvaluator)evaluator, (BitVectorContext)dummyContextOrigin, (IHidEvaluationGuardian)guardian));
            if (ELUtils.isUnsuccessfulEval((IELParamValue)rhValue) || !(rhValue instanceof ELParamValues.ParamValueNumber)) {
                return -1;
            }
            packedDimensions[i * 2] = lhValue.intValue();
            packedDimensions[i * 2 + 1] = rhValue.intValue();
            ++i;
        }
        return Math.abs(packedDimensions[0] - packedDimensions[1]) + 1;
    }

    protected long[] getRange(RfField counterElement, int width) {
        RfNamedElement assocType = LintUtils.getAssociatedFinalType(counterElement);
        if (!(assocType instanceof RfBitVectorScalarType)) {
            return null;
        }
        byte assocSign = ((RfBitVectorScalarType)assocType).getSign();
        DataType dataType = counterElement.getDataType();
        byte dataSign = dataType.getSign();
        if (dataSign == 1 || dataSign == 0 && assocSign == 1) {
            long maxValueOfCounter = (long)Math.pow(2.0, width) - 1L;
            if (maxValueOfCounter == -1L) {
                return null;
            }
            long minValueOfCounter = -((long)Math.pow(2.0, width));
            if (minValueOfCounter == -1L) {
                return null;
            }
            return new long[]{minValueOfCounter, maxValueOfCounter};
        }
        if (dataType.getSign() == 2 || dataSign == 0 && assocSign == 2) {
            long maxValueOfCounter = (long)Math.pow(2.0, width) - 1L;
            if (maxValueOfCounter == -1L) {
                return null;
            }
            long[] lArray = new long[2];
            lArray[1] = maxValueOfCounter;
            return lArray;
        }
        return null;
    }

    public class BinsDeclarationVisitor
    implements IHidVisitor<RfHidOperator> {
        private long smallDimension;
        private long bigDimension;
        private String coverpointName;
        private String covergroupName;
        private ParserPath parserPath;
        private String pathsText;
        private ELManager elManager;
        private ELParamValuesHidEvaluator evaluator;
        private boolean is4State;
        private IRfNamedElement scope;

        public BinsDeclarationVisitor(long smallDimension, long bigDimension, String coverpointName, String covergroupName, String pathsText, ELManager elManager, ELParamValuesHidEvaluator evaluator, boolean is4State) {
            this.smallDimension = smallDimension;
            this.bigDimension = bigDimension;
            this.coverpointName = coverpointName;
            this.covergroupName = covergroupName;
            this.pathsText = pathsText;
            this.elManager = elManager;
            this.evaluator = evaluator;
            this.is4State = is4State;
        }

        public boolean visit(RfHidOperator hidOperator) {
            if (!hidOperator.isCovergroupRangeList()) {
                return true;
            }
            ListContainer rhHids = hidOperator.getRHValues();
            if (rhHids == null || rhHids.isEmpty()) {
                return true;
            }
            boolean unreachable = true;
            for (IHidObject hidObject : rhHids) {
                long[] dimensions = Check_R_1355.this.getDimensions(this.elManager, this.evaluator, hidObject, this.scope);
                if (dimensions == null) {
                    unreachable = false;
                    break;
                }
                long[] lArray = new long[2];
                lArray[1] = -1L;
                long[] wildcard = lArray;
                if (Arrays.equals(wildcard, dimensions)) {
                    if (hidObject instanceof RfHidImplicit) {
                        String implicitName = ((RfHidImplicit)hidObject).getName();
                        RfHidImplicit smallImplicit = RfHidImplicit.makeImplicit(wildcards.matcher(implicitName).replaceAll("0"), ((RfHidImplicit)hidObject).getType());
                        RfHidImplicit bigImplicit = RfHidImplicit.makeImplicit(wildcards.matcher(implicitName).replaceAll("1"), ((RfHidImplicit)hidObject).getType());
                        long[] dimensionsSmall = Check_R_1355.this.getDimensions(this.elManager, this.evaluator, (IHidObject)smallImplicit, this.scope);
                        long[] dimensionsBig = Check_R_1355.this.getDimensions(this.elManager, this.evaluator, (IHidObject)bigImplicit, this.scope);
                        if (dimensionsSmall == null || dimensionsSmall.length != 1 || dimensionsBig == null || dimensionsBig.length != 1) {
                            unreachable = false;
                            break;
                        }
                        dimensions = new long[]{dimensionsSmall[0], dimensionsBig[0]};
                    } else if (hidObject instanceof RfHidOperator) {
                        hidOperator = (RfHidOperator)hidObject;
                        IHidObject oldLhValue = hidOperator.getLHValue();
                        IHidObject oldRhValue = hidOperator.getFirstRHValue();
                        if (!(oldLhValue instanceof RfHidImplicit) || !(oldRhValue instanceof RfHidImplicit)) {
                            unreachable = false;
                            break;
                        }
                        RfHidImplicit lhImplicit = (RfHidImplicit)oldLhValue;
                        RfHidImplicit smallLhImplicit = RfHidImplicit.makeImplicit(wildcards.matcher(lhImplicit.getName()).replaceAll("0"), lhImplicit.getType());
                        RfHidImplicit bigLhImplicit = RfHidImplicit.makeImplicit(wildcards.matcher(lhImplicit.getName()).replaceAll("1"), lhImplicit.getType());
                        RfHidImplicit rhImplicit = (RfHidImplicit)oldRhValue;
                        RfHidImplicit smallRhImplicit = RfHidImplicit.makeImplicit(wildcards.matcher(rhImplicit.getName()).replaceAll("0"), rhImplicit.getType());
                        RfHidImplicit bigRhImplicit = RfHidImplicit.makeImplicit(wildcards.matcher(rhImplicit.getName()).replaceAll("1"), rhImplicit.getType());
                        long[] lhDimensionsSmall = Check_R_1355.this.getDimensions(this.elManager, this.evaluator, (IHidObject)smallLhImplicit, this.scope);
                        long[] lhDimensionsBig = Check_R_1355.this.getDimensions(this.elManager, this.evaluator, (IHidObject)bigLhImplicit, this.scope);
                        long[] rhDimensionsSmall = Check_R_1355.this.getDimensions(this.elManager, this.evaluator, (IHidObject)smallRhImplicit, this.scope);
                        long[] rhDimensionsBig = Check_R_1355.this.getDimensions(this.elManager, this.evaluator, (IHidObject)bigRhImplicit, this.scope);
                        if (lhDimensionsSmall == null || lhDimensionsSmall.length != 1 || lhDimensionsBig == null || lhDimensionsBig.length != 1 || rhDimensionsSmall == null || rhDimensionsSmall.length != 1 || rhDimensionsBig == null || rhDimensionsBig.length != 1) {
                            unreachable = false;
                            break;
                        }
                        dimensions = new long[2];
                        dimensions[0] = lhDimensionsSmall[0] < rhDimensionsSmall[0] ? lhDimensionsSmall[0] : rhDimensionsSmall[0];
                        long l = dimensions[1] = lhDimensionsBig[0] > rhDimensionsBig[0] ? lhDimensionsBig[0] : rhDimensionsBig[0];
                    }
                }
                if (dimensions.length == 1) {
                    if (dimensions[0] < this.smallDimension || dimensions[0] > this.bigDimension) continue;
                    unreachable = false;
                    continue;
                }
                if (dimensions.length != 2 || dimensions[0] > dimensions[1] && (dimensions[0] <= dimensions[1] || !this.is4State) || dimensions[0] < this.smallDimension && dimensions[1] < this.smallDimension || dimensions[0] > this.bigDimension && dimensions[1] > this.bigDimension) continue;
                unreachable = false;
            }
            if (unreachable) {
                HidOperatorOccurrence hidOccurrence = hidOperator.getOccurrence();
                if (hidOccurrence == null) {
                    return true;
                }
                Check_R_1355.this.addHit(this.parserPath, (HidOccurrence)hidOccurrence, "Coverpoint '" + this.coverpointName + "' from covergroup '" + this.covergroupName + "' takes values between " + this.smallDimension + " and " + this.bigDimension + "! After removing all invalid values, the values list associated with this bin is an empty list! " + (this.pathsText != null ? "\nHierarchy Paths: " + this.pathsText : ""));
            }
            return true;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public void setScope(IRfNamedElement scope) {
            this.scope = scope;
        }
    }
}

