/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import ro.amiq.dvt.buildconfig.ElaborationDebugZone;
import ro.amiq.dvt.buildconfig.ElaborationExpressionControl;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELBuildPhase;
import ro.amiq.dvt.elaboration.core.ELConstantsManager;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.core.ELManagerConfiguration;
import ro.amiq.dvt.elaboration.core.ELSpecializationWrapper;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTUnpackedArray;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="24.2.23")
@CheckID(value="R.1356")
@CheckName(value="R.1356")
@CheckLabel(labels={RuleLabel.RANDOMIZATION, RuleLabel.ARRAY, RuleLabel.PREDEFINED_METHOD, RuleLabel.CONSTRAINT})
@CheckTitle(value="Do not use .sum without a 'with' clause")
@CheckDescription(value="The result of array.sum may overflow, because it defaults to the width of the array elements. This may lead to unexpected results.\nIt is recommended to explicitly specify the desired width using a 'with' clause.\n\nExample:\n\nrand bit a1[5], a2[5];\n\nconstraint c {\n\ta1.sum() with ( byte'(item) ) > 0 // allowed\n\ta2.sum() > 0\t\t\t\t\t  // not allowed\n}\n\nCheck supports pre-waiving.")
public class Check_R_1356
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="0", description="Skip checking types with a width greater than the specified value. No types are skiped if the specified value is 0.", name="allowTypesWithWidth", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    private int pAllowTypesWithWidth;
    private ELManager elManager;
    private ELParamValuesHidEvaluator emptyEvaluator;
    private Map<IRfNamedElement, Map<ELSpecializationWrapper, ELSpecializationWrapper>> specsPerElement;
    private IELMemory memory;
    private static final String ERROR_MESSAGE = "{0} called without a ''with'' clause!";

    public Check_R_1356(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfConstraint[] allConstraints;
        if (this.pAllowTypesWithWidth != 0) {
            RfProject rfProject = this.fOVMProject.getRfProject();
            this.elManager = new ELManager(rfProject.getMixedLangProjectParent(), IELMemory.ELMemoryType.STANDARD, ELBuildPhase.NONE, ELManagerConfiguration.newDummyWithControlConfig((boolean)false, EnumSet.noneOf(ElaborationExpressionControl.class), new HashSet(), (boolean)false), new ELConstantsManager(), EnumSet.noneOf(ElaborationDebugZone.class));
            this.emptyEvaluator = ELParamValues.EMPTY.getHidEvaluator(this.elManager);
            this.memory = RfMixedLangManager.getInstance().getELMemory(this.fOVMProject.getProject());
            RfMixedLangProject mixedLangProject = rfProject.getMixedLangProjectParent();
            this.specsPerElement = mixedLangProject.getLinterElabSpecs();
        }
        RfConstraint[] rfConstraintArray = allConstraints = this.fOVMProject.getRfProject().getAllConstraints();
        int n = allConstraints.length;
        int n2 = 0;
        while (n2 < n) {
            RfConstraint constraint = rfConstraintArray[n2];
            RfFileDef file = constraint.getFile();
            if (file != null && !this.checkPreWaivers(file.getParserPath())) {
                this.notifyCheckAlive();
                constraint.visitHidObject(null, new LocalConstraintVisitor());
            }
            ++n2;
        }
    }

    private Hid getFirstParentInstanceHid(RfHid rfHid) {
        RfHid parentHid = rfHid;
        while (parentHid != null) {
            if (parentHid.getParentHid() != null && parentHid.getParentHid().getElement() instanceof RfInstance) {
                return parentHid.getParentHid();
            }
            if (parentHid.getParentHid() == null) {
                return parentHid;
            }
            parentHid = parentHid.getParentHid();
        }
        return null;
    }

    public boolean shouldEvaluateWithNonEmptyEvaluator(IRfNamedElement element) {
        DataType dataType = ((RfAssociatedType)element).getDataType();
        if (dataType == null) {
            return false;
        }
        List<IndexType> packedDimension = dataType.getPackedDimension();
        if (packedDimension == null) {
            return false;
        }
        return this.hasDataTypeDependingOnParameters(packedDimension);
    }

    private boolean hasDataTypeDependingOnParameters(List<IndexType> dimension) {
        boolean result = false;
        int i = 0;
        while (i < dimension.size()) {
            RfHidOperator operator;
            ListContainer rhValues;
            IndexType indexType = dimension.get(i);
            if (indexType.getRangeObject() instanceof RfHid) {
                boolean bl = result = result || this.hasDataTypeDependingOnParameters(indexType.getRangeObject());
                if (result) {
                    return result;
                }
            } else if (!(indexType.getRangeObject() instanceof RfHidOperator)) {
                return false;
            }
            if ((rhValues = (operator = (RfHidOperator)indexType.getRangeObject()).getRHValues()) == null || rhValues.size() != 1) {
                return false;
            }
            IHidObject lhValue = operator.getLHValue();
            boolean bl = result = result || this.hasDataTypeDependingOnParameters(lhValue) || this.hasDataTypeDependingOnParameters((IHidObject)rhValues.get(0));
            if (result) {
                return result;
            }
            ++i;
        }
        return result;
    }

    private boolean hasDataTypeDependingOnParameters(IHidObject hidObject) {
        if (hidObject instanceof RfHid && ((RfHid)hidObject).getElement() instanceof RfField && ((RfField)((RfHid)hidObject).getElement()).isInParameterPortList()) {
            return true;
        }
        if (hidObject instanceof RfHidOperator) {
            RfHidOperator operator = (RfHidOperator)hidObject;
            ListContainer rhValues = operator.getRHValues();
            if (rhValues == null || rhValues.size() != 1) {
                return false;
            }
            return this.hasDataTypeDependingOnParameters(operator.getLHValue()) || this.hasDataTypeDependingOnParameters((IHidObject)rhValues.get(0));
        }
        if (hidObject instanceof RfHidAccess) {
            List hids = HidUtils.getSelects((IHidObject)hidObject);
            if (hids == null || hids.isEmpty()) {
                return false;
            }
            boolean found = false;
            for (IHidObject hid : hids) {
                if (found |= this.hasDataTypeDependingOnParameters(hid)) break;
            }
            return found;
        }
        return false;
    }

    private SpecInfo getWrapperForInstance(Hid instanceFieldHid, IRfNamedElement instanceFieldOrFunction, Map<ELSpecializationWrapper, ELSpecializationWrapper> specializationWrappers, IHidEvaluator defaultEvaluator, ArrayBlockingQueue<ElementPath> pathPrefixes) {
        SpecInfo specInfo = new SpecInfo();
        if (specializationWrappers == null || specializationWrappers.isEmpty()) {
            specInfo.setEvaluator(defaultEvaluator);
            return specInfo;
        }
        for (ELSpecializationWrapper wrapper : specializationWrappers.values()) {
            for (ElementPath path : wrapper.paths) {
                IRfInstanceElement instanceElement;
                ELInstance instance = this.memory.instanceFor(path);
                if (instance == null || !(instanceElement = instance.getDescription()).equals(instanceFieldOrFunction)) continue;
                boolean hasPrefix = false;
                for (ElementPath pathPrefix : pathPrefixes) {
                    if (!pathPrefix.isPrefixOf(path) || !path.toString().contains(HidUtils.toStringBuilder((IHidObject)instanceFieldHid, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)false).toString())) continue;
                    hasPrefix = true;
                }
                if (!hasPrefix) continue;
                specInfo.setEvaluator(wrapper.getHidEvaluator(this.elManager));
                specInfo.addPath(path.toString());
            }
        }
        if (specInfo.getEvaluator() == null) {
            specInfo.setEvaluator(defaultEvaluator);
        }
        return specInfo;
    }

    private int getEvaluationDimensionsInfo(IELParamValue paramValueForSize) {
        DVTNumber number = paramValueForSize.getDVTNumber();
        if (!(number instanceof DVTUnpackedArray)) {
            return 0;
        }
        DVTUnpackedArray unpackedArray = (DVTUnpackedArray)number;
        return unpackedArray.getBaseElementSize();
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalConstraintVisitor
    extends RfHidVisitor {
        private IRfNamedElement scope;

        private LocalConstraintVisitor() {
        }

        public void setScope(IRfNamedElement scope) {
            this.scope = scope;
        }

        public boolean visit(RfHid hidObject) {
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            if (!(hidObject.getElement() instanceof RfPredefinedFunction)) {
                return true;
            }
            IRfNamedElement function = hidObject.getElement();
            if (!function.getName().equals("sum")) {
                return true;
            }
            if (Check_R_1356.this.pAllowTypesWithWidth != 0 && this.isWidthAllowed(hidObject)) {
                return true;
            }
            if (!hidObject.hasAccesses()) {
                Hid parentHid = hidObject.getParentHid();
                if (parentHid == null) {
                    return true;
                }
                Check_R_1356.this.addHit(this.parserPath, hidObject, MessageFormat.format(Check_R_1356.ERROR_MESSAGE, String.valueOf(parentHid.getName()) + ".sum"));
                return true;
            }
            HidAccess firstAccess = hidObject.getFirstAccess();
            if (!(firstAccess instanceof RfHidAccessArgs)) {
                return true;
            }
            RfHidAccessArgs accessArgs = (RfHidAccessArgs)firstAccess;
            if (accessArgs.hasWithClause()) {
                return true;
            }
            Check_R_1356.this.addHit(this.parserPath, hidObject, MessageFormat.format(Check_R_1356.ERROR_MESSAGE, firstAccess));
            return true;
        }

        public boolean isWidthAllowed(RfHid hidObject) {
            Hid hid = hidObject.getParentHid();
            if (!(hid instanceof RfHid)) {
                return false;
            }
            RfHid rfHid = (RfHid)hid;
            IRfNamedElement element = rfHid.getElement();
            if (!(element instanceof RfAssociatedType)) {
                return false;
            }
            if (!(rfHid.getAncestorHid().getElement() instanceof RfField) && !(rfHid.getAncestorHid().getElement() instanceof RfFunction)) {
                return false;
            }
            Hid instanceHid = Check_R_1356.this.getFirstParentInstanceHid(rfHid);
            if (instanceHid == null) {
                return false;
            }
            if (!(instanceHid.getElement() instanceof RfField) && !(instanceHid.getElement() instanceof RfFunction)) {
                return false;
            }
            IRfNamedElement instanceElement = instanceHid.getElement();
            IRfScopeElement ancestorElementEnclosingScope = instanceElement.getEnclosingScope(RfModule.class);
            IRfScopeElement elementEnclosingScope = element.getEnclosingScope(RfModule.class);
            IHidEvaluationGuardian guardianForSize = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)element, null, (boolean)true, (ELManager)Check_R_1356.this.elManager);
            guardianForSize.updateElements(element, this.scope);
            if (ancestorElementEnclosingScope == null || elementEnclosingScope == null || Check_R_1356.this.specsPerElement.get(ancestorElementEnclosingScope) == null || Check_R_1356.this.specsPerElement.get(ancestorElementEnclosingScope).isEmpty() || !Check_R_1356.this.shouldEvaluateWithNonEmptyEvaluator(element)) {
                IELParamValue paramValueForSize = XUtils.getValue((ELParamValueScope)ELUtils.evaluateForSize((IHidObject)hid, (IHidEvaluator)Check_R_1356.this.emptyEvaluator, (IRfNamedElement)element, (IHidEvaluationGuardian)guardianForSize));
                return Check_R_1356.this.getEvaluationDimensionsInfo(paramValueForSize) > Check_R_1356.this.pAllowTypesWithWidth;
            }
            Map<ELSpecializationWrapper, ELSpecializationWrapper> specializationWrappers = Check_R_1356.this.specsPerElement.get(ancestorElementEnclosingScope);
            boolean allowedWidth = true;
            for (ELSpecializationWrapper ancestorFieldWrapper : specializationWrappers.values()) {
                Map<ELSpecializationWrapper, ELSpecializationWrapper> fieldSpecializationWrappers;
                SpecInfo specInfo;
                IHidEvaluator fieldSpecializationEvaluator;
                IHidEvaluator defaultEvaluator = ancestorFieldWrapper.getHidEvaluator(Check_R_1356.this.elManager);
                if (!(defaultEvaluator instanceof ELParamValuesHidEvaluator) || ancestorFieldWrapper.paths == null || !((fieldSpecializationEvaluator = (specInfo = Check_R_1356.this.getWrapperForInstance(instanceHid, instanceElement, fieldSpecializationWrappers = Check_R_1356.this.specsPerElement.get(elementEnclosingScope), defaultEvaluator, ancestorFieldWrapper.paths)).getEvaluator()) instanceof ELParamValuesHidEvaluator)) continue;
                IELParamValue paramValueForSize = XUtils.getValue((ELParamValueScope)ELUtils.evaluateForSize((IHidObject)hid, (IHidEvaluator)fieldSpecializationEvaluator, (IRfNamedElement)element, (IHidEvaluationGuardian)guardianForSize));
                boolean bl = allowedWidth = Check_R_1356.this.getEvaluationDimensionsInfo(paramValueForSize) > Check_R_1356.this.pAllowTypesWithWidth;
                if (!allowedWidth) break;
            }
            return allowedWidth;
        }
    }

    static class SpecInfo {
        private IHidEvaluator evaluator;
        private String path;

        SpecInfo() {
        }

        public void setEvaluator(IHidEvaluator evaluator) {
            this.evaluator = evaluator;
        }

        public void addPath(String path) {
            if (this.path == null) {
                this.path = path;
                return;
            }
            this.path = String.valueOf(this.path) + ", " + path;
        }

        public IHidEvaluator getEvaluator() {
            return this.evaluator;
        }

        public String getPath() {
            return this.path;
        }
    }
}

