/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVAPatternDetector;

@CheckVersion(value="24.2.25")
@CheckID(value="R.1357")
@CheckName(value="R.1357")
@CheckLabel(labels={RuleLabel.ASSERTION, RuleLabel.SEQUENCE})
@CheckTitle(value="Do not use sequences as properties that admit empty match")
@CheckDescription(value="Do not use sequences as properties that admit empty match.\nSequences created in a way that lacks potential matches can lead to incoherent and meaningless assertions.\n\nExamples\nassert property (\n  @(posedge sysclk)\n    !(hr) |=>  hr [->1] intersect (  ##1 hb) [*]);             // not allowed")
public class Check_R_1357
extends AbstractSVAPatternDetector {
    @CheckParameter(defaultValue="concurrent_assert, sequence, property", description="Comma separated list of: concurrent_assert, concurrent_assume, concurrent_cover_sequence, concurrent_cover_property, expect, immediate_assert, immediate_assume, immediate_cover, restrict, sequence, property.", name="assertionKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING, isVisible=false)
    private HashSet<String> pAssertionKindValue = new HashSet();
    private static final List<String> EMPTY_MATCH_PATTERNS = Arrays.asList("_A_ and _B_[*]", "_A_ intersect _B_[*]", "_A_ until _B_[*]", "_A_ #=# _B_[*]", "_A_ until_with _B_[*]", "_A_ implies _B_[*]", "_A_ iff _B_[*]");

    public Check_R_1357(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String pFailureMessageFormatValue = "Empty match ''{0}'' found on sequence used as property ''{1}''!";
        Set<Integer> numericalAssertKind = this.getNumericalAssertKind(this.pAssertionKindValue);
        Set<Integer> numericalPropertySequenceKind = this.getNumericalPropertySequenceKind(this.pAssertionKindValue);
        this.detectPattern(this.fOVMProject, new HashSet<String>(EMPTY_MATCH_PATTERNS), pFailureMessageFormatValue, numericalAssertKind, numericalPropertySequenceKind);
    }
}

