/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="24.2.25")
@CheckID(value="R.1358")
@CheckName(value="R.1358")
@CheckLabel(labels={RuleLabel.PROCESS, RuleLabel.SIGNAL, RuleLabel.ALWAYS})
@CheckTitle(value="Do not read signals before writing inside always_comb/always @(*)")
@CheckDescription(value="In always blocks, reading the value of the signal before writing to it could result in problems if the value of the signal is undefined.\n\nExample:\nalways_comb  begin\n  a = b;\n  b = 0;   // not allowed\nend\n\nCheck supports pre-waiving.")
public class Check_R_1358
extends OVMComplianceCheck {
    public Check_R_1358(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<RfActionBlock> actionBlocks = this.fOVMProject.getRfProject().getAllActionBlocks();
        for (RfActionBlock actionBlock : actionBlocks) {
            if (actionBlock == null || !actionBlock.isAlways() || actionBlock.isAlwaysFf() || !actionBlock.isAlwaysComb() && actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS) && !actionBlock.isAllSensitivityList() || this.checkPreWaivers(actionBlock.getDeclaration().getParserPath())) continue;
            this.notifyCheckAlive();
            LocalHidOperatorVisitor visitor = new LocalHidOperatorVisitor();
            actionBlock.visitHidObject(null, visitor);
            Map<RfField, HidOccurrence> reads = visitor.getReads();
            Map<RfField, HidOccurrence> writes = visitor.getWrites();
            for (Map.Entry<RfField, HidOccurrence> entry : reads.entrySet()) {
                RfField field = entry.getKey();
                HidOccurrence readOccurrence = entry.getValue();
                HidOccurrence writeOCcurrence = writes.get(field);
                if (readOccurrence == null || writeOCcurrence == null) continue;
                boolean isHit = false;
                if (readOccurrence.getOffset() > writeOCcurrence.getOffset()) continue;
                if (readOccurrence.getOffset() < writeOCcurrence.getOffset()) {
                    isHit = true;
                } else {
                    if (readOccurrence.getVirtualOffset() > writeOCcurrence.getVirtualOffset()) continue;
                    if (readOccurrence.getVirtualOffset() < writeOCcurrence.getVirtualOffset()) {
                        isHit = true;
                    }
                }
                if (!isHit) continue;
                this.addHit(actionBlock.getDeclaration().getParserPath(), readOccurrence, "The field '" + LintUtils.getNamedElementFullName(field) + "' is read before being written at line " + writeOCcurrence.getLine() + "!");
            }
        }
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    public class LocalHidOperatorVisitor
    implements IHidVisitor<IHidObject> {
        private Map<RfField, HidOccurrence> reads = new HashMap<RfField, HidOccurrence>();
        private Map<RfField, HidOccurrence> writes = new HashMap<RfField, HidOccurrence>();

        public boolean visit(IHidObject iHid) {
            block24: {
                ListContainer rhValues;
                block23: {
                    if (!(iHid instanceof RfHid)) break block23;
                    RfHid rfHid = (RfHid)iHid;
                    if (!rfHid.isMethodCall(false)) {
                        return true;
                    }
                    List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
                    if (methodCalls.isEmpty()) {
                        return true;
                    }
                    for (MethodCall methodCall : methodCalls) {
                        if (methodCall.argumentValuesMapRaw == null) {
                            return true;
                        }
                        for (Map.Entry argumentEntry : methodCall.argumentValuesMapRaw.entrySet()) {
                            Set flattenHids;
                            IRfFieldElement key = (IRfFieldElement)argumentEntry.getKey();
                            IHidObject value = (IHidObject)argumentEntry.getValue();
                            if (!(key instanceof RfField) || value == null || (flattenHids = HidUtils.flattenToHids((IHidObject)value, (Set)HidFlatteningOption.IMPLICITS_EXCLUDED)) == null || flattenHids.isEmpty()) continue;
                            for (IHid iH : flattenHids) {
                                RfField rhField;
                                RfHid rhHid;
                                IRfNamedElement rhElement;
                                if (!(iH instanceof RfHid) || !((rhElement = (rhHid = (RfHid)iH).getElement()) instanceof RfField) || !((rhField = (RfField)rhElement).getEnclosingScope() instanceof RfInstanceHolder)) continue;
                                RfField argumentField = (RfField)key;
                                boolean isRead = false;
                                boolean isWrite = false;
                                if (argumentField.isInput() || argumentField.isConstRef() || argumentField.isRef() || argumentField.isParameter()) {
                                    isRead = true;
                                } else if (argumentField.isOutput() || argumentField.isRef() && !argumentField.isConstRef()) {
                                    isWrite = true;
                                } else if (argumentField.isInout()) {
                                    isRead = true;
                                    isWrite = true;
                                }
                                if (isRead && !this.reads.containsKey(rhField)) {
                                    this.reads.put(rhField, rhHid.getOccurrence());
                                }
                                if (!isWrite || this.writes.containsKey(rhField)) continue;
                                this.writes.put(rhField, rhHid.getOccurrence());
                            }
                        }
                    }
                    break block24;
                }
                if (!(iHid instanceof RfHidOperator)) break block24;
                RfHidOperator operator = (RfHidOperator)iHid;
                if (operator.hasOccurrence(HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER)) {
                    return true;
                }
                IHidObject lhValue = operator.getLHValue();
                if (!(lhValue instanceof RfHid)) {
                    return true;
                }
                RfHid lhHid = (RfHid)lhValue;
                IRfNamedElement lhElement = lhHid.getElement();
                if (!(lhElement instanceof RfField)) {
                    return true;
                }
                RfField lhField = (RfField)lhElement;
                if (lhField.getEnclosingScope() instanceof RfInstanceHolder) {
                    if (operator.isAssignment()) {
                        if (!this.writes.containsKey(lhField)) {
                            this.writes.put(lhField, lhHid.getOccurrence());
                        }
                    } else if (!this.reads.containsKey(lhField)) {
                        this.reads.put(lhField, lhHid.getOccurrence());
                    }
                }
                if ((rhValues = operator.getRHValues()) == null) {
                    return true;
                }
                for (IHidObject rhValue : rhValues) {
                    Set flattenHids = HidUtils.flattenToHids((IHidObject)rhValue, (Set)HidFlatteningOption.IMPLICITS_EXCLUDED);
                    for (IHid iH : flattenHids) {
                        RfField rhField;
                        RfHid rhHid;
                        IRfNamedElement rhElement;
                        if (!(iH instanceof RfHid) || !((rhElement = (rhHid = (RfHid)iH).getElement()) instanceof RfField) || !((rhField = (RfField)rhElement).getEnclosingScope() instanceof RfInstanceHolder) || this.reads.containsKey(rhField)) continue;
                        this.reads.put(rhField, rhHid.getOccurrence());
                    }
                }
            }
            return true;
        }

        public Map<RfField, HidOccurrence> getReads() {
            return this.reads;
        }

        public Map<RfField, HidOccurrence> getWrites() {
            return this.writes;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

