/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="24.2.25")
@CheckID(value="R.1359")
@CheckName(value="R.1359")
@CheckLabel(labels={RuleLabel.RANDOMIZATION, RuleLabel.ARGUMENT})
@CheckTitle(value="The argument to scope randomize must be integral type")
@CheckDescription(value="This check flags usages of non-integral type variables as arguments to scope randomize.\nIt is recommended to only give simple identifiers of integral types to scope randomize in order to avoid any simulation issues.\n\nExample:\n\nint a, arr[];\nreal r[];\n\nstd::randomize(a);\t\t// allowed\nstd::randomize(arr);\t\t// allowed\nstd::randomize(arr[0]);\t// not allowed\nstd::randomize(r);\t\t// not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1359
extends OVMComplianceCheck {
    private static final String ERROR_MESSAGE = "Variable ''{0}'' used as argument of ''std::randomize'' is not a simple identifier of integral type!";

    public Check_R_1359(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new LocalMethodCallVisitor());
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalMethodCallVisitor
    extends RfHidVisitor {
        private LocalMethodCallVisitor() {
        }

        public boolean visit(RfHid hidObject) {
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            if (Check_R_1359.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1359.this.notifyCheckAlive();
            IRfNamedElement element = hidObject.getElement();
            if (!(element instanceof RfPredefinedFunction)) {
                return true;
            }
            if (!"std::randomize".equals(LintUtils.getNamedElementFullName((RfPredefinedFunction)element))) {
                return true;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hidObject);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return true;
            }
            for (MethodCall methodCall : methodCalls) {
                if (methodCall.argumentValuesMapRaw == null) continue;
                for (Map.Entry argument : methodCall.argumentValuesMapRaw.entrySet()) {
                    DataType argumentType;
                    IRfNamedElement argumentElement;
                    IHidObject argumentHid = (IHidObject)argument.getValue();
                    boolean hasSelect = false;
                    if (argumentHid instanceof RfHidAccess) {
                        argumentHid = ((RfHidAccess)argumentHid).getParentHid();
                        hasSelect = true;
                    }
                    if (!(argumentHid instanceof RfHid) || !((argumentElement = ((RfHid)argumentHid).getElement()) instanceof RfAssociatedType) || (argumentType = ((RfAssociatedType)argumentElement).getDataType()) == null || !hasSelect && LintUtils.INTEGRAL_BASE_TYPES.contains(argumentType.getType())) continue;
                    Check_R_1359.this.addHit(this.parserPath, (RfHid)argumentHid, MessageFormat.format(Check_R_1359.ERROR_MESSAGE, LintUtils.getHidFullName((IHid)((RfHid)argumentHid))));
                }
            }
            return true;
        }
    }
}

