/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfForwardTypedef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="24.2.25")
@CheckID(value="R.1360")
@CheckName(value="R.1360")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.FORWARD_TYPEDEF})
@CheckTitle(value="Forward typedefs declaring classes must have corresponding implementation")
@CheckDescription(value="This rule checks that class types defined with forward typedefs have a corresponding implementation instead of defining another type.\nNote: Interface classes are also checked.\n\nExample:\ntypedef class my_type;  // not allowed\nclass impl_class;\nendclass\ntypedef impl_class my_type;\n\ntype class my_type_impl;  // allowed\nclass my_type_impl;\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1360
extends OVMComplianceCheck {
    public Check_R_1360(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement typeDef : this.fOVMProject.getAllTypedefs()) {
            RfHid typeDefHid;
            IRfNamedElement element;
            ListContainer hidsObjectsInCurrentPath;
            Map hidObjectsMap;
            RfForwardTypedef forwardTypedef;
            if (!(typeDef instanceof RfForwardTypedef) || !(forwardTypedef = (RfForwardTypedef)typeDef).isClassTypedef() && !forwardTypedef.isInterfaceTypedef() || forwardTypedef.isAnyTypedef()) continue;
            ParserPath parserPath = forwardTypedef.getDeclaration().getDefFile().getParserPath();
            this.notifyCheckAlive();
            if (this.isPrewaived(parserPath) || (hidObjectsMap = forwardTypedef.getHidHolder().getHidObjectsMap()) == null || hidObjectsMap.isEmpty() || (hidsObjectsInCurrentPath = (ListContainer)hidObjectsMap.get(forwardTypedef.getDeclaration().getDefFile().getParserPath())) == null || hidsObjectsInCurrentPath.isEmpty() || !(hidsObjectsInCurrentPath.get(0) instanceof RfHid) || !((element = (typeDefHid = (RfHid)((Object)hidsObjectsInCurrentPath.get(0))).getElement()) instanceof RfAssociatedType) || !(element instanceof RfTypeAlias)) continue;
            this.addHit(parserPath, typeDefHid.getLine(), "Forward typedef '" + LintUtils.getHidName((IHid)typeDefHid) + "' does not have a corresponding implementation!", null);
        }
    }

    private boolean isPrewaived(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

