/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfStringType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="24.2.25")
@CheckID(value="R.1361")
@CheckName(value="R.1361")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.CONCATENATION, RuleLabel.STRING})
@CheckTitle(value="Do not use formatting methods for string concatenation")
@CheckDescription(value="Use the concatenation operator to format strings insead, as it is faster.\n\nExamples:\n\n{str1, str2}                         // allowed\n$sformat(\"%s %s\", \"str1\", \"str2\");  // not allowed\n$sformatf(\"%s %s\", \"str1\", \"str2\");  // not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1361
extends OVMComplianceCheck {
    public Check_R_1361(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new SformatfVisitor());
    }

    public boolean formatsString(IHidObject hid) {
        if (hid instanceof RfHid) {
            IRfNamedElement argumentValueElement = ((RfHid)hid).getElement();
            if (!(argumentValueElement instanceof RfField)) {
                return false;
            }
            RfNamedElement fieldType = LintUtils.getAssociatedFinalType((RfField)argumentValueElement);
            if (fieldType instanceof RfStringType) {
                return true;
            }
        } else if (hid instanceof RfHidImplicit) {
            RfHidImplicit implicit = (RfHidImplicit)hid;
            if (LintUtils.isStringLiteral(implicit.getName())) {
                return true;
            }
        } else {
            if (hid instanceof RfHidOperator) {
                RfHidOperator operator = (RfHidOperator)hid;
                if (!operator.isVLOGConcatenation(true)) {
                    return false;
                }
                boolean hasString = false;
                Set flattenedHids = HidUtils.flattenToHids((IHidObject)operator, (Set)HidFlatteningOption.NONE_EXCLUDED);
                for (IHid flattenedHid : flattenedHids) {
                    boolean bl = hasString = hasString || this.formatsString((IHidObject)flattenedHid);
                    if (!hasString) continue;
                    return hasString;
                }
                return false;
            }
            if (hid instanceof RfHidAccess) {
                RfHidAccess hidAccess = (RfHidAccess)hid;
                IRfNamedElement assocType = hidAccess.getAssociatedType();
                if (!(assocType instanceof RfStringType)) {
                    return false;
                }
                if ("string".equals(assocType.getName())) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    public class SformatfVisitor
    extends RfHidVisitor {
        public boolean visit(RfHid hidObject) {
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            if (Check_R_1361.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1361.this.notifyCheckAlive();
            IRfNamedElement element = hidObject.getElement();
            if (!(element instanceof RfFunction) || !element.isPredefined()) {
                return true;
            }
            RfFunction function = (RfFunction)element;
            if (!"$sformatf".equals(function.getFullName()) && !"$sformat".equals(function.getFullName())) {
                return false;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hidObject);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return true;
            }
            for (MethodCall methodCall : methodCalls) {
                if (methodCall.argumentValuesMapRaw == null || methodCall.argumentValuesMapRaw.isEmpty()) continue;
                boolean formatsString = true;
                for (Map.Entry entry : methodCall.argumentValuesMapRaw.entrySet()) {
                    IHidObject argumentValue;
                    IRfNamedElement argumentKey = (IRfNamedElement)entry.getKey();
                    String argumentName = argumentKey.getName();
                    if (!argumentName.startsWith("list_of_arguments") || Check_R_1361.this.formatsString(argumentValue = (IHidObject)entry.getValue())) continue;
                    formatsString = false;
                    break;
                }
                if (!formatsString) continue;
                boolean isForce = LintUtils.isInsideXVMReportingMacro(Check_R_1361.this.fOVMProject.getLibraryKind() == 2, hidObject.getOccurrence().getReparseInfo());
                Check_R_1361.this.addHit(this.parserPath, hidObject.getOccurrence(), "Formatting strings using $sformatf!", isForce);
            }
            return true;
        }
    }
}

