/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="24.2.25")
@CheckID(value="R.1362")
@CheckName(value="R.1362")
@CheckLabel(labels={RuleLabel.CONDITIONAL, RuleLabel.PROCEDURAL_STATEMENT, RuleLabel.CASE})
@CheckTitle(value="Case statements should not have the same condition")
@CheckDescription(value="Any two case items of a case statement should not have the same expression.\n\nExamples:\ncase(var)\n  RED \t: ret = 1;\n  GREEN\t: ret = 2;\n  BLUE\t: ret = 3;\n  GREEN\t: ret = 4;  // NOT ALLOWED\nendcase\n\nCheck supports pre-waiving.")
public class Check_R_1362
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    public Check_R_1362(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<RfActionBlock> actionBlocks = this.fOVMProject.getRfProject().getAllActionBlocks();
        if (actionBlocks == null) {
            return;
        }
        for (RfActionBlock actionBlock : actionBlocks) {
            if (!actionBlock.isCase() || actionBlock.isRandCase() || this.checkPreWaivers(actionBlock.getFile())) continue;
            this.notifyCheckAlive();
            Collection<RfNamedElement> members = actionBlock.getMembers();
            if (members == null || members.isEmpty()) continue;
            HashMap<IHidObject, RfActionBlock> expressionToCaseItem = new HashMap<IHidObject, RfActionBlock>();
            for (RfNamedElement member : members) {
                RfActionBlock block;
                if (!(member instanceof RfActionBlock) || !(block = (RfActionBlock)member).isCaseItem()) continue;
                final IHidObject[] expression = new IHidObject[1];
                member.visitHidObject(null, new IHidVisitor<IHidObject>(){

                    public boolean visit(IHidObject hidObject) {
                        if (hidObject instanceof RfHidOperator && ((RfHidOperator)hidObject).isCaseItemCondition()) {
                            ListContainer values = ((RfHidOperator)hidObject).getRHValues();
                            if (values != null && !values.isEmpty()) {
                                expression[0] = (IHidObject)values.get(0);
                            }
                            return false;
                        }
                        return true;
                    }

                    public Class<IHidObject> getType() {
                        return IHidObject.class;
                    }
                });
                IHidObject sameExpression = this.getHidObjectWithSameExpression(expression[0], expressionToCaseItem.keySet());
                if (sameExpression == null) {
                    expressionToCaseItem.put(expression[0], block);
                    continue;
                }
                this.addHit(block, "Case item has same expression as '" + HidUtils.toNiceString((IHidObject)sameExpression) + "' from line " + this.link(String.valueOf(((RfActionBlock)expressionToCaseItem.get(sameExpression)).getLine()), ((RfActionBlock)expressionToCaseItem.get((Object)sameExpression)).getDeclaration().getDefFile().getParserPath().path, ((RfActionBlock)expressionToCaseItem.get(sameExpression)).getLine()) + "!");
            }
        }
    }

    private IHidObject getHidObjectWithSameExpression(IHidObject toCheck, Collection<IHidObject> checkAgainst) {
        for (IHidObject against : checkAgainst) {
            if (!LintUtils.compareExpressions(toCheck, against)) continue;
            return against;
        }
        return null;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

