/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessVisitor;

@CheckVersion(value="24.2.26")
@CheckID(value="R.1363")
@CheckName(value="R.1363")
@CheckLabel(labels={RuleLabel.PREDEFINED_METHOD, RuleLabel.PARENTHESIS})
@CheckTitle(value="Do not use parentheses for method calls")
@CheckDescription(value="According to the LRM, simulation time system functions ($time, $stime and $realtime for example) should not be followed by parenthesis.\nThe list of methods that should not be called with parentheses can be specified using the <methodNames> parameter.\n\nExamples:\n\n$time();\t// not allowed\n$time;\t// allowed\n\nCheck supports pre-waiving.")
public class Check_R_1363
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="$time, $stime, $realtime, $printtimescale", description="Comma separated list of full method names that should not be called with parentheses.", name="methodNames", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pMethodNamesValue;
    private static final String ERROR_MESSAGE = "Method call ''{0}'' should not have parentheses!";

    public Check_R_1363(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        if (this.pMethodNamesValue.isEmpty()) {
            this.signalParamError("No values specified for <methodNames> parameter!", true);
        }
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new LocalHidAccessVisitor());
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalHidAccessVisitor
    extends RfHidAccessVisitor {
        private LocalHidAccessVisitor() {
        }

        public boolean visit(RfHidAccess hidObject) {
            Hid parentHid = hidObject.getParentHid();
            if (!(parentHid instanceof RfHid)) {
                return true;
            }
            if (!parentHid.isMethodCall(false)) {
                return true;
            }
            if (Check_R_1363.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1363.this.notifyCheckAlive();
            IRfNamedElement element = ((RfHid)parentHid).getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)parentHid);
            for (MethodCall call : methodCalls) {
                RfFunction function;
                if (call.argumentValuesMapRaw != null || !(call.method instanceof RfFunction) || !Check_R_1363.this.pMethodNamesValue.contains(LintUtils.getNamedElementFullName(function = (RfFunction)call.method))) continue;
                Check_R_1363.this.addHit(this.parserPath, call.getOccurrence(), MessageFormat.format(Check_R_1363.ERROR_MESSAGE, HidUtils.toNiceString((IHidObject)parentHid)));
            }
            return true;
        }
    }
}

