/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractReportMacroIDCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;

@CheckVersion(value="24.2.28")
@CheckID(value="R.1365")
@CheckName(value="R.1365")
@CheckLabel(labels={RuleLabel.MESSAGING, RuleLabel.VERIFICATION, RuleLabel.REPORTING_MACRO})
@CheckTitle(value="Use unique IDs for XVM report macros")
@CheckDescription(value="XVM report macro IDs must be unique per each class hierarchy to be tracked easily.\nFunctions that always return the same string for a given class, specified by <pBannedMethods>, should also be used at most once as a reporting macro ID inside said class.\n\nExamples:\n\nclass a;\n  `uvm_warning(\"ID1\", \"MSG\")  \t\t// allowed\n  `uvm_warning(get_full_name(), \"MSG\")  // allowed\n  `uvm_info(\"ID2\", \"MSG\")     \t\t// allowed\n  `uvm_error(\"ID1\", \"MSG\")    \t\t// not allowed\n  `uvm_warning(get_full_name(), \"MSG\")  // not allowed\n\nclass b extends a;\n  `uvm_warning(\"ID2\", \"MSG\")  \t\t// not allowed; used in class a\n  `uvm_warning(get_full_name(), \"MSG\")  // allowed\n\nclass c;\n  `uvm_warning(\"ID1\", \"MSG\")  // allowed\n  `uvm_info(\"ID2\", \"MSG\")     // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1365
extends AbstractReportMacroIDCheck {
    @CheckParameter(defaultValue="get_full_name, get_name, get_type_name", description="Comma separated list of method names that should not be used more than once as IDs for reporting macros.", name="bannedMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected Set<String> pBannedMethods;
    private Map<RfClass, Map<String, Map<RfClass, MacroCall>>> macroIdPerClass;
    private Map<DVTPair<RfClass, String>, MacroCall> macroFunctionCallPerClass;

    public Check_R_1365(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.macroIdPerClass = new HashMap<RfClass, Map<String, Map<RfClass, MacroCall>>>();
        this.macroFunctionCallPerClass = new HashMap<DVTPair<RfClass, String>, MacroCall>();
        this.missingIDHit = false;
        super.performCheckImpl();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void checkFirstID(IHidObject idValue, HidOccurrence hidOccurence, String macroName, RfNamedElement scope) {
        RfHid rfHid;
        Hid hid;
        RfClass enclosingClass = scope.getEnclosingScope(RfClass.class);
        if (enclosingClass == null || scope.getFile() == null) {
            return;
        }
        RfHid rfHid2 = null;
        if (idValue instanceof RfHidAccessArgs && (hid = ((RfHidAccessArgs)idValue).getParentHid()) instanceof RfHid && (rfHid = (RfHid)hid) == (RfHid)hid) {
            void parentHid;
            rfHid2 = parentHid;
        } else if (idValue instanceof RfHid) {
            rfHid2 = (RfHid)idValue;
        }
        if (rfHid2 != null) {
            IRfNamedElement element = rfHid2.getElement();
            String elementName = element.getName();
            if (element == null || !(element instanceof RfFunction) || !this.pBannedMethods.contains(elementName)) {
                return;
            }
            Hid parentAccess = rfHid2.getParentHid();
            if (parentAccess != null && !"this".equals(parentAccess.getName())) {
                return;
            }
            MacroCall position = new MacroCall(scope.getFile().getParserPath(), hidOccurence.getLine(), hidOccurence.getOffset());
            DVTPair key = new DVTPair((Object)enclosingClass, (Object)elementName);
            if (!this.macroFunctionCallPerClass.containsKey(key)) {
                this.macroFunctionCallPerClass.put((DVTPair<RfClass, String>)key, position);
            } else {
                MacroCall lastPosition = this.macroFunctionCallPerClass.get(key);
                if (position.getFile() != lastPosition.getFile() || position.getLine() != lastPosition.getLine() || position.getOffset() != lastPosition.getOffset()) {
                    this.addHit(position.getFile(), position.getLine(), "Method '" + elementName + "' is used as ID for reporting macros multiple times in the class '" + LintUtils.getNamedElementFullName(enclosingClass) + "' !", null);
                }
            }
            return;
        }
        if (!(idValue instanceof RfHidImplicit) || !((RfHidImplicit)idValue).isStringLiteral()) {
            return;
        }
        String literalID = this.unquote(((RfHidImplicit)idValue).getName());
        if (literalID == null) {
            return;
        }
        RfClass initialScope = enclosingClass;
        while (enclosingClass.getParent() != null && !this.fOVMProject.isOVMElement(enclosingClass.getParent())) {
            enclosingClass = enclosingClass.getParent();
        }
        this.macroIdPerClass.putIfAbsent(enclosingClass, new HashMap());
        Map<String, Map<RfClass, MacroCall>> map = this.macroIdPerClass.get(enclosingClass);
        if (!map.containsKey(literalID)) {
            map.put(literalID, new HashMap());
            Map<RfClass, MacroCall> initialScopesToMacroCalls = map.get(literalID);
            initialScopesToMacroCalls.put(initialScope, new MacroCall(scope.getFile().getParserPath(), hidOccurence.getLine(), hidOccurence.getOffset()));
        } else {
            Map<RfClass, MacroCall> initialScopesToMacroCalls = map.get(literalID);
            RfClass scopeOfSameHierarchyTree = null;
            for (RfClass clazz : initialScopesToMacroCalls.keySet()) {
                if (this.areBrothers(clazz, initialScope, enclosingClass)) continue;
                scopeOfSameHierarchyTree = clazz;
                break;
            }
            if (scopeOfSameHierarchyTree == null) {
                initialScopesToMacroCalls.put(initialScope, new MacroCall(scope.getFile().getParserPath(), hidOccurence.getLine(), hidOccurence.getOffset()));
                return;
            }
            MacroCall position = initialScopesToMacroCalls.get(scopeOfSameHierarchyTree);
            if (position.getFile() != scope.getFile().getParserPath() || position.getLine() != hidOccurence.getLine() || position.getOffset() != hidOccurence.getOffset()) {
                this.addHit(scope.getFile().getParserPath(), hidOccurence.getLine(), "Duplicate ID \"" + literalID + "\" found in the hierarchy of class '" + LintUtils.getNamedElementFullName(initialScope) + "' !", null);
            }
        }
    }

    private boolean areBrothers(RfClass class1, RfClass class2, RfClass parent) {
        if (!LintUtils.isSubClassOf(class1, parent)) {
            return false;
        }
        if (!LintUtils.isSubClassOf(class2, parent)) {
            return false;
        }
        return !LintUtils.isSubClassOf(class1, class2) && !LintUtils.isSubClassOf(class2, class1);
    }

    private static class MacroCall {
        private ParserPath file;
        private int line;
        private int offset;

        public ParserPath getFile() {
            return this.file;
        }

        public int getLine() {
            return this.line;
        }

        public int getOffset() {
            return this.offset;
        }

        public MacroCall(ParserPath file, int line, int offset) {
            this.file = file;
            this.line = line;
            this.offset = offset;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof MacroCall)) {
                return false;
            }
            MacroCall macroCall = (MacroCall)obj;
            return this.file.equals((Object)macroCall.file) && this.line == macroCall.line && this.offset == macroCall.line;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

