/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="25.1.2")
@CheckID(value="R.1366")
@CheckName(value="R.1366")
@CheckLabel(labels={RuleLabel.VERIFICATION, RuleLabel.METHOD, RuleLabel.REGISTER})
@CheckTitle(value="uvm_reg.update() must be called after uvm_reg_field.set()")
@CheckDescription(value="This rule prevents the usage of uvm_reg_field.set() or uvm_reg.set() without an immediate uvm_reg.update() call in the same function.\n\nExamples:\n\ntask foo();\n  my_reg_obj.my_reg_field.set(reg_data);  //allowed\n  my_reg_obj.update();\nendtask\n\ntask foo();\n  my_reg_obj.my_reg_field.set(reg_data);  // not allowed\nendtask\n\nCheck supports pre-waiving.")
public class Check_R_1366
extends OVMComplianceCheck {
    RfClass uvmRegClass;
    RfClass uvmRegFieldClass;

    public Check_R_1366(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.uvmRegClass = this.fOVMProject.getRfProject().getClass("uvm_pkg::uvm_reg", true);
        this.uvmRegFieldClass = this.fOVMProject.getRfProject().getClass("uvm_pkg::uvm_reg_field", true);
        if (this.uvmRegClass == null || this.uvmRegFieldClass == null) {
            return;
        }
        NullProtectedList<RfNamedElement> allFunctionsAndTasks = new NullProtectedList<RfNamedElement>();
        allFunctionsAndTasks.addAll(this.fOVMProject.getAllFunctions());
        allFunctionsAndTasks.addAll(this.fOVMProject.getAllTasks());
        for (RfNamedElement function : allFunctionsAndTasks) {
            List<RfHid> list;
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(function.getDeclaration().getParserPath(), this)) continue;
            FunctionVisitor visitor = new FunctionVisitor();
            function.visitHidObject(null, visitor);
            for (Map.Entry<RfHidAccess, List<RfHid>> entry : visitor.getSetCall().entrySet()) {
                list = visitor.getUpdateCall().get((Object)entry.getKey());
                for (RfHid call : entry.getValue()) {
                    Hid parentHid = call.getParentHid();
                    IRfNamedElement element = parentHid.getElement();
                    if (element == null || !(element instanceof RfNamedElement) || list != null && !list.isEmpty() && list.stream().filter(x -> x.getOffset() > call.getOffset()).findAny().isPresent()) continue;
                    this.addHit(function.getDeclaration().getParserPath(), call, "'" + LintUtils.getHidFullName((IHid)call) + " call on '" + LintUtils.getNamedElementFullName((RfNamedElement)element) + "' in function '" + LintUtils.getNamedElementFullName(function) + "' must precede an 'uvm_reg.update()' call!");
                }
            }
            for (Map.Entry<Object, List<RfHid>> entry : visitor.getSetCallInReg().entrySet()) {
                list = visitor.getUpdateCallInReg().get(entry.getKey());
                for (RfHid call : entry.getValue()) {
                    if (list != null && !list.isEmpty() && list.stream().filter(x -> x.getOffset() > call.getOffset()).findAny().isPresent()) continue;
                    this.addHit(function.getDeclaration().getParserPath(), call, "'" + LintUtils.getHidFullName((IHid)call) + " call on '" + LintUtils.getNamedElementFullName((RfNamedElement)entry.getKey()) + "' in function '" + LintUtils.getNamedElementFullName(function) + "' must precede an 'uvm_reg.update()' call!");
                }
            }
        }
    }

    private final class FunctionVisitor
    implements IHidVisitor<IHidObject> {
        private static final String UVM_PKG_UVM_REG_UPDATE = "uvm_pkg::uvm_reg.update";
        private static final String UVM_PKG_UVM_REG_FIELD_SET = "uvm_pkg::uvm_reg_field.set";
        private static final String UVM_PKG_UVM_REG_SET = "uvm_pkg::uvm_reg.set";
        Map<RfHidAccess, List<RfHid>> setCalls = new HashMap<RfHidAccess, List<RfHid>>();
        Map<RfClass, List<RfHid>> setCallsInReg = new HashMap<RfClass, List<RfHid>>();
        Map<RfHidAccess, List<RfHid>> updateCalls = new HashMap<RfHidAccess, List<RfHid>>();
        Map<RfClass, List<RfHid>> updateCallsInReg = new HashMap<RfClass, List<RfHid>>();
        private RfNamedElement scope;

        private FunctionVisitor() {
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public boolean visit(IHidObject hidObject) {
            if (!(hidObject instanceof RfHid)) {
                return true;
            }
            RfHid rfHid = (RfHid)hidObject;
            if (!rfHid.isMethodCall(false)) {
                return true;
            }
            Check_R_1366.this.notifyCheckAlive();
            IRfNamedElement element = rfHid.getElement();
            if (element == null || !(element instanceof RfFunction)) {
                return true;
            }
            String namedElementFullName = LintUtils.getNamedElementFullName((RfFunction)element);
            if (UVM_PKG_UVM_REG_FIELD_SET.equals(namedElementFullName) || UVM_PKG_UVM_REG_SET.equals(namedElementFullName)) {
                HidAccess parentAccess = rfHid.getParentAccess();
                Hid parentHid = rfHid.getParentHid();
                if (parentHid == null || !(parentAccess instanceof RfHidAccess) || parentAccess.getAssociatedType() == null) {
                    RfClass enclosingScope = this.scope.getEnclosingScope(RfClass.class);
                    if (enclosingScope == null) {
                        return true;
                    }
                    if (!this.setCallsInReg.containsKey(enclosingScope)) {
                        this.setCallsInReg.put(enclosingScope, new ArrayList());
                    }
                    this.setCallsInReg.get(enclosingScope).add(rfHid);
                    return true;
                }
                IRfNamedElement associatedType = parentAccess.getAssociatedType();
                if (!(associatedType instanceof RfClass)) {
                    return true;
                }
                RfClass regClass = (RfClass)associatedType;
                if (LintUtils.isSubClassOf(regClass, Check_R_1366.this.uvmRegFieldClass)) {
                    HidAccess parentAccessField = parentHid.getParentAccess();
                    Hid parentHidField = parentHid.getParentHid();
                    if (parentHidField == null || "this".equals(parentHidField.getName()) || !(parentAccessField instanceof RfHidAccess) || parentAccessField.getAssociatedType() == null) {
                        IRfNamedElement elementField = parentHid.getElement();
                        if (elementField == null || !(elementField instanceof RfField)) {
                            return true;
                        }
                        RfClass enclosingScope = (RfClass)elementField.getEnclosingScope(RfClass.class);
                        if (enclosingScope == null) {
                            return true;
                        }
                        if (!this.setCallsInReg.containsKey(enclosingScope)) {
                            this.setCallsInReg.put(enclosingScope, new ArrayList());
                        }
                        this.setCallsInReg.get(enclosingScope).add(rfHid);
                        return true;
                    }
                    IRfNamedElement associatedTypeField = parentAccessField.getAssociatedType();
                    if (!(associatedTypeField instanceof RfClass)) {
                        return true;
                    }
                    regClass = (RfClass)associatedTypeField;
                    parentAccess = parentAccessField;
                }
                if (parentHid != null && LintUtils.isSubClassOf(regClass, Check_R_1366.this.uvmRegClass)) {
                    if ("this".equals(parentHid.getName())) {
                        RfClass enclosingScope = this.scope.getEnclosingScope(RfClass.class);
                        if (enclosingScope == null) {
                            return true;
                        }
                        if (!this.setCallsInReg.containsKey(enclosingScope)) {
                            this.setCallsInReg.put(enclosingScope, new ArrayList());
                        }
                        this.setCallsInReg.get(enclosingScope).add(rfHid);
                    } else {
                        if (!this.setCalls.containsKey(parentAccess)) {
                            this.setCalls.put((RfHidAccess)parentAccess, new ArrayList());
                        }
                        this.setCalls.get(parentAccess).add(rfHid);
                    }
                }
            } else if (UVM_PKG_UVM_REG_UPDATE.equals(namedElementFullName)) {
                HidAccess parentAccess = rfHid.getParentAccess();
                Hid parentHid = rfHid.getParentHid();
                if (parentHid == null || "this".equals(parentHid.getName()) || !(parentAccess instanceof RfHidAccess) || parentAccess.getAssociatedType() == null) {
                    RfClass enclosingScope = this.scope.getEnclosingScope(RfClass.class);
                    if (enclosingScope == null) {
                        return true;
                    }
                    if (!this.updateCallsInReg.containsKey(enclosingScope)) {
                        this.updateCallsInReg.put(enclosingScope, new ArrayList());
                    }
                    this.updateCallsInReg.get(enclosingScope).add(rfHid);
                    return true;
                }
                IRfNamedElement associatedType = parentAccess.getAssociatedType();
                if (!(associatedType instanceof RfClass)) {
                    return true;
                }
                RfClass regClass = (RfClass)associatedType;
                if (LintUtils.isSubClassOf(regClass, Check_R_1366.this.uvmRegClass)) {
                    if (!this.updateCalls.containsKey(parentAccess)) {
                        this.updateCalls.put((RfHidAccess)parentAccess, new ArrayList());
                    }
                    this.updateCalls.get(parentAccess).add(rfHid);
                }
            }
            return true;
        }

        public Map<RfHidAccess, List<RfHid>> getSetCall() {
            return this.setCalls;
        }

        public Map<RfClass, List<RfHid>> getSetCallInReg() {
            return this.setCallsInReg;
        }

        public Map<RfHidAccess, List<RfHid>> getUpdateCall() {
            return this.updateCalls;
        }

        public Map<RfClass, List<RfHid>> getUpdateCallInReg() {
            return this.updateCallsInReg;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

