/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfThisImplicitVariable;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="25.1.2")
@CheckID(value="R.1367")
@CheckName(value="R.1367")
@CheckLabel(labels={RuleLabel.VERIFICATION, RuleLabel.METHOD, RuleLabel.REGISTER})
@CheckTitle(value="Do not call uvm_reg_field.write/poke after uvm_reg_field.set() without an update() call in between")
@CheckDescription(value="Prevent the usage of uvm_reg/uvm_reg_field set() method followed by a write()/poke() call without an update() call in between.\nBy not calling the update method you risk writing unwanted data to your registers.\nNote that set, write, and poke are methods applicabale for both uvm_reg and uvm_reg_field, while update is only for uvm_reg.\n\nExamples:\n\nclass my_reg extends uvm_reg;\n  uvm_reg_field my_reg_field;\n\n  function foo_correct1();\n    this.my_reg_field.set();      // ALLOWED\n    this.update();\n    this.my_reg_field.write();\n  endfunction\n\n  function foo_correct2();\n    set();                        // ALLOWED\n    update();\n    write();\n  endfunction\nendclass\n\nclass my_reg_model;\n  my_reg my_reg_obj;\n\n  function foo_incorrect();\n    my_reg_obj.set();             // NOT ALLOWED\n    my_reg_field.poke();\n  endfunction\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1367
extends OVMComplianceCheck {
    private RfClass registerClass;
    private RfClass registerFieldClass;
    private Set<RfClass> regAndRegFieldClasses;
    private Set<String> checkedFunctions;
    DocumentManager documentManager;

    public Check_R_1367(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.documentManager = new DocumentManager(true);
        this.checkedFunctions = new HashSet<String>(Arrays.asList("set", "poke", "write", "update"));
        this.registerClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_reg"), true);
        this.registerFieldClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_reg_field"), true);
        this.regAndRegFieldClasses = new HashSet<RfClass>(Arrays.asList(this.registerClass, this.registerFieldClass));
        NullProtectedList<RfNamedElement> allFunctionsAndTask = this.fOVMProject.getAllFunctions();
        allFunctionsAndTask.addAll(this.fOVMProject.getAllTasks());
        for (RfNamedElement namedElem : allFunctionsAndTask) {
            if (!(namedElem instanceof RfFunction) || this.checkPreWaivers(namedElem.getDeclaration().getDefFile())) continue;
            this.notifyCheckAlive();
            RfFunction method = (RfFunction)namedElem;
            RfClass enclosingClass = method.getEnclosingScope(RfClass.class);
            MethodVisitor visitor = new MethodVisitor(enclosingClass);
            method.visitHidObject(null, visitor);
            Map<RegisterWrapper, List<Integer>> setCalls = visitor.getSetCalls();
            Map<RegisterWrapper, List<Integer>> updateCalls = visitor.getUpdateCalls();
            Map<RegisterWrapper, List<Integer>> writePokeCalls = visitor.getWriteAndPokeCalls();
            this.checkCalls(setCalls, updateCalls, writePokeCalls);
        }
        this.documentManager.deactivate();
    }

    /*
     * Unable to fully structure code
     */
    private void checkCalls(Map<RegisterWrapper, List<Integer>> setCalls, Map<RegisterWrapper, List<Integer>> updateCalls, Map<RegisterWrapper, List<Integer>> writePokeCalls) {
        block2: for (Map.Entry<RegisterWrapper, List<Integer>> setCall : setCalls.entrySet()) {
            regWrapper = setCall.getKey();
            document = this.documentManager.getDocument(regWrapper.functionCallParserPath, this.fOVMProject.getProject());
            regWrapperJustRegNoRegItem = new RegisterWrapper(regWrapper.uvmReg, null, null);
            if (!writePokeCalls.containsKey(regWrapper) && !writePokeCalls.containsKey(regWrapperJustRegNoRegItem)) continue;
            setCallsOffsets = setCall.getValue();
            writePokeCallsOffsets = writePokeCalls.getOrDefault(regWrapper, new ArrayList<E>());
            updateCallsOffsets = updateCalls.getOrDefault(regWrapper, new ArrayList<E>());
            if (regWrapper.uvmRegField != null) {
                writePokeCallsOffsets.addAll((Collection)writePokeCalls.getOrDefault(regWrapperJustRegNoRegItem, new ArrayList<E>()));
                updateCallsOffsets.addAll((Collection)updateCalls.getOrDefault(regWrapperJustRegNoRegItem, new ArrayList<E>()));
            }
            Collections.sort(setCallsOffsets);
            Collections.sort(writePokeCallsOffsets);
            Collections.sort(updateCallsOffsets);
            setIndex = 0;
            writePokeIndex = 0;
            updateIndex = 0;
            ** GOTO lbl41
            {
                ++writePokeIndex;
                do {
                    if (writePokeIndex < writePokeCallsOffsets.size() && (Integer)writePokeCallsOffsets.get(writePokeIndex) < setCallsOffsets.get(setIndex)) continue block3;
                    if (writePokeIndex < writePokeCallsOffsets.size()) ** GOTO lbl27
                    continue block2;
lbl-1000:
                    // 1 sources

                    {
                        ++updateIndex;
lbl27:
                        // 2 sources

                        ** while (updateIndex < updateCallsOffsets.size() && ((Integer)updateCallsOffsets.get((int)updateIndex)).intValue() < setCallsOffsets.get((int)setIndex).intValue())
                    }
lbl28:
                    // 1 sources

                    if (updateIndex >= updateCallsOffsets.size() || (Integer)updateCallsOffsets.get(updateIndex) > (Integer)writePokeCallsOffsets.get(writePokeIndex)) {
                        try {
                            setLine = document.getLineOfOffset(setCallsOffsets.get(setIndex).intValue()) + 1;
                            writePokeLine = document.getLineOfOffset(((Integer)writePokeCallsOffsets.get(writePokeIndex)).intValue()) + 1;
                            linkElement = regWrapper.getLinkElement();
                            linkString = "";
                            linkString = linkElement == null ? this.link("line " + String.valueOf(setLine), regWrapper.functionCallParserPath.path, setLine) : this.link(linkElement);
                            this.addHit(regWrapper.functionCallParserPath, setLine, "Set call of " + linkString + " is followed by a poke/write call on line " + this.link(String.valueOf(String.valueOf(writePokeLine)) + " of " + LintUtils.getFileShortName(regWrapper.functionCallParserPath.path), regWrapper.functionCallParserPath.path, writePokeLine) + " without a previous update call!", null);
                        }
                        catch (BadLocationException e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                    }
                    ++setIndex;
lbl41:
                    // 2 sources

                } while (setIndex < setCallsOffsets.size());
            }
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    private RegisterWrapper getClassWraperObjectFromHid(RfHidAccess hidAccess, ParserPath parserPathOfHid, RfClass enclosingClass) {
        HidAccess uvmReg = null;
        RfHidAccess uvmRegField = null;
        if (hidAccess.getParentHid() instanceof RfHid && hidAccess.getParentHid().getElement() instanceof RfThisImplicitVariable) {
            return new RegisterWrapper(enclosingClass, uvmRegField, parserPathOfHid);
        }
        RfClass firstAccessType = (RfClass)hidAccess.getAssociatedType();
        if (!LintUtils.isSubClassOf(firstAccessType, this.registerFieldClass)) {
            if (LintUtils.isSubClassOf(firstAccessType, this.registerClass)) {
                return new RegisterWrapper((Object)hidAccess, uvmRegField, parserPathOfHid);
            }
            return null;
        }
        uvmRegField = hidAccess;
        if (!(hidAccess.getParentHid() instanceof RfHid)) {
            return null;
        }
        RfHid hidOfFirstAccess = (RfHid)hidAccess.getParentHid();
        HidAccess secondHidAccess = hidOfFirstAccess.getParentAccess();
        if (secondHidAccess == null) {
            if (enclosingClass != null && LintUtils.isSubClassOf(enclosingClass, this.registerClass)) {
                return new RegisterWrapper(enclosingClass, uvmRegField, parserPathOfHid);
            }
            return null;
        }
        if (secondHidAccess.getParentHid() instanceof RfHid && secondHidAccess.getParentHid().getElement() instanceof RfThisImplicitVariable) {
            return new RegisterWrapper(enclosingClass, uvmRegField, parserPathOfHid);
        }
        IRfNamedElement secondAccessType = secondHidAccess.getAssociatedType();
        if (!(secondAccessType instanceof RfClass)) {
            return null;
        }
        if (!LintUtils.isSubClassOf((RfClass)secondAccessType, this.registerClass)) {
            return null;
        }
        uvmReg = secondHidAccess;
        return new RegisterWrapper(uvmReg, uvmRegField, parserPathOfHid);
    }

    private final class MethodVisitor
    implements IHidVisitor<RfHidAccessArgs> {
        private Map<RegisterWrapper, List<Integer>> setCalls = new HashMap<RegisterWrapper, List<Integer>>();
        private Map<RegisterWrapper, List<Integer>> updateCalls = new HashMap<RegisterWrapper, List<Integer>>();
        private Map<RegisterWrapper, List<Integer>> writePokeCalls = new HashMap<RegisterWrapper, List<Integer>>();
        private ParserPath parserPath;
        private RfClass enclosingClass;

        public MethodVisitor(RfClass enclosingClass) {
            this.enclosingClass = enclosingClass;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean visit(RfHidAccessArgs hidObject) {
            RegisterWrapper regWrapper;
            if (!(hidObject.getParentHid() instanceof RfHid)) {
                return true;
            }
            RfHid hid = (RfHid)hidObject.getParentHid();
            if (!(hid.getElement() instanceof RfFunction)) {
                return true;
            }
            RfFunction function = (RfFunction)hid.getElement();
            String funcName = function.getName();
            if (!Check_R_1367.this.checkedFunctions.contains(funcName)) {
                return true;
            }
            HidAccess hidParentAccess = hid.getParentAccess();
            if (hidParentAccess == null) {
                if (this.enclosingClass == null || !LintUtils.isSubClassOf(this.enclosingClass, Check_R_1367.this.registerClass)) return true;
                regWrapper = new RegisterWrapper(this.enclosingClass, null, this.parserPath);
            } else {
                if (!(hidParentAccess instanceof RfHidAccess)) {
                    return true;
                }
                RfHidAccess hidAccess = (RfHidAccess)hidParentAccess;
                IRfNamedElement firstAccessType = hidAccess.getAssociatedType();
                if (!(firstAccessType instanceof RfClass) || !LintUtils.isSubClassOfAny((RfClass)firstAccessType, Check_R_1367.this.regAndRegFieldClasses)) {
                    return true;
                }
                regWrapper = Check_R_1367.this.getClassWraperObjectFromHid(hidAccess, this.parserPath, this.enclosingClass);
                if (regWrapper == null) {
                    return true;
                }
            }
            if (funcName.equals("set")) {
                this.setCalls.putIfAbsent(regWrapper, new ArrayList());
                this.setCalls.get(regWrapper).add(hid.getOffset());
                return true;
            } else if (funcName.equals("update")) {
                this.updateCalls.putIfAbsent(regWrapper, new ArrayList());
                this.updateCalls.get(regWrapper).add(hid.getOffset());
                return true;
            } else {
                if (!funcName.equals("poke") && !funcName.equals("write")) return true;
                this.writePokeCalls.putIfAbsent(regWrapper, new ArrayList());
                this.writePokeCalls.get(regWrapper).add(hid.getOffset());
            }
            return true;
        }

        public Class<RfHidAccessArgs> getType() {
            return RfHidAccessArgs.class;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Map<RegisterWrapper, List<Integer>> getSetCalls() {
            return this.setCalls;
        }

        public Map<RegisterWrapper, List<Integer>> getUpdateCalls() {
            return this.updateCalls;
        }

        public Map<RegisterWrapper, List<Integer>> getWriteAndPokeCalls() {
            return this.writePokeCalls;
        }
    }

    private static class RegisterWrapper {
        Object uvmReg;
        HidAccess uvmRegField;
        ParserPath functionCallParserPath;

        public RegisterWrapper(Object uvmReg, HidAccess uvmRegField, ParserPath functionCallParserPath) {
            this.uvmReg = uvmReg;
            this.uvmRegField = uvmRegField;
            this.functionCallParserPath = functionCallParserPath;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            RegisterWrapper other = (RegisterWrapper)obj;
            return Objects.equals(this.uvmReg, other.uvmReg) && Objects.equals(this.uvmRegField, other.uvmRegField);
        }

        public int hashCode() {
            return Objects.hash(this.uvmReg, this.uvmRegField);
        }

        public RfNamedElement getLinkElement() {
            if (this.uvmRegField != null) {
                if (!(this.uvmRegField.getParentHid() instanceof RfHid)) {
                    return null;
                }
                RfHid fieldHid = (RfHid)this.uvmRegField.getParentHid();
                if (!(fieldHid.getElement() instanceof RfField)) {
                    return null;
                }
                return (RfField)fieldHid.getElement();
            }
            if (this.uvmReg != null) {
                if (this.uvmReg instanceof RfClass) {
                    return (RfClass)this.uvmReg;
                }
                if (this.uvmReg instanceof HidAccess) {
                    if (!(((HidAccess)this.uvmReg).getParentHid() instanceof RfHid)) {
                        return null;
                    }
                    RfHid regHid = (RfHid)((HidAccess)this.uvmReg).getParentHid();
                    if (!(regHid.getElement() instanceof RfField)) {
                        return null;
                    }
                    return (RfField)regHid.getElement();
                }
                return null;
            }
            return null;
        }
    }
}

