/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractTimescaleAtFileLevel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="25.1.3")
@CheckID(value="R.1368")
@CheckName(value="R.1368")
@CheckLabel(labels={RuleLabel.MODULE, RuleLabel.DIRECTIVE, RuleLabel.TIMESCALE})
@CheckTitle(value="Elements must include a timescale or a timeunit and timeprecision")
@CheckDescription(value="A file that contains an element of <elementKind> must include a file scoped (globally scoped) `timescale declaration OR must include within its body timeunit and timeprecision statements.\n\nExample for elementKind=module:\n`timescale 1ns / 1ps\n\n...\nmodule tb_top(...\n\nOR\n\nmodule mod();\n  timeunit 1s / 10s;\nendmodule\nCheck supports pre-waiving.")
@CheckParameterOverride(name="namePattern", description="", isVisible=false)
public class Check_R_1368
extends AbstractTimescaleAtFileLevel {
    @CheckParameter(defaultValue="false", description="When true, ensure that timeunit and timeprecision are present in elements that use any time calls.", name="checkOnlyIfTimeCalled", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckOnlyIfTimeCalled;
    @CheckParameter(defaultValue="interface,module,program,package", description="Only the specified element will be checked. One of the following: interface, module, program, package.", name="elementKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pElementKind;
    protected static final Set<String> TIME_CALLS = new HashSet<String>(Arrays.asList("$time", "$stime", "$realtime"));

    public Check_R_1368(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Collection<RfNamedElement> allComponents = this.getComponents();
        if (allComponents == null || allComponents.isEmpty()) {
            return;
        }
        Map<ParserPath, List<SVTBIssues>> allIssues = this.fOVMProject.getSVTBIssuesWithKind(37);
        for (RfNamedElement component : allComponents) {
            if (this.pCheckOnlyIfTimeCalled && !this.hasTimeCalls(component)) continue;
            boolean isComponentValid = this.analyzeComponent(allIssues, component);
            if (isComponentValid |= this.checkTimeUnitTimePrecision(component)) continue;
            this.addHit(component, String.valueOf(this.getComponentKind(component)) + " '" + LintUtils.getNamedElementFullName(component) + "' has no timescale or timeunit and timeprecision specified!");
        }
    }

    private boolean checkTimeUnitTimePrecision(RfNamedElement component) {
        if (this.isPrewaived(component)) {
            return true;
        }
        this.notifyCheckAlive();
        if (component instanceof RfModule) {
            RfModule module = (RfModule)component;
            if (!module.hasDirectiveTimeprecision()) {
                return false;
            }
            if (!module.hasDirectiveTimeunit()) {
                return false;
            }
        } else if (component instanceof RfInterface) {
            RfInterface intf = (RfInterface)component;
            if (!intf.hasDirectiveTimeprecision()) {
                return false;
            }
            if (!intf.hasDirectiveTimeunit()) {
                return false;
            }
        } else if (component instanceof RfProgram) {
            RfProgram program = (RfProgram)component;
            if (!program.hasDirectiveTimeprecision()) {
                return false;
            }
            if (!program.hasDirectiveTimeunit()) {
                return false;
            }
        } else if (component instanceof RfPackage) {
            RfPackage pkg = (RfPackage)component;
            if (!pkg.hasDirectiveTimeprecision()) {
                return false;
            }
            if (!pkg.hasDirectiveTimeunit()) {
                return false;
            }
        }
        return true;
    }

    private boolean hasTimeCalls(RfNamedElement element) {
        LocalHidVisitor localVisitor = new LocalHidVisitor();
        element.visitHidObject(this.fOVMProject.getRfProject(), localVisitor);
        return localVisitor.hasTimeCalls();
    }

    @Override
    protected String getComponentType() {
        return null;
    }

    @Override
    public Collection<RfNamedElement> getComponents() {
        NullProtectedList<RfNamedElement> components = new NullProtectedList<RfNamedElement>();
        if (this.pElementKind.contains("module")) {
            components.addAll(this.fOVMProject.getAllModules());
        }
        if (this.pElementKind.contains("interface")) {
            components.addAll(this.fOVMProject.getAllInterfaces());
        }
        if (this.pElementKind.contains("program")) {
            components.addAll(this.fOVMProject.getAllPrograms());
        }
        if (this.pElementKind.contains("package")) {
            components.addAll(this.fOVMProject.getAllPackages());
        }
        return components;
    }

    private String getComponentKind(RfNamedElement component) {
        if (component instanceof RfModule) {
            return "Module";
        }
        if (component instanceof RfInterface) {
            return "Interface";
        }
        if (component instanceof RfPackage) {
            return "Package";
        }
        if (component instanceof RfProgram) {
            return "Program";
        }
        return "";
    }

    private boolean isPrewaived(RfNamedElement element) {
        RfFileDef fileDef = element.getFile();
        return fileDef != null && this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    private final class LocalHidVisitor
    implements IHidVisitor<IHidObject> {
        private RfNamedElement scope;
        private boolean hasTimeCalls = false;

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public boolean visit(IHidObject hidObject) {
            RfFileDef file = this.scope.getFile();
            if (file == null) {
                return true;
            }
            if (hidObject instanceof RfHidOperator) {
                RfHidOperator hidOperator = (RfHidOperator)hidObject;
                if (hidOperator.hasOccurrence(HidOperatorQualifier.IS_DELAY_CONTROL)) {
                    this.hasTimeCalls = true;
                    return false;
                }
            } else if (hidObject instanceof RfHid && ((RfHid)hidObject).isMethodCall(false) && TIME_CALLS.contains(((RfHid)hidObject).getName())) {
                this.hasTimeCalls = true;
                return false;
            }
            return true;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }

        public boolean hasTimeCalls() {
            return this.hasTimeCalls;
        }
    }
}

