/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractLiteralComparison;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfRealScalarType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="25.1.4")
@CheckID(value="R.1369")
@CheckName(value="R.1369")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.COMPARISON})
@CheckTitle(value="Do not use comparison operators with real operands")
@CheckDescription(value="This check flags real operands used in equality comparisons.\nWhen comparing real values rounding should be considered because it is uncommon that real variables will have the same value.\n\nExample:\n\nreal a, b;\n\nif (a === 1)    //not allowed\nif (a == 1)     //not allowed\nif (a != b)     //not allowed\nif (a > 0.98)   //allowed\n\nCheck supports pre-waiving.")
public class Check_R_1369
extends AbstractLiteralComparison {
    @CheckParameter(defaultValue="", description="Comma separated list of variables that will be skipped.", name="skipVariables", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pSkipVariables;
    @CheckParameter(defaultValue="", description="Comma separated list of macro names that can be used as comparison values for real operands.", name="allowedMacroNames", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pAllowedMacroNames;
    public static final Set<HidFlatteningOption> SELECTS_AND_ARGS_EXCLUDED = Collections.unmodifiableSet(EnumSet.of(HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS, HidFlatteningOption.IGNORE_METHOD_CALL_ARGUMENTS));

    public Check_R_1369(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected void checkComparison(ParserPath path, HidOperator hidOperator, IHid lhValue, DVTPair<AbstractLiteralComparison.Type, Object> lhPair, IHid rhValue, DVTPair<AbstractLiteralComparison.Type, Object> rhPair) {
        if (hidOperator instanceof RfHidOperator && !((RfHidOperator)hidOperator).isEquality() && !((RfHidOperator)hidOperator).isInequality()) {
            return;
        }
        if (this.shouldSkipOperator(hidOperator)) {
            return;
        }
        if (this.checkOperatorValue(lhValue)) {
            this.addHit(path, (HidOccurrence)hidOperator.getOccurrence(), "Comparison of real value '" + lhValue.getName() + "' in " + HidUtils.toNiceString((IHidObject)hidOperator) + "!");
        } else if (this.checkOperatorValue(rhValue)) {
            this.addHit(path, (HidOccurrence)hidOperator.getOccurrence(), "Comparison of real value '" + rhValue.getName() + "' in " + HidUtils.toNiceString((IHidObject)hidOperator) + "!");
        }
    }

    private boolean checkOperatorValue(IHid value) {
        if (!(value instanceof RfHid)) {
            return false;
        }
        IRfNamedElement element = value.getElement();
        if (element == null || !(element instanceof RfField)) {
            return false;
        }
        RfNamedElement associatedType = LintUtils.getAssociatedFinalType((RfField)element);
        return associatedType != null && associatedType instanceof RfRealScalarType;
    }

    private boolean isAllowedMacroCall(IHid hid) {
        IReparseInfo iReparseInfo = hid.getReparseInfo();
        return iReparseInfo != null && this.pAllowedMacroNames.contains(iReparseInfo.getLastReparseMacroName());
    }

    private boolean shouldSkipOperator(HidOperator hidOperator) {
        if (this.pSkipVariables.isEmpty() && this.pAllowedMacroNames.isEmpty()) {
            return false;
        }
        Set hids = HidUtils.flattenToHids((IHidObject)hidOperator, SELECTS_AND_ARGS_EXCLUDED);
        if (hids == null) {
            return false;
        }
        for (IHid hid : hids) {
            if (this.isAllowedMacroCall(hid)) {
                return true;
            }
            IRfNamedElement elem = hid.getElement();
            if (!(elem instanceof RfField) || !this.pSkipVariables.contains(elem.getName())) continue;
            return true;
        }
        return false;
    }
}

