/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.TreeSet;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;

@CheckVersion(value="25.1.4")
@CheckID(value="R.1370")
@CheckName(value="R.1370")
@CheckLabel(labels={RuleLabel.MODULE, RuleLabel.PORT, RuleLabel.DESIGN_INSTANTIATION})
@CheckTitle(value="All ports should be connected when instantiating a module")
@CheckDescription(value="When instantiating a module, all ports should be connected.\nExplicitly unconnected ports are taken into account, but are not flagged because this may indicate designer's intent.\n\nExample\n\nmodule test(input in1, input in2);\nendmodule\n\nmodule top(input in);\n  test inst1(in);\t\t\t\t// NOT ALLOWED\n  test inst2(in, in);\t\t\t// ALLOWED\n  test inst3(in, );\t\t\t// ALLOWED\n  test inst4(.in1(), .in2());\t// ALLOWED\nendmodule\n\nCheck supports pre-waiving.")
public class Check_R_1370
extends OVMComplianceCheck {
    public Check_R_1370(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().accept(namedElement -> {
            if (namedElement instanceof RfInstance) {
                ListContainer ports;
                RfInstance instance = (RfInstance)namedElement;
                ParserPath parserPath = instance.getFile().getParserPath();
                if (this.checkPreWaivers(parserPath)) {
                    return true;
                }
                this.notifyCheckAlive();
                IRfDesignElement instanceType = instance.getInstantiatedDesign();
                if (instanceType == null || !(instanceType instanceof RfModule)) {
                    return true;
                }
                RfModule instantiatedModule = (RfModule)instanceType;
                HashSet<String> missingPorts = new HashSet<String>();
                for (IRfPortElement port : instantiatedModule.getLocalPorts()) {
                    missingPorts.add(port.getName());
                }
                RfHidHolder hidHolder = instance.getHidHolder();
                if (hidHolder != null && hidHolder.getHidObjectsMap() != null && (ports = (ListContainer)hidHolder.getHidObjectsMap().get(parserPath)) != null) {
                    for (Object port : ports) {
                        IRfNamedElement lhHidElement;
                        Object lhHid;
                        if (!(port instanceof IHidOperator) || ((IHidOperator)port).getOccurrence() == null || !((IHidOperator)port).getOccurrence().hasQualifier(HidQualifierCache.IS_PORT_CONNECTION_QUALIFIER)) continue;
                        IHidObject lhValue = ((IHidOperator)port).getLHValue();
                        if (lhValue instanceof RfHidImplicit) {
                            lhHid = (RfHidImplicit)lhValue;
                            if (!lhHid.isDotStarAssociation()) continue;
                            missingPorts.clear();
                            break;
                        }
                        if (!(lhValue instanceof RfHid) || (lhHidElement = (lhHid = (RfHid)lhValue).getElement()) == null) continue;
                        String elementName = lhHidElement.getName();
                        missingPorts.remove(elementName);
                    }
                }
                if (!missingPorts.isEmpty()) {
                    StringBuilder messagePortsMessage = new StringBuilder("");
                    for (Object port : new TreeSet(missingPorts)) {
                        messagePortsMessage.append(String.valueOf(port) + ", ");
                    }
                    messagePortsMessage.delete(messagePortsMessage.length() - 2, messagePortsMessage.length());
                    this.addHit(parserPath, instance.getLine(), "Instance " + instance + " does not connect ports: " + messagePortsMessage + "!", null);
                }
            }
            return true;
        });
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

