/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="25.1.4")
@CheckID(value="R.1371")
@CheckName(value="R.1371")
@CheckLabel(labels={RuleLabel.MODULE, RuleLabel.ASSIGNMENT})
@CheckTitle(value="Do not assign to a supply net")
@CheckDescription(value="This rule detects when a continuous assignment is made to a supply net.\nThe supply0 and supply1 nets can be used to model the power supplies in a circuit.\nThis is why supply nets cannot be driven.\n\nExample:\nsupply1 supp;\nassign supp = value;   //not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1371
extends OVMComplianceCheck {
    public Check_R_1371(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new LocalHidOperatorVisitor());
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    public class LocalHidOperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        private ParserPath parserPath;

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(RfHidOperator hidObject) {
            if (hidObject == null) {
                return true;
            }
            if (Check_R_1371.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1371.this.notifyCheckAlive();
            if (!hidObject.hasOccurrence(HidOperatorQualifier.IS_CONTINUOUS_ASSIGN)) {
                return true;
            }
            IHidObject lhValue = hidObject.getLHValue();
            if (lhValue == null || !(lhValue instanceof RfHid)) {
                return true;
            }
            IRfNamedElement element = ((RfHid)lhValue).getElement();
            if (element == null || !(element instanceof RfField)) {
                return true;
            }
            DataType dataType = ((RfField)element).getDataType();
            if (dataType == null) {
                return true;
            }
            String netType = dataType.getNetType();
            if (netType == null || !"supply0".equals(netType) && !"supply1".equals(netType)) {
                return true;
            }
            Check_R_1371.this.addHit(this.parserPath, (HidOccurrence)hidObject.getOccurrence(), "Supply net '" + LintUtils.getNamedElementFullName((RfField)element) + "' used in assignment!");
            return true;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

