/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashMap;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IReparseElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="25.1.4")
@CheckID(value="R.1372")
@CheckName(value="R.1372")
@CheckLabel(labels={RuleLabel.SINGULAR_DATA_TYPE, RuleLabel.COMPARISON, RuleLabel.MACRO, RuleLabel.AMS})
@CheckTitle(value="Do not use equality when comparing variables to `wrealXState and `wrealZState")
@CheckDescription(value="This rule checks that the macros `wrealXState and `wrealZState are always compared with other variables using the operator '===' instead of '=='.\nThese constants are not meant to be compared as normal numbers because of X/Z states and to prevent floating-point precision issues.\nThe rule also flags constants that are assigned to `wrealXState and `wrealZState.\n\nExample:\nconst real ANALOG_X = `wrealXState;\nif (real_var == ANALOG_X) begin // not allowed\nend\n\nif (real_var === `wrealZState) begin // allowed\nend\n\nCheck supports pre-waiving.")
public class Check_R_1372
extends OVMComplianceCheck {
    private static final String WREALXSTATE = "wrealXState";
    private static final String WREALZSTATE = "wrealZState";
    Map<IRfNamedElement, Map<String, String>> assignments;
    private final HidOperatorVisitor assignmentsVisitor = new HidOperatorVisitor(null){

        public boolean visit(HidOperator hidOperator) {
            IHidObject lhValueHid;
            ReparseInfo.ReparseElement reparseElement;
            RfHidImplicit rhHidImplicit;
            IReparseElement ireparseElement;
            if (Check_R_1372.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1372.this.notifyCheckAlive();
            if (!hidOperator.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN)) {
                return true;
            }
            String macroName = "";
            IHidObject rhValueHid = hidOperator.getFirstRHValue();
            if (rhValueHid instanceof RfHidImplicit && (ireparseElement = (rhHidImplicit = (RfHidImplicit)rhValueHid).getLastReparseElement()) instanceof ReparseInfo.ReparseElement && (Check_R_1372.WREALXSTATE.equals((reparseElement = (ReparseInfo.ReparseElement)ireparseElement).getReparseMacroName()) || Check_R_1372.WREALZSTATE.equals(reparseElement.getReparseMacroName()))) {
                macroName = reparseElement.getReparseMacroName();
            }
            if ((lhValueHid = hidOperator.getLHValue()) instanceof RfHidImplicit) {
                RfHidImplicit hidImplicit = (RfHidImplicit)lhValueHid;
                Check_R_1372.this.assignments.putIfAbsent(this.scope, new HashMap());
                Check_R_1372.this.assignments.get(this.scope).put(hidImplicit.getName(), macroName);
            }
            return true;
        }
    };
    private final HidOperatorVisitor comparatorsVisitor = new HidOperatorVisitor(null){

        public boolean visit(HidOperator hidOperator) {
            Map<String, String> fields;
            IRfNamedElement auxScope;
            RfField field;
            RfHid hid;
            IRfNamedElement elem;
            ReparseInfo.ReparseElement reparseElement;
            IReparseElement ireparseElement;
            ReparseInfo.ReparseElement reparseElement2;
            IReparseElement ireparseElement2;
            if (Check_R_1372.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1372.this.notifyCheckAlive();
            int operatorType = hidOperator.getOperatorType();
            if (operatorType != 482 && operatorType != 483) {
                return true;
            }
            IHidObject lhValueHid = hidOperator.getLHValue();
            IHidObject rhValueHid = hidOperator.getFirstRHValue();
            RfHidImplicit rhHidImplicit = null;
            RfHidImplicit lhHidImplicit = null;
            if (rhValueHid instanceof RfHidImplicit) {
                rhHidImplicit = (RfHidImplicit)rhValueHid;
            }
            if (lhValueHid instanceof RfHidImplicit) {
                lhHidImplicit = (RfHidImplicit)lhValueHid;
            }
            String macroUsed = "";
            boolean isRightWReal = false;
            if (rhHidImplicit != null && (ireparseElement2 = rhHidImplicit.getLastReparseElement()) instanceof ReparseInfo.ReparseElement && (Check_R_1372.WREALXSTATE.equals((reparseElement2 = (ReparseInfo.ReparseElement)ireparseElement2).getReparseMacroName()) || Check_R_1372.WREALZSTATE.equals(reparseElement2.getReparseMacroName()))) {
                isRightWReal = true;
                macroUsed = reparseElement2.getReparseMacroName();
            }
            boolean isLeftWReal = false;
            if (lhHidImplicit != null && (ireparseElement = lhHidImplicit.getLastReparseElement()) instanceof ReparseInfo.ReparseElement && (Check_R_1372.WREALXSTATE.equals((reparseElement = (ReparseInfo.ReparseElement)ireparseElement).getReparseMacroName()) || Check_R_1372.WREALZSTATE.equals(reparseElement.getReparseMacroName()))) {
                isLeftWReal = true;
                macroUsed = reparseElement.getReparseMacroName();
            }
            if (isLeftWReal || isRightWReal) {
                IHidObject notWreal = null;
                notWreal = isLeftWReal ? rhValueHid : lhValueHid;
                Check_R_1372.this.addHit(this.parserPath, hidOperator.getOccurrence().getLine(), "Illegal comparison of `" + macroUsed + " macro with " + HidUtils.toNiceString((IHidObject)notWreal) + "!", null);
                return true;
            }
            if (rhValueHid instanceof RfHid && (elem = (hid = (RfHid)rhValueHid).getElement()) instanceof RfField && ((field = (RfField)elem).isConst() || field.isParameter())) {
                auxScope = this.scope;
                while (auxScope != null) {
                    if (Check_R_1372.this.assignments.containsKey(auxScope) && (fields = Check_R_1372.this.assignments.get(auxScope)).containsKey(field.getName())) {
                        if (fields.get(field.getName()).equals("")) break;
                        isRightWReal = true;
                        macroUsed = fields.get(field.getName());
                        break;
                    }
                    auxScope = auxScope.getEnclosingScope();
                }
            }
            if (lhValueHid instanceof RfHid && (elem = (hid = (RfHid)lhValueHid).getElement()) instanceof RfField && ((field = (RfField)elem).isConst() || field.isParameter())) {
                auxScope = this.scope;
                while (auxScope != null) {
                    if (Check_R_1372.this.assignments.containsKey(auxScope) && (fields = Check_R_1372.this.assignments.get(auxScope)).containsKey(field.getName())) {
                        if (fields.get(field.getName()).equals("")) break;
                        isLeftWReal = true;
                        macroUsed = fields.get(field.getName());
                        break;
                    }
                    auxScope = auxScope.getEnclosingScope();
                }
            }
            if (!isLeftWReal && !isRightWReal) {
                return true;
            }
            IHidObject wreal = null;
            IHidObject notWreal = null;
            if (isLeftWReal) {
                wreal = lhValueHid;
                notWreal = rhValueHid;
            } else {
                wreal = rhValueHid;
                notWreal = lhValueHid;
            }
            Check_R_1372.this.addHit(this.parserPath, hidOperator.getOccurrence().getLine(), "Illegal comparison of constant " + HidUtils.toNiceString((IHidObject)wreal) + " assigned to macro `" + macroUsed + " with " + HidUtils.toNiceString((IHidObject)notWreal) + "!", null);
            return true;
        }
    };

    public Check_R_1372(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.assignments = new HashMap<IRfNamedElement, Map<String, String>>();
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)this.assignmentsVisitor);
        this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)this.comparatorsVisitor);
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

