/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPropertySequence;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="25.1.6")
@CheckID(value="R.1373")
@CheckName(value="R.1373")
@CheckLabel(labels={RuleLabel.PROCESS, RuleLabel.ALWAYS, RuleLabel.EVENT_CONTROL, RuleLabel.SIGNAL})
@CheckTitle(value="Do not use event controls in always_comb/always @(*) blocks")
@CheckDescription(value="According to LRM, signals inside event controls are not included in the sensitivity list.\nUsing event controls in always blocks may lead to unexpected behaviour.\n\nExamples:\n\nalways @(*) begin\n\t@(i) a = 1;\t\t\t// not allowed\nend\n\nCheck supports pre-waiving.")
public class Check_R_1373
extends OVMComplianceCheck {
    private static final String ERROR_MESSAGE = "{0} ''{1}'' used inside event control ''{2}'' in an {3} block!";

    public Check_R_1373(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<RfActionBlock> actionBlocks = this.fOVMProject.getRfProject().getAllActionBlocks();
        for (RfActionBlock actionBlock : actionBlocks) {
            RfDefElement actionBlockDeclaration;
            boolean isAlwaysAll;
            if (actionBlock == null || !actionBlock.isAlways() || actionBlock.isAlwaysFf()) continue;
            boolean bl = isAlwaysAll = actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS) && actionBlock.isAllSensitivityList();
            if (!actionBlock.isAlwaysComb() && !isAlwaysAll || (actionBlockDeclaration = actionBlock.getDeclaration()) == null || this.checkPreWaivers(actionBlockDeclaration.getParserPath())) continue;
            this.notifyCheckAlive();
            actionBlock.visitHidObject(null, (IHidVisitor<?>)new LocalHidOperatorVisitor(null, isAlwaysAll));
        }
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    class LocalHidOperatorVisitor
    extends HidOperatorVisitor {
        public boolean isAlwaysAll;

        public LocalHidOperatorVisitor(HidOperatorQualifier[] qualifiers, boolean isAlwaysAll) {
            super(qualifiers);
            this.isAlwaysAll = isAlwaysAll;
        }

        public boolean visit(HidOperator operator) {
            if (!(operator instanceof RfHidOperator)) {
                return true;
            }
            RfHidOperator hidOperator = (RfHidOperator)operator;
            if (!hidOperator.isEventControl()) {
                return true;
            }
            IHidObject lhValue = hidOperator.getLHValue();
            Set hids = HidUtils.flattenToHids((IHidObject)lhValue, (Set)HidFlatteningOption.IMPLICITS_EXCLUDED);
            for (IHid hid : hids) {
                boolean isSequence;
                if (!(hid instanceof RfHid)) continue;
                IRfNamedElement rhElement = ((RfHid)hid).getElement();
                boolean bl = isSequence = rhElement instanceof RfPropertySequence && ((RfPropertySequence)rhElement).isSequence();
                if (!(rhElement instanceof RfField) && !isSequence) {
                    return true;
                }
                Check_R_1373.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), MessageFormat.format(Check_R_1373.ERROR_MESSAGE, isSequence ? "Sequence" : "Signal", ((RfNamedElement)rhElement).getName(), HidUtils.toNiceString((IHidObject)hidOperator), this.isAlwaysAll ? "always @ *" : "always_comb"));
            }
            return true;
        }
    }
}

