/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="25.1.6")
@CheckID(value="R.1374")
@CheckName(value="R.1374")
@CheckLabel(labels={RuleLabel.MODULE, RuleLabel.PORT, RuleLabel.DESIGN_INSTANTIATION})
@CheckTitle(value="Inout ports should always be connected")
@CheckDescription(value="\nThis rule checks that module instances always connect their inout ports. Additionally, the rule flags the inout ports that are never used inside the module they are declared in.\nWhile such constructs are allowed by the LRM, they hide design flaws and may result in unwanted behavior.\n\nExamples:\n\nmodule foo(input i1);\n  test t1(i1);        // NOT ALLOWED: Unconnected and unused port 'io2'\n  test t2(.io2(i1));  // NOT ALLOWED: Unconnected port 'io1' and unused port 'io2'\nendmodule\n\nmodule test(inout io1, inout io2);\n  logic a;\n  task t1();\n    a += io1;\n  endtask\nendmodule\n\nCheck supports pre-waiving.")
public class Check_R_1374
extends OVMComplianceCheck {
    Map<RfModule, Map<RfPort, Boolean>> usedPortsInModule = new HashMap<RfModule, Map<RfPort, Boolean>>();

    public Check_R_1374(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().accept(namedElement -> {
            if (namedElement instanceof RfInstance) {
                ListContainer ports;
                RfInstance instance = (RfInstance)namedElement;
                ParserPath parserPath = instance.getFile().getParserPath();
                if (this.checkPreWaivers(parserPath)) {
                    return true;
                }
                this.notifyCheckAlive();
                IRfDesignElement instanceType = instance.getInstantiatedDesign();
                if (instanceType == null || !(instanceType instanceof RfModule)) {
                    return true;
                }
                RfModule instantiatedModule = (RfModule)instanceType;
                boolean areAllInstantiated = false;
                HashSet<IRfNamedElement> instantiatedPorts = new HashSet<IRfNamedElement>();
                RfHidHolder hidHolder = instance.getHidHolder();
                if (hidHolder != null && hidHolder.getHidObjectsMap() != null && (ports = (ListContainer)hidHolder.getHidObjectsMap().get(parserPath)) != null) {
                    for (IHidObject port : ports) {
                        IRfNamedElement lhHidElement;
                        Object lhHid;
                        if (!(port instanceof IHidOperator) || ((IHidOperator)port).getOccurrence() == null || !((IHidOperator)port).getOccurrence().hasQualifier(HidQualifierCache.IS_PORT_CONNECTION_QUALIFIER) || PortConnectionUtils.isUnconnected((IHidOperator)((IHidOperator)port))) continue;
                        IHidObject lhValue = ((IHidOperator)port).getLHValue();
                        if (lhValue instanceof RfHidImplicit) {
                            lhHid = (RfHidImplicit)lhValue;
                            if (!lhHid.isDotStarAssociation()) continue;
                            areAllInstantiated = true;
                            break;
                        }
                        if (!(lhValue instanceof RfHid) || (lhHidElement = (lhHid = (RfHid)lhValue).getElement()) == null) continue;
                        instantiatedPorts.add(lhHidElement);
                    }
                }
                for (IRfPortElement portElement : instantiatedModule.getLocalPorts()) {
                    RfPort port;
                    if (!(portElement instanceof RfPort) || !(port = (RfPort)portElement).isInout()) continue;
                    if (!areAllInstantiated && !instantiatedPorts.contains(port)) {
                        this.addHit(parserPath, instance.getLine(), "Instance " + instance + " does not connect inout port " + portElement.getName() + " !", null);
                    }
                    this.usedPortsInModule.putIfAbsent(instantiatedModule, new HashMap());
                    if (!this.usedPortsInModule.get(instantiatedModule).containsKey(port)) {
                        LocalHidVisitor localHidVisitor = new LocalHidVisitor(port);
                        instantiatedModule.visitHidObject(null, localHidVisitor);
                        this.usedPortsInModule.get(instantiatedModule).put(port, localHidVisitor.isPortFound());
                    }
                    if (this.usedPortsInModule.get(instantiatedModule).get(port).booleanValue()) continue;
                    this.addHit(parserPath, instance.getLine(), "Instantiated module " + this.link(instantiatedModule) + " is not using inout port " + port.getName() + "!", null);
                }
            }
            return true;
        });
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private static class LocalHidVisitor
    extends RfHidVisitor {
        RfPort lookForPort;
        boolean isFound;

        public LocalHidVisitor(RfPort lookForPort) {
            this.lookForPort = lookForPort;
            this.isFound = false;
        }

        public boolean visit(RfHid rfHid) {
            if (!(rfHid.getElement() instanceof RfPort)) {
                return true;
            }
            if (rfHid.getElement().equals(this.lookForPort)) {
                this.isFound = true;
                return false;
            }
            return true;
        }

        public boolean isPortFound() {
            return this.isFound;
        }
    }
}

