/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractWidthMissmatchCheck;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="25.1.6")
@CheckID(value="R.1375")
@CheckName(value="R.1375")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.WIDTH_MISMATCH})
@CheckTitle(value="Do not use bit-wise logical and arithmetic operators with different widths operands")
@CheckDescription(value="This check verifies that both arithmetic ('+', '-', '*', '/', '%') and bit-wise logical operations ('&', '|', '^', '~^', '^~') do not use elements of different widths.\n\nExamples:\n\nbit [2:0] array;\nbit [5:0] my_array;\n\nreturn array + my_array; // not allowed\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="ignoreIntTypeVariables", defaultValue="false", isVisible=false)
public class Check_R_1375
extends AbstractWidthMissmatchCheck {
    private static final Set<String> ALL_OPERATORS_TO_CHECK = new HashSet<String>(Arrays.asList("+", "+=", "-", "-=", "/", "/=", "*", "*=", "**", "%", "%=", "&", "~&", "|", "~|", "^", "~^", "^~", "&=", "|=", "^="));
    @CheckParameter(defaultValue="+, +=, -, -=, /, /=, *, *=, **, %, %=, &, ~&, |, ~|, ^, ~^, ^~, &=, |=, ^=", description="The operators to look for in an expression. Possible values: +, +=, -, -=, /, /=, *, *=, **, %, %=, &, ~&, |, ~|, ^, ~^, ^~, &=, |=, ^=", name="checkedOperators", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pCheckedOperators;

    public Check_R_1375(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        for (String opText : this.pCheckedOperators) {
            if (ALL_OPERATORS_TO_CHECK.contains(opText)) continue;
            this.signalParamError("Operator '" + opText + "' specified for `checkedOperators` is not allowed!", true);
        }
    }

    @Override
    public void performCheckImpl() {
        super.performCheckImpl();
        this.fOVMProject.getRfProject().visitHidObject(null, new AbstractWidthMissmatchCheck.OperatorVisitor());
    }

    @Override
    public boolean checkOperator(RfHidOperator operator) {
        return this.pCheckedOperators.contains(operator.getOperatorText());
    }

    @Override
    public String getHitMessageKind() {
        return "Width mismatch on operation";
    }
}

