/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Collection;
import java.util.List;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="25.1.6")
@CheckID(value="R.1376")
@CheckName(value="R.1376")
@CheckLabel(labels={RuleLabel.PROCEDURAL_STATEMENT, RuleLabel.CASE, RuleLabel.CONDITIONAL})
@CheckTitle(value="Default case item must be the last case item")
@CheckDescription(value="This check flags case statements where the default case item is not the last item of the statement.\nIt is recommended for the default case item to be the last one for better code readability and understanding.\n\nExamples:\n\ncase (foo)\n\tbar: a = 1;\n\tdefault: a = 0;\t\t// allowed\nendcase\n\ncase (foo)\n\tdefault: a = 0;\t\t// not allowed\n\tbar: a = 1;\nendcase\n\nCheck supports pre-waiving.")
public class Check_R_1376
extends OVMComplianceCheck {
    private static final String ERROR_MESSAGE = "Default case item is not the last item in the case statement!";

    public Check_R_1376(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<RfActionBlock> actionBlocks = this.fOVMProject.getRfProject().getAllActionBlocks();
        if (actionBlocks == null || actionBlocks.isEmpty()) {
            return;
        }
        for (RfActionBlock actionBlock : actionBlocks) {
            if (!actionBlock.isCase() || actionBlock.isRandCase()) continue;
            this.notifyCheckAlive();
            RfDefElement actionBlockDeclaration = actionBlock.getDeclaration();
            if (actionBlockDeclaration == null || this.checkPreWaivers(actionBlockDeclaration.getParserPath()) || actionBlockDeclaration.getReparseInfo() != null) continue;
            int maxCaseItemOffset = -1;
            int defaultCaseItemOffset = -1;
            Collection<RfNamedElement> members = actionBlock.getMembers();
            if (members == null || members.isEmpty()) continue;
            RfActionBlock defaultCaseItem = null;
            for (RfNamedElement member : members) {
                RfActionBlock actionBlockMember;
                if (!(member instanceof RfActionBlock) || !(actionBlockMember = (RfActionBlock)member).isCaseItem()) continue;
                int caseItemOffset = actionBlockMember.getOffset();
                if (caseItemOffset >= maxCaseItemOffset) {
                    maxCaseItemOffset = caseItemOffset;
                }
                if (!"default".equals(actionBlockMember.getExpression()) || caseItemOffset < defaultCaseItemOffset) continue;
                defaultCaseItemOffset = caseItemOffset;
                defaultCaseItem = actionBlockMember;
            }
            if (defaultCaseItemOffset == -1 || maxCaseItemOffset == -1 || defaultCaseItemOffset == maxCaseItemOffset) continue;
            this.addHit(defaultCaseItem, ERROR_MESSAGE);
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

