/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.elaboration.core.ELSpecializationWrapper;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractWidthMissmatchCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedGate;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="25.1.7")
@CheckID(value="R.1377")
@CheckName(value="R.1377")
@CheckLabel(labels={RuleLabel.MODULE, RuleLabel.WIDTH_MISMATCH})
@CheckTitle(value="Do not make multi-bit connections to primitive gates")
@CheckDescription(value="This rule flags bus connections to primitive gates such as: and, or, xor, nor, nand and xnor.\nIf a multi-bit signal is connected, it automatically expands to include extra bits, which can lead to unpredictable behavior, so it's better to manually connect each bit to the gate.\n\nExample:\nbit [3:0] out1, in1, in2;\nbit out2, in3, in4;\n\nor(out1, in1, in2);    //not allowed\nxnor(out2, in3, in4);  //allowed\n\nCheck supports pre-waiving.")
public class Check_R_1377
extends AbstractWidthMissmatchCheck {
    private static final Set<String> LOGIC_GATES = new HashSet<String>(Arrays.asList("and", "or", "xor", "nor", "nand", "xnor"));

    public Check_R_1377(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        super.performCheckImpl();
        NullProtectedList<RfNamedElement> allModules = this.fOVMProject.getAllModules();
        for (RfNamedElement module : allModules) {
            ParserPath parserPath = module.getDeclaration().getParserPath();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) {
                return;
            }
            Collection<RfNamedElement> members = module.getMembers();
            if (members == null || members.isEmpty()) continue;
            this.notifyCheckAlive();
            block1: for (RfNamedElement member : members) {
                RfHidHolder hidHolder;
                DataType dataType;
                if (member == null || !(member instanceof RfInstance) || (dataType = ((RfInstance)member).getDataType()) == null || !LOGIC_GATES.contains(dataType.getType()) || (hidHolder = member.getHidHolder()) == null || hidHolder.getHidObjectsMap() == null || hidHolder.getHidObjectsMap().isEmpty()) continue;
                RfPredefinedGate predefinedGate = RfPredefinedGate.PREDEFINED_GATES.get(dataType.getType());
                final ArrayList<IHidOperator> portConnections = new ArrayList<IHidOperator>();
                hidHolder.visitHidObject(this.fOVMProject.getRfProject(), (IHidVisitor)new IHidVisitor<RfHidOperator>(){

                    public boolean visit(RfHidOperator operator) {
                        if (operator.getOccurrence().hasQualifier(HidQualifierCache.IS_PORT_CONNECTION_QUALIFIER)) {
                            portConnections.add(operator);
                        }
                        return true;
                    }

                    public Class<RfHidOperator> getType() {
                        return RfHidOperator.class;
                    }
                });
                if (portConnections.isEmpty()) continue;
                Set<DummyPort> ports = predefinedGate.getDummyPorts((RfInstance)member, portConnections);
                Iterator<DummyPort> portsIterator = ports.iterator();
                for (IHidOperator portConnection : portConnections) {
                    Hid instanceHid;
                    RfField element;
                    RfNamedElement associatedType;
                    RfHid hid;
                    if (!portsIterator.hasNext()) continue block1;
                    DummyPort port = portsIterator.next();
                    ListContainer rhValues = ((RfHidOperator)portConnection).getRHValues();
                    if (rhValues == null || rhValues.size() != 1) continue;
                    IHidObject iHidObject = (IHidObject)rhValues.get(0);
                    IHidObject iHid = iHidObject;
                    if (iHid instanceof RfHidAccessArgs) {
                        iHid = ((RfHidAccessArgs)iHid).getParentHid();
                    }
                    if (iHid instanceof RfHidAccess) {
                        iHid = ((RfHidAccess)iHid).getParentHid();
                    }
                    if (iHid == null || !(iHid instanceof RfHid) || !port.isInput() || (hid = (RfHid)iHid).getElement() == null || !(hid.getElement() instanceof RfField) || (associatedType = this.getAssociatedFinalType(element = (RfField)hid.getElement())) == null || (instanceHid = this.getFirstParentInstanceHid(hid)) == null) continue;
                    IRfNamedElement instanceFieldOrFunction = instanceHid.getElement();
                    Map specializationWrappers = (Map)this.specsPerElement.get(module);
                    if (specializationWrappers == null || specializationWrappers.isEmpty() || !this.shouldEvaluateWithNonEmptyEvaluator(element, associatedType, true)) {
                        int[] sizeOfHid;
                        DataType dataTypePort = element.getDataType();
                        if (dataTypePort == null || dataTypePort.getUnpackedDimension() != null || (sizeOfHid = this.getSizeOfHid(iHidObject, element, associatedType, this.emptyEvaluator, null, module)) == null || !this.isHidMultibit(sizeOfHid)) continue;
                        this.addHit(parserPath, hid, "Multi-bit connection of '" + LintUtils.getHidFullName((IHid)hid) + "' with size " + this.getWidthAsString(sizeOfHid) + " in primitive logic gate '" + dataType.getType() + "'!");
                        continue;
                    }
                    for (ELSpecializationWrapper ancestorFieldWrapper : specializationWrappers.values()) {
                        String hierarhicalPath;
                        int[] sizeOfHid;
                        AbstractWidthMissmatchCheck.SpecInfo specInfo;
                        IHidEvaluator fieldSpecializationEvaluator;
                        IHidEvaluator defaultEvaluator = ancestorFieldWrapper.getHidEvaluator(this.elManager);
                        if (!(defaultEvaluator instanceof ELParamValuesHidEvaluator) || ancestorFieldWrapper.paths == null || !((fieldSpecializationEvaluator = (specInfo = this.getWrapperForInstance(instanceHid, instanceFieldOrFunction, specializationWrappers, defaultEvaluator, ancestorFieldWrapper.paths)).getEvaluator()) instanceof ELParamValuesHidEvaluator) || (sizeOfHid = this.getSizeOfHid(iHidObject, element, associatedType, (ELParamValuesHidEvaluator)fieldSpecializationEvaluator, ancestorFieldWrapper, module)) == null || !this.isHidMultibit(sizeOfHid)) continue;
                        String string = hierarhicalPath = specInfo.getPath() == null ? ancestorFieldWrapper.getPathsText() : specInfo.getPath();
                        if (hierarhicalPath == null) {
                            this.addHit(parserPath, hid, "Multi-bit connection of '" + LintUtils.getHidFullName((IHid)((RfHid)iHidObject)) + "' with size " + this.getWidthAsString(sizeOfHid) + " in primitive logic gate '" + dataType.getType() + "'!");
                            continue;
                        }
                        this.addHit(parserPath, hid, "Multi-bit connection of '" + LintUtils.getHidFullName((IHid)((RfHid)iHidObject)) + "' with size " + this.getWidthAsString(sizeOfHid) + " in primitive logic gate '" + dataType.getType() + "'!" + "\nHierarchy Path: " + hierarhicalPath);
                    }
                }
            }
        }
    }

    private boolean isHidMultibit(int[] sizeOfHid) {
        int i = 0;
        while (i < sizeOfHid.length) {
            if (sizeOfHid[i] != 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    @Override
    public boolean checkOperator(RfHidOperator operator) {
        return false;
    }
}

