/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="25.1.6")
@CheckID(value="R.1378")
@CheckName(value="R.1378")
@CheckLabel(labels={RuleLabel.LITERAL_VALUE, RuleLabel.FUNCTIONAL, RuleLabel.WIDTH_MISMATCH})
@CheckTitle(value="Do not use zero width based literal numbers")
@CheckDescription(value="This rule checks that there are no based numbers with zero width specified.\nThese zero width numbers are evaluated to 32-bit numbers, leading to unexpected results.\n\nExample:\n\n`define W 0\nbit a = 0'd0;   // not allowed\nbit b = `W'so7; // not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1378
extends OVMComplianceCheck {
    private static final String ZERO_WIDTH = "0'";
    private static final Pattern UNBASED_UNSIZED_LITERAL = Pattern.compile("^'[xz01]");

    public Check_R_1378(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new IHidVisitor<RfHidOperator>(){
            ParserPath parserPath;

            public boolean visit(RfHidOperator hidOperator) {
                ListContainer rhValue;
                if (Check_R_1378.this.checkPrewaivers(this.parserPath)) {
                    return true;
                }
                Check_R_1378.this.notifyCheckAlive();
                IHidObject lhValue = hidOperator.getLHValue();
                if (lhValue instanceof RfHidImplicit) {
                    this.checkHid((RfHidImplicit)lhValue, hidOperator.getOccurrence());
                }
                if ((rhValue = hidOperator.getRHValues()) == null || rhValue.size() > 1 || !(rhValue.get(0) instanceof RfHidImplicit)) {
                    return true;
                }
                this.checkHid((RfHidImplicit)rhValue.get(0), hidOperator.getOccurrence());
                return true;
            }

            private void checkHid(RfHidImplicit hidImplicit, HidOperatorOccurrence hidOperatorOccurrence) {
                Matcher m;
                if (!hidImplicit.isNumber()) {
                    return;
                }
                String hidImplicitName = hidImplicit.getName().toLowerCase();
                if (hidImplicitName.startsWith(Check_R_1378.ZERO_WIDTH)) {
                    Check_R_1378.this.addHit(this.parserPath, (HidOccurrence)hidOperatorOccurrence, "Forbiden use of zero width based literal number " + hidImplicit.getName() + "!");
                } else if (hidImplicitName.startsWith("'") && !(m = UNBASED_UNSIZED_LITERAL.matcher(hidImplicitName)).matches()) {
                    Check_R_1378.this.addHit(this.parserPath, (HidOccurrence)hidOperatorOccurrence, "Forbiden use of unspecified width based literal number " + hidImplicit.getName() + "!");
                }
            }

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            public Class<RfHidOperator> getType() {
                return RfHidOperator.class;
            }
        });
    }

    private boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

