/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.buildconfig.ElaborationDebugZone;
import ro.amiq.dvt.buildconfig.ElaborationExpressionControl;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELBuildPhase;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.core.ELManagerConfiguration;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="25.1.7")
@CheckID(value="R.1379")
@CheckName(value="R.1379")
@CheckLabel(labels={RuleLabel.ASSIGNMENT})
@CheckTitle(value="Do not assign negative values to unsigned variables")
@CheckDescription(value="This check flags assignments of negative values to unsigned variables.\nDoing so will assign an underflowed value to the variable.\n\nExamples:\n\nint unsigned a;\na = -1;\t\t\t// not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1379
extends OVMComplianceCheck {
    private static final String ERROR_MESSAGE = "Negative value ''{0}'' assigned to unsigned variable ''{1}''!";
    private static final HidOperatorQualifier[] ASSIGNMENT_QUALIFIERS = new HidOperatorQualifier[]{HidOperatorQualifier.IS_CONTINUOUS_ASSIGN, HidOperatorQualifier.IS_BLOCKING_ASSIGN, HidOperatorQualifier.IS_NONBLOCKING_ASSIGN, HidOperatorQualifier.IS_DECLARATION_ASSIGN, HidOperatorQualifier.IS_PROCEDURAL_CONTINUOUS_ASSIGN, HidOperatorQualifier.IS_PROCEDURAL_FORCE_ASSIGN};
    private ELManager elManager;
    private ELParamValuesHidEvaluator emptyEvaluator;

    public Check_R_1379(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        ELManager elabManager = rfProject.getELManager();
        RfMixedLangProject mixedLangProjectParent = rfProject.getMixedLangProjectParent();
        this.elManager = new ELManager(mixedLangProjectParent, IELMemory.ELMemoryType.STANDARD, ELBuildPhase.NONE, ELManagerConfiguration.newDummyWithControlConfig((boolean)false, EnumSet.noneOf(ElaborationExpressionControl.class), new HashSet(), (boolean)false), mixedLangProjectParent.getNonElabConstantsManager(), EnumSet.noneOf(ElaborationDebugZone.class));
        IELMemory elabMem = elabManager != null ? elabManager.getMemory() : null;
        this.elManager.addToMemory(elabMem);
        this.emptyEvaluator = ELParamValues.EMPTY.getHidEvaluator(this.elManager);
        rfProject.visitHidObject(null, (IHidVisitor<?>)new LocalHidOperatorVisitor(null));
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalHidOperatorVisitor
    extends HidOperatorVisitor {
        public LocalHidOperatorVisitor(HidOperatorQualifier[] qualifiers) {
            super(qualifiers);
        }

        public boolean visit(HidOperator operator) {
            IHidEvaluationGuardian guardian;
            BitVectorContext context;
            if (Check_R_1379.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            boolean isAssignment = false;
            HidOperatorQualifier[] hidOperatorQualifierArray = ASSIGNMENT_QUALIFIERS;
            int n = ASSIGNMENT_QUALIFIERS.length;
            int n2 = 0;
            while (n2 < n) {
                HidOperatorQualifier qualifier = hidOperatorQualifierArray[n2];
                if (operator.hasOccurrence(qualifier)) {
                    isAssignment = true;
                    break;
                }
                ++n2;
            }
            if (!isAssignment) {
                return true;
            }
            Check_R_1379.this.notifyCheckAlive();
            IHidObject lhValue = operator.getLHValue();
            if (operator.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN) ? !this.checkUnsignedDeclarationLHValue(operator) : !this.checkUnsignedLHValue(lhValue)) {
                return true;
            }
            ListContainer rhValues = operator.getRHValues();
            if (rhValues == null || rhValues.isEmpty() || rhValues.size() > 1) {
                return true;
            }
            IHidObject rhValue = (IHidObject)rhValues.get(0);
            if (!this.checkNegativeRHValue(rhValue, context = BitVectorContext.of((IRfNamedElement)this.scope, (boolean)false), guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)this.scope, null, (boolean)false, (ELManager)Check_R_1379.this.elManager))) {
                return true;
            }
            Check_R_1379.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), MessageFormat.format(Check_R_1379.ERROR_MESSAGE, HidUtils.toNiceString((IHidObject)rhValue), HidUtils.toNiceString((IHidObject)lhValue)));
            return true;
        }

        public boolean checkUnsignedLHValue(IHidObject lhValue) {
            if (!(lhValue instanceof RfHid)) {
                return false;
            }
            RfHid lhHid = (RfHid)lhValue;
            IRfNamedElement lhElement = lhHid.getElement();
            if (!(lhElement instanceof RfField)) {
                return false;
            }
            RfField lhField = (RfField)lhElement;
            DataType dataType = lhField.getDataType();
            if (dataType == null) {
                return false;
            }
            return this.isDefaultUnsigned(dataType) || dataType.getSign() == 2;
        }

        public boolean checkUnsignedDeclarationLHValue(HidOperator operator) {
            ISDataAbstract resolvedType = operator.getOperatorResolvedType();
            if (resolvedType == null) {
                return false;
            }
            ISDataType dataType = SDataUtils.getDataType((ISDataAbstract)resolvedType);
            if (dataType == null) {
                return false;
            }
            return dataType.getSign() == 2;
        }

        public boolean isDefaultUnsigned(DataType dataType) {
            String typeName = dataType.getTypeName(null, null);
            if (typeName == null || typeName.contains("signed")) {
                return false;
            }
            String type = dataType.getType();
            if (type == null) {
                return false;
            }
            switch (type) {
                case "bit": 
                case "reg": 
                case "time": 
                case "logic": {
                    return true;
                }
            }
            return false;
        }

        public boolean checkNegativeRHValue(IHidObject rhValue, BitVectorContext context, IHidEvaluationGuardian guardian) {
            Set hids = HidUtils.flattenToHids((IHidObject)rhValue, (Set)HidFlatteningOption.IMPLICITS_EXCLUDED);
            if (hids == null || !hids.isEmpty()) {
                return false;
            }
            IELParamValue value = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)rhValue, (IHidEvaluator)Check_R_1379.this.emptyEvaluator, (BitVectorContext)context, (IHidEvaluationGuardian)guardian));
            if (ELUtils.isUnsuccessfulEval((IELParamValue)value) || !(value instanceof ELParamValues.ParamValueNumber)) {
                return false;
            }
            return value.intValue() < 0;
        }
    }
}

