/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="25.1.7")
@CheckID(value="R.1380")
@CheckName(value="R.1380")
@CheckLabel(labels={RuleLabel.SINGULAR_DATA_TYPE, RuleLabel.SELECT})
@CheckTitle(value="Do not use selects on time or integer variables")
@CheckDescription(value="This rule flags the use of bit-selects or range selects on fields of type integer or time.\nInteger and time variables are 4 state types and having a select on such types indicates the intent for bit manipulation.\nUsing logic and reg types underlines this purpose, making the code easier to understand.\n\nExamples:\n\ninteger i;\nlogic[15:0] j;\n\nif (i[0] == 0)   //not allowed\nif (j[0] == 1)   //allowed\n\nCheck supports pre-waiving.")
public class Check_R_1380
extends OVMComplianceCheck {
    private static final Set<String> fCheckedTypes = new HashSet<String>(Arrays.asList("time", "integer"));

    public Check_R_1380(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new LocalVisitor());
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    public class LocalVisitor
    extends RfHidVisitor {
        public boolean visit(RfHid hidObject) {
            if (Check_R_1380.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1380.this.notifyCheckAlive();
            if (LintUtils.isBitSelect(hidObject, fCheckedTypes)) {
                Check_R_1380.this.addHit(this.parserPath, hidObject, "Do not use bit selects on field '" + LintUtils.getHidFullName((IHid)hidObject) + "'!");
            }
            return true;
        }
    }
}

