/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import ro.amiq.dvt.elaboration.core.ELSpecializationWrapper;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractMultipleOperandsAllAssignmentsWidthMissmatchCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="25.1.7")
@CheckID(value="R.1381")
@CheckName(value="R.1381")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.ASSIGNMENT, RuleLabel.WIDTH_MISMATCH})
@CheckTitle(value="Do not assign to a variable of a smaller width as the result of an addition or subtraction")
@CheckDescription(value="This rule reports assignments where an addition or subtraction operation is being assigned to a variable of smaller width than the expected width of the given operation.\nSuch patterns can lead to a possible loss of carry or borrow.\nFor addition operations where all operands are unsigned, the minimum width size of the result is the maximum width of the operands plus 1.\nFor addition operations where at least one operand is signed, the minimum width size of the result is the maximum width of the operands plus 1, plus an additional bit to represent the sign.\nFor subtraction operations where all operands are unsigned, the minimum width size of the result is the maximum width of the operands.\nFor subtraction operations where at least one operand is signed, the minimum width size of the result is the maximum width of the operands plus an additional bit to represent the sign.\nIn the case of implicit values, according to the LRM, chapter 5.7.1, unsized literals are considered as 32-bit signed integers, while sized literals get their dimension from the specified size and their signing according to the 's' or 'S' option.\nReturn statements and method arguments are also checked.\n\nExamples:\n\nreg [3:0] e, f;\nreg [2:0] g;\nassign g = e + f;     // NOT ALLOWED\n\nfunction bit[3:0] my_function(int a, int b);\n  return a + b;       // NOT ALLOWED\nendfunction\n\nint a, b;\na = b + 32'sb0;\t\t// ALLOWED, int types are skipped by default\n\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="ignoreIntTypeVariables", defaultValue="false", isVisible=false)
public class Check_R_1381
extends AbstractMultipleOperandsAllAssignmentsWidthMissmatchCheck {
    @CheckParameter(defaultValue="int", description="Skip assignments where all the operands from both sides are of this type. Implicit values are ignored if their size is the same as that of the type. Possible values: shortint, int, longint, byte, bit, logic, reg, integer, time", name="skipTypes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pSkipTypes;
    private final Set<Integer> primitiveTypesSize = new HashSet<Integer>();

    @Override
    public void configure() {
        super.configure();
        for (String type : this.pSkipTypes) {
            int size = RfBitVectorScalarType.getBitSize(type);
            if (size == -2) {
                this.signalParamError("Invalid scalar type '" + type + "' for parameter skipTypes!", true);
            }
            this.primitiveTypesSize.add(size);
        }
    }

    public Check_R_1381(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public boolean checkOperator(RfHidOperator operator) {
        return operator.isAssignment() || operator.isReturnStatement() || operator.hasOccurrence(HidQualifierCache.IS_DECLARATION_ASSIGN_QUALIFIER);
    }

    @Override
    public void checkSizes(List<RfHidImplicit> implicitsInRight, IHidObject lhValueHidObject, List<IHidObject> nonImplicitsInRightHSide, IHidObject rhHidObject, List<IHidObject> hidObjects, List<IRfNamedElement> elements, List<RfNamedElement> elementTypes, List<ELParamValuesHidEvaluator> hidEvaluators, ParserPath parserPath, RfHidOperator operator, Map<IHidObject, String> pathsText, boolean hasPathsText, ELSpecializationWrapper specsWrapper, String missmatchType, IRfNamedElement scope) {
        HashMap<IHidObject, int[]> fieldDimensionsForHid = new HashMap<IHidObject, int[]>();
        for (RfHidImplicit implicit : implicitsInRight) {
            this.calculateSizeOfImplicit(implicit, fieldDimensionsForHid, scope);
        }
        if (this.checkIfSkipTypes(fieldDimensionsForHid.values(), lhValueHidObject, nonImplicitsInRightHSide)) {
            return;
        }
        List fieldDimensionsInfo = IntStream.range(0, hidObjects.size()).mapToObj(index -> this.getSizeOfHid((IHidObject)hidObjects.get(index), (IRfNamedElement)elements.get(index), (IRfNamedElement)elementTypes.get(index), (ELParamValuesHidEvaluator)hidEvaluators.get(index), specsWrapper, scope)).collect(Collectors.toList());
        if (fieldDimensionsInfo.contains(null)) {
            return;
        }
        List fieldDimensionsInfoExpanded = fieldDimensionsInfo.stream().map(dimensions -> {
            int[] nArray;
            if (((int[])dimensions).length == 1) {
                int[] nArray2 = new int[2];
                nArray = nArray2;
                nArray2[0] = this.getNumberOfBitsUsedInInteger(dimensions[0]) - 1;
            } else {
                nArray = dimensions;
            }
            return nArray;
        }).collect(Collectors.toList());
        int maxNrOfDimensions = fieldDimensionsInfoExpanded.stream().mapToInt(fieldDimensions -> ((int[])fieldDimensions).length).max().orElse(0);
        fieldDimensionsInfoExpanded = fieldDimensionsInfoExpanded.stream().map(arr -> ((int[])arr).length == maxNrOfDimensions ? arr : Arrays.copyOf(arr, maxNrOfDimensions)).collect(Collectors.toList());
        int[] lhDimensionsInfo = (int[])fieldDimensionsInfoExpanded.get(0);
        int i = 1;
        while (i < hidObjects.size()) {
            fieldDimensionsForHid.put(hidObjects.get(i), (int[])fieldDimensionsInfoExpanded.get(i));
            ++i;
        }
        int[] rhSize = this.calculateSizeOfHid(rhHidObject, fieldDimensionsForHid);
        if (this.isHidObjectSigned(rhHidObject)) {
            rhSize = this.addDimensionToArray(rhSize);
        }
        boolean isMissmatch = false;
        if (lhDimensionsInfo.length == rhSize.length) {
            int i2 = 0;
            while (i2 < lhDimensionsInfo.length) {
                if (rhSize[i2] > lhDimensionsInfo[i2]) {
                    isMissmatch = true;
                    break;
                }
                i2 += 2;
            }
        }
        if (!isMissmatch) {
            return;
        }
        StringBuilder hitMessage = new StringBuilder("");
        hitMessage.append("Possible overflow on " + missmatchType + ": " + HidUtils.toNiceString((IHidObject)operator) + "!");
        if (hasPathsText) {
            hitMessage.append("\n\nHierarchy Paths for:");
            for (Map.Entry<IHidObject, String> pathsEntry : pathsText.entrySet()) {
                hitMessage.append("\n  '").append(HidUtils.toNiceString((IHidObject)pathsEntry.getKey())).append("': ").append(pathsEntry.getValue());
            }
        }
        this.addHit(parserPath, (HidOccurrence)operator.getOccurrence(), hitMessage.toString());
    }

    private boolean checkIfSkipTypes(Collection<int[]> sizesOfImplicits, IHidObject lhValueHidObject, Collection<IHidObject> nonImplicitsInRightHSide) {
        if (!this.checkIfSkipTypes(lhValueHidObject, this.pSkipTypes)) {
            return false;
        }
        for (IHidObject hidInRightHSide : nonImplicitsInRightHSide) {
            if (this.checkIfSkipTypes(hidInRightHSide, this.pSkipTypes)) continue;
            return false;
        }
        for (int[] sizeOfImplicit : sizesOfImplicits) {
            if (sizeOfImplicit.length == 0) continue;
            if (sizeOfImplicit.length != 2) {
                return false;
            }
            if (this.primitiveTypesSize.contains(sizeOfImplicit[0] - sizeOfImplicit[1] + 1)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected int[] calculateSizeOfHid(IHidObject hidObject, Map<IHidObject, int[]> fieldDimensionsForHid) {
        if (hidObject instanceof RfHidOperator) {
            RfHidOperator operator = (RfHidOperator)hidObject;
            IHidObject lhOperand = operator.getLHValue();
            IHidObject rhOperand = operator.getFirstRHValue();
            int[] result = this.getMaximumOfArrays(this.calculateSizeOfHid(lhOperand, fieldDimensionsForHid), this.calculateSizeOfHid(rhOperand, fieldDimensionsForHid));
            if (operator.isPlus()) {
                result = this.addDimensionToArray(result);
            }
            return result;
        }
        return fieldDimensionsForHid.getOrDefault(hidObject, null);
    }

    private boolean isHidObjectSigned(IHidObject hidObject) {
        if (hidObject instanceof RfHidOperator) {
            return this.isHidObjectSigned(((RfHidOperator)hidObject).getLHValue()) || this.isHidObjectSigned(((RfHidOperator)hidObject).getFirstRHValue());
        }
        if (hidObject instanceof RfHidAccessArgs) {
            hidObject = ((RfHidAccessArgs)hidObject).getParentHid();
        }
        if (hidObject instanceof RfHidAccess) {
            hidObject = ((RfHidAccess)hidObject).getParentHid();
        }
        if (hidObject instanceof RfHidImplicit) {
            return LintUtils.isSigned((RfHidImplicit)hidObject);
        }
        if (hidObject instanceof RfHid) {
            if (!(((RfHid)hidObject).getElement() instanceof RfAssociatedType)) {
                return false;
            }
            return LintUtils.isSigned(((RfAssociatedType)((RfHid)hidObject).getElement()).getDataType());
        }
        return false;
    }

    @Override
    protected boolean checkOperatorsInRHSide(RfHidOperator operator) {
        return operator.isPlus() || operator.isMinus();
    }

    @Override
    protected boolean checkRhSideHid(IHidObject hidObject) {
        return hidObject instanceof RfHidOperator;
    }
}

