/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="25.1.7")
@CheckID(value="R.1382")
@CheckName(value="R.1382")
@CheckLabel(labels={RuleLabel.MESSAGING, RuleLabel.OBJECT, RuleLabel.VERIFICATION})
@CheckTitle(value="Object printing should be guarded with a verbosity check")
@CheckDescription(value="This rule checks that all calls of the xvm_pkg::xvm_object.print method are guarded by a verbosity check of xvm_report_enabled.\nThis way all object printing is dependent on the desired verbosity.\n\nExample:\n\nxvm_object myObj;\nmyObj.print();\t// not allowed\nif (xvm_report_enabled(XVM_DEBUG, XVM_INFO, \"id\"))\n  myObj.print();\t// allowed\n\nCheck supports pre-waiving.")
public class Check_R_1382
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="xvm_pkg::xvm_object", description="Base class for which the extending classes should not call the print method without a verbosity check.", name="baseClass", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    protected String pBaseClass;
    private String xvmReportEnabledFullName;
    private String xvmReportEnabled;
    private String xvmPrintMethod;

    public Check_R_1382(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        if (this.fOVMProject.getLibraryKind() == 2) {
            this.xvmReportEnabledFullName = "uvm_pkg::uvm_report_enabled";
            this.xvmReportEnabled = "uvm_report_enabled";
            this.xvmPrintMethod = "uvm_pkg::uvm_object.print";
        } else if (this.fOVMProject.getLibraryKind() == 1) {
            this.xvmReportEnabledFullName = "ovm_pkg::ovm_report_enabled";
            this.xvmReportEnabled = "ovm_report_enabled";
            this.xvmPrintMethod = "ovm_pkg::ovm_object.print";
        }
    }

    @Override
    public void performCheckImpl() {
        final RfClass baseClass = this.fOVMProject.getRfProject().getClass(this.pBaseClass, true);
        this.fOVMProject.getRfProject().visitHidObject(null, new IHidVisitor<RfHid>(){
            RfNamedElement scope;
            ParserPath parserPath;

            public boolean visit(RfHid hid) {
                Check_R_1382.this.notifyCheckAlive();
                if (Check_R_1382.this.checkPreWaivers(this.scope.getFile())) {
                    return true;
                }
                IRfNamedElement element = hid.getElement();
                if (element == null || !(element instanceof RfFunction)) {
                    return true;
                }
                String fullName = ((RfFunction)element).getFullName();
                if (!fullName.equals(Check_R_1382.this.xvmPrintMethod)) {
                    return true;
                }
                HidAccess parentAccess = hid.getParentAccess();
                if (parentAccess == null || parentAccess.getParentHid() == null) {
                    return true;
                }
                Hid parentHid = parentAccess.getParentHid();
                if (!(parentHid instanceof RfHid)) {
                    return true;
                }
                IRfNamedElement parentElement = parentHid.getElement();
                if (!(parentElement instanceof RfAssociatedType)) {
                    return true;
                }
                RfNamedElement finalType = LintUtils.getAssociatedFinalType((RfAssociatedType)parentElement);
                if (!(finalType instanceof RfClass) || !finalType.equals(baseClass) && !LintUtils.isSubClassOf((RfClass)finalType, baseClass)) {
                    return true;
                }
                if (Check_R_1382.this.checkIfGuardedWithVerbosityCheck(this.scope)) {
                    return true;
                }
                Check_R_1382.this.addHit(this.parserPath, hid, "Printing of object " + LintUtils.getNamedElementFullName((RfNamedElement)parentElement) + " is not guarded by a verbosity check!");
                return true;
            }

            public void setScope(IRfNamedElement scope) {
                this.scope = (RfNamedElement)scope;
            }

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            public Class<RfHid> getType() {
                return RfHid.class;
            }
        });
    }

    private boolean checkIfGuardedWithVerbosityCheck(RfNamedElement scope) {
        while (scope != null) {
            if (!(scope instanceof RfActionBlock) || !((RfActionBlock)scope).isConditional()) {
                scope = scope.getEnclosingScope();
                continue;
            }
            IHidObject conditionalExpression = ((RfActionBlock)scope).getConditionalBlockExpression();
            if (conditionalExpression == null) {
                String actionBlockExpression = ((RfActionBlock)scope).getExpression();
                if (actionBlockExpression.contains(this.xvmReportEnabled)) {
                    return true;
                }
            } else {
                Set uniqueHids = HidUtils.flattenToUniqueHids((IHidObject)conditionalExpression, (Set)HidFlatteningOption.NONE_EXCLUDED);
                for (IHid hid : uniqueHids) {
                    String fullName;
                    RfHid rfHid;
                    IRfNamedElement element;
                    if (!(hid instanceof RfHid) || !((element = (rfHid = (RfHid)hid).getElement()) == null || !(element instanceof RfFunction) ? hid.getName().equals(this.xvmReportEnabled) : (fullName = ((RfFunction)element).getFullName()).equals(this.xvmReportEnabledFullName))) continue;
                    return true;
                }
            }
            scope = scope.getEnclosingScope();
        }
        return false;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

