/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="25.1.7")
@CheckID(value="R.1383")
@CheckName(value="R.1383")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.ALWAYS, RuleLabel.EVENT_CONTROL})
@CheckTitle(value="Do not use '|' or '||' instead of 'or' in sensitivity list")
@CheckDescription(value="This check flags usages of '|' or '||' in sensitivity lists. These operators can be confused with 'or', but produce different results, which may not be the user intent.\nIf usages of '|' or '||' are intended, their result should be assigned to a variable that is used in the sensitivity list. Sensitivity lists should only use 'or'.\n\nExamples:\n\nalways @(clk1 | clk2)\t\t\t// not allowed\nalways @(clk1 || clk2)\t\t// not allowed\nalways @(clk1 or clk2)\t\t// allowed\n\nCheck supports pre-waiving.")
public class Check_R_1383
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    private static final String ERROR_MESSAGE = "Sensitivity list uses ''{0}''!";

    public Check_R_1383(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List alwaysBlocks = this.fOVMProject.getRfProject().getAllActionBlocks().stream().filter(RfActionBlock::isAlways).collect(Collectors.toList());
        if (alwaysBlocks == null || alwaysBlocks.isEmpty()) {
            return;
        }
        for (RfActionBlock alwaysBlock : alwaysBlocks) {
            RfDefElement alwaysBlockDeclaration = alwaysBlock.getDeclaration();
            if (alwaysBlockDeclaration == null || this.checkPreWaivers(alwaysBlockDeclaration.getParserPath()) || alwaysBlock.isAlwaysComb() || alwaysBlock.isAlwaysLatch() || alwaysBlock.isAllSensitivityList()) continue;
            this.notifyCheckAlive();
            alwaysBlock.visitHidObject(null, (IHidVisitor<?>)new LocalHidOperatorVisitor(null, alwaysBlock));
        }
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    static /* synthetic */ OVMComplianceHit access$0(Check_R_1383 check_R_1383, ParserPath parserPath, HidOccurrence hidOccurrence, String string) {
        return check_R_1383.addHit(parserPath, hidOccurrence, string);
    }

    class LocalHidOperatorVisitor
    extends HidOperatorVisitor {
        private RfActionBlock alwaysBlock;

        public LocalHidOperatorVisitor(HidOperatorQualifier[] qualifiers, RfActionBlock alwaysBlock) {
            super(qualifiers);
            this.alwaysBlock = alwaysBlock;
        }

        /*
         * Unable to fully structure code
         */
        public boolean visit(HidOperator operator) {
            if (!operator.isEventControlOR()) {
                return true;
            }
            currentToken = Check_R_1383.this.getWSParser().getTokenContainingOffset(operator.getOffset(), this.parserPath);
            if (currentToken != null && currentToken.getZone() == SVTBWhitespaceParser.ZoneType.CODE) ** GOTO lbl9
            return false;
lbl-1000:
            // 1 sources

            {
                if ("begin".equals(currentToken.getStringToken())) {
                    return false;
                }
                currentToken = Check_R_1383.this.getWSParser().getPrevCodeToken(currentToken, this.parserPath);
lbl9:
                // 2 sources

                ** while (currentToken != null && currentToken.getOffsetFile() > this.alwaysBlock.getStartOffset())
            }
lbl10:
            // 1 sources

            flattenedOperators = HidUtils.flattenToOperators((IHidOperator)operator);
            for (IHidOperator op : flattenedOperators) {
                if (!(op instanceof RfHidOperator) || !((RfHidOperator)op).isBinaryOr() && !((RfHidOperator)op).isLogicalOr()) continue;
                Check_R_1383.access$0(Check_R_1383.this, this.parserPath, (HidOccurrence)operator.getOccurrence(), MessageFormat.format("Sensitivity list uses ''{0}''!", new Object[]{op.getOperatorText()}));
            }
            return false;
        }
    }
}

