/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.model.problems.LibraryPackageScope;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.ILintingInstanceHolderCallback;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfNetTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="25.1.7")
@CheckID(value="R.1384")
@CheckName(value="R.1384")
@CheckLabel(labels={RuleLabel.SIGNAL, RuleLabel.SYNTHESIS, RuleLabel.DESIGN})
@CheckTitle(value="Signal has multiple drivers for custom nettypes")
@CheckDescription(value="This check flags custom nettype signals that have multiple drivers.\n\nExample:\nnettype int my_nettype;\nmy_nettype field;  // not allowed, it has multiple drivers\nassign field = 1;\nassign field = 3;\n\nnettype int my_nettype2;\nmy_nettype field2;  // allowed iff <allowedDriverNames> contains 'IGNORE_VALUE'\nassign field2 = IGNORE_VALUE;\nassign field2 = 3;\n\nCheck supports pre-waiving.")
public class Check_R_1384
extends OVMComplianceCheck
implements ILintingInstanceHolderCallback {
    @CheckParameter(defaultValue="", description="Comma separated list of custom nettype names for which the multiple drivers check should not be performed.", name="filteredNettypeNames", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pFilteredNettypeNames;
    @CheckParameter(defaultValue="", description="Comma separated list of driver names. If a signal is driven by any of the specified values, that assignment is ignored.", name="allowedDriverNames", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAllowedDriverNames;
    private Map<RfField, List<RfHidOperator>> fieldWrites = new HashMap<RfField, List<RfHidOperator>>();

    public Check_R_1384(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        BuildConfigManagerCommon.PrecompileGlobalMode precompileMode = BuildConfigManager.getPrecompiledDbMode((IProject)this.fOVMProject.getProject());
        boolean isPrecompiledLoad = precompileMode == BuildConfigManagerCommon.PrecompileGlobalMode.NO_GLOBAL_PRECOMPILE || precompileMode == BuildConfigManagerCommon.PrecompileGlobalMode.AUTO_LOAD;
        this.fOVMProject.getRfProject().accept(this.fOVMProject.getRfProject(), namedElement -> {
            if (!(namedElement instanceof RfInstanceHolder)) {
                return true;
            }
            this.notifyCheckAlive();
            if (this.checkPreWaivers(namedElement.getDeclaration())) {
                return true;
            }
            RfInstanceHolder instanceHolder = (RfInstanceHolder)namedElement;
            instanceHolder.checkUnused(this.fOVMProject.getRfProject(), isPrecompiledLoad, this.getRule());
            return true;
        });
        for (List<RfHidOperator> list : this.fieldWrites.values()) {
            list.clear();
        }
        this.fieldWrites.clear();
    }

    private ILintingInstanceHolderCallback getRule() {
        return this;
    }

    @Override
    public void lintingCheckUnused(RfProject rfProject, RfField field, Map<IRfNamedElement, RfInstanceHolder.UnusedCheck> referencesMap, boolean hasSubInstanceWithDotStar, LibraryPackageScope libPkgScope) {
        int filteredFields;
        int remainingAssignments;
        if (!field.isNet()) {
            return;
        }
        RfInstanceHolder.UnusedCheck referenced = referencesMap.get(field);
        if (referenced == null) {
            return;
        }
        int noOfContinousAssignments = referenced.getContinuousAssignments();
        if (noOfContinousAssignments <= 1 || field instanceof RfPort && !field.isOutput()) {
            return;
        }
        IRfNamedElement assocType = field.getResolvedType(true);
        while (assocType instanceof IRfListType) {
            assocType = ((IRfListType)assocType).getResolvedType(true);
        }
        if (!(assocType instanceof RfNetTypeAlias)) {
            return;
        }
        if (this.pFilteredNettypeNames.contains(assocType.getName())) {
            return;
        }
        List<RfHidOperator> currentFieldWrites = this.fieldWrites.get(field);
        int noOfAssignments = 0;
        if (currentFieldWrites != null && !currentFieldWrites.isEmpty()) {
            for (RfHidOperator operator : currentFieldWrites) {
                IHidObject rhValue = operator.getFirstRHValue();
                if (rhValue instanceof IHid && this.pAllowedDriverNames.contains(((IHid)rhValue).getName())) continue;
                ++noOfAssignments;
            }
        }
        if ((remainingAssignments = noOfContinousAssignments - (filteredFields = currentFieldWrites == null ? 0 : currentFieldWrites.size() - noOfAssignments)) > 1) {
            this.addHit(field, "Custom nettype signal '" + LintUtils.getNamedElementFullName(field) + "' has multiple drivers!");
        }
    }

    @Override
    public void addOperator(ParserPath parserPath, RfHidOperator operator) {
        IHidObject lhValue = operator.getLHValue();
        if (lhValue instanceof RfHidAccess) {
            lhValue = ((RfHidAccess)lhValue).getParentHid();
        }
        if (!(lhValue instanceof RfHid)) {
            return;
        }
        IRfNamedElement element = ((RfHid)lhValue).getElement();
        if (!(element instanceof RfField)) {
            return;
        }
        RfField field = (RfField)element;
        List<RfHidOperator> localFieldWrites = this.fieldWrites.get(field);
        if (localFieldWrites == null) {
            localFieldWrites = new ArrayList<RfHidOperator>();
            this.fieldWrites.put(field, localFieldWrites);
        }
        localFieldWrites.add(operator);
    }

    private boolean checkPreWaivers(RfDefElement fileDef) {
        if (fileDef == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

