/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import ro.amiq.dvt.elaboration.core.ELSpecializationWrapper;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractMultipleOperandsWidthMissmatchCheck;
import ro.amiq.vlogdt.linter.rules.AbstractWidthMissmatchCheck;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="25.1.7")
@CheckID(value="R.1385")
@CheckName(value="R.1385")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.WIDTH_MISMATCH, RuleLabel.ASSIGNMENT})
@CheckTitle(value="Do not assign an integer to an element of different width")
@CheckDescription(value="This rule flags constant integer assignments to signals when the width of the signal is different than the width of the constant integer.\nIf the signal is wider than the constant integer, the extra bits are padded with zeros; and if it is narrower, the excess bits are discarded.\nThis rule checks assignemnts where the right-hand side expression contains at least one constant value.\n\nExamples:\n\nbit [4:0] a, c;\nbit [1:0] b;\nint d;\n\na = 10;         // not allowed\nd = 10;         // allowed iff skipTypes contains int type\na = 16 + b;     // not allowed\na = 5'b1 + c;   // allowed because the implicit value is 5-bit wide\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="ignoreIntTypeVariables", defaultValue="false", isVisible=false)
public class Check_R_1385
extends AbstractMultipleOperandsWidthMissmatchCheck {
    @CheckParameter(defaultValue="int", description="Skip assignments where the left-hand side operand is one of this types. Possible values: shortint, int, longint, byte, bit, logic, reg, integer, time.", name="skipTypes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pSkipTypes;

    public Check_R_1385(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        super.performCheckImpl();
        this.fOVMProject.getRfProject().visitHidObject(null, new AssignmentImplicitVisitor());
    }

    @Override
    public boolean checkOperator(RfHidOperator operator) {
        return operator.isAssignment();
    }

    @Override
    public String getHitMessageKind() {
        return null;
    }

    public void checkSizes(Collection<RfHidImplicit> implicits, List<IHidObject> hidObjects, List<IRfNamedElement> elements, List<RfNamedElement> elementTypes, List<ELParamValuesHidEvaluator> hidEvaluators, ParserPath parserPath, RfHidOperator operator, Map<IHidObject, String> pathsText, boolean hasPathsText, ELSpecializationWrapper specsWrapper, IRfNamedElement scope) {
        ArrayList<int[]> fieldDimensionsInfo = new ArrayList<int[]>();
        int i = 0;
        while (i < hidObjects.size()) {
            int[] hidSize = this.getSizeOfHid(hidObjects.get(i), elements.get(i), elementTypes.get(i), hidEvaluators.get(i), specsWrapper, scope);
            if (hidSize == null) {
                return;
            }
            if (hidSize.length == 1) {
                int[] nArray = new int[2];
                nArray[0] = this.getNumberOfBitsUsedInInteger(hidSize[0]) - 1;
                fieldDimensionsInfo.add(nArray);
            } else {
                fieldDimensionsInfo.add(hidSize);
            }
            if (!Arrays.equals((int[])fieldDimensionsInfo.get(0), (int[])fieldDimensionsInfo.get(fieldDimensionsInfo.size() - 1))) {
                this.addLocalHit(parserPath, operator, pathsText, hasPathsText);
                return;
            }
            ++i;
        }
        for (RfHidImplicit implicit : implicits) {
            int[] implicitSize = this.getSizeOfHid((IHidObject)implicit, null, null, this.emptyEvaluator, null, scope);
            if (implicitSize == null) {
                return;
            }
            if (implicitSize.length == 1) {
                int[] nArray = new int[2];
                nArray[0] = this.getNumberOfBitsUsedInInteger(implicitSize[0]) - 1;
                fieldDimensionsInfo.add(nArray);
            } else {
                fieldDimensionsInfo.add(implicitSize);
            }
            if (Arrays.equals((int[])fieldDimensionsInfo.get(0), (int[])fieldDimensionsInfo.get(fieldDimensionsInfo.size() - 1))) continue;
            this.addLocalHit(parserPath, operator, pathsText, hasPathsText);
            return;
        }
    }

    private void addLocalHit(ParserPath parserPath, RfHidOperator operator, Map<IHidObject, String> pathsText, boolean hasPathsText) {
        StringBuilder hitMessage = new StringBuilder("");
        hitMessage.append("Width missmatch on constant integer assignment  " + HidUtils.toNiceString((IHidObject)operator) + "!");
        if (hasPathsText) {
            hitMessage.append("\n\nHierarchy Paths for:");
            for (Map.Entry<IHidObject, String> pathsEntry : pathsText.entrySet()) {
                hitMessage.append("\n  '").append(HidUtils.toNiceString((IHidObject)pathsEntry.getKey())).append("': ").append(pathsEntry.getValue());
            }
        }
        this.addHit(parserPath, (HidOccurrence)operator.getOccurrence(), hitMessage.toString());
    }

    @Override
    protected boolean checkOperatorsInRHSide(RfHidOperator operator) {
        return operator.getOperatorKind() == IHidOperatorConstants.OperatorKind.BINARY_OPERATOR;
    }

    class AssignmentImplicitVisitor
    implements IHidVisitor<RfHidOperator> {
        private ParserPath parserPath;
        private IRfNamedElement scope;

        AssignmentImplicitVisitor() {
        }

        public void setScope(IRfNamedElement scope) {
            this.scope = scope;
        }

        public boolean visit(RfHidOperator operator) {
            Collection<IHidObject> flattenedRhHids;
            if (!Check_R_1385.this.checkOperator(operator)) {
                return true;
            }
            if (Check_R_1385.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1385.this.notifyCheckAlive();
            if (Check_R_1385.this.checkIfSkipTypes(operator.getLHValue(), Check_R_1385.this.pSkipTypes)) {
                return true;
            }
            IHidObject firstRhValue = operator.getFirstRHValue();
            if (firstRhValue == null) {
                return true;
            }
            if (firstRhValue instanceof RfHidOperator) {
                flattenedRhHids = Check_R_1385.this.flattenToHidsFromOperator((RfHidOperator)firstRhValue);
                if (flattenedRhHids == null) {
                    return true;
                }
            } else {
                flattenedRhHids = Arrays.asList(firstRhValue);
            }
            if (!this.checkForImplicitInOperands(flattenedRhHids)) {
                return true;
            }
            Collection implicitsInRightHSide = flattenedRhHids.stream().filter(RfHidImplicit.class::isInstance).map(RfHidImplicit.class::cast).collect(Collectors.toList());
            Collection nonImplicitsInRightHSide = flattenedRhHids.stream().filter(hid -> !(hid instanceof RfHidImplicit)).collect(Collectors.toList());
            ArrayList<IHidObject> hidObjects = new ArrayList<IHidObject>();
            ArrayList<RfHid> valueRfHids = new ArrayList<RfHid>();
            ArrayList<IRfNamedElement> elements = new ArrayList<IRfNamedElement>();
            ArrayList<RfNamedElement> elementTypes = new ArrayList<RfNamedElement>();
            ArrayList<IRfNamedElement> ancestorElements = new ArrayList<IRfNamedElement>();
            ArrayList<Hid> instanceHids = new ArrayList<Hid>();
            ArrayList<IRfNamedElement> instanceFieldOrFunctions = new ArrayList<IRfNamedElement>();
            ArrayList<IRfScopeElement> ancestorElementEnclosingScopes = new ArrayList<IRfScopeElement>();
            ArrayList<IRfScopeElement> elementEnclosingScopes = new ArrayList<IRfScopeElement>();
            ArrayList<Boolean> isElementTypeParameter = new ArrayList<Boolean>();
            IHidObject lhValueHidObject = operator.getLHValue();
            if (!Check_R_1385.this.checkHidAndPopulateArrays(lhValueHidObject, hidObjects, valueRfHids, elements, elementTypes, instanceHids, ancestorElements, instanceFieldOrFunctions, ancestorElementEnclosingScopes, elementEnclosingScopes, isElementTypeParameter)) {
                return true;
            }
            for (IHidObject rhHidObject : nonImplicitsInRightHSide) {
                if (Check_R_1385.this.checkHidAndPopulateArrays(rhHidObject, hidObjects, valueRfHids, elements, elementTypes, instanceHids, ancestorElements, instanceFieldOrFunctions, ancestorElementEnclosingScopes, elementEnclosingScopes, isElementTypeParameter)) continue;
                return true;
            }
            ArrayList<ELParamValuesHidEvaluator> hidEvaluators = new ArrayList<ELParamValuesHidEvaluator>();
            HashMap<IHidObject, String> pathsText = new HashMap<IHidObject, String>();
            if (ancestorElementEnclosingScopes.contains(null) || elementEnclosingScopes.contains(null) || ancestorElementEnclosingScopes.stream().anyMatch(ancestorElement -> Check_R_1385.this.specsPerElement.get(ancestorElement) == null) || ancestorElementEnclosingScopes.stream().distinct().count() != 1L || IntStream.range(0, elements.size()).allMatch(index -> !Check_R_1385.this.shouldEvaluateWithNonEmptyEvaluator((IRfNamedElement)elements.get(index), (IRfNamedElement)elementTypes.get(index), true))) {
                elements.forEach(element -> {
                    boolean bl = hidEvaluators.add(Check_R_1385.this.emptyEvaluator);
                });
                Check_R_1385.this.checkSizes(implicitsInRightHSide, hidObjects, elements, elementTypes, hidEvaluators, this.parserPath, operator, pathsText, false, null, this.scope);
                return true;
            }
            Map specializationWrappers = (Map)Check_R_1385.this.specsPerElement.get(ancestorElementEnclosingScopes.get(0));
            block1: for (ELSpecializationWrapper ancestorFieldWrapper : specializationWrappers.values()) {
                hidEvaluators.clear();
                pathsText.clear();
                IHidEvaluator defaultEvaluator = ancestorFieldWrapper.getHidEvaluator(Check_R_1385.this.elManager);
                if (!(defaultEvaluator instanceof ELParamValuesHidEvaluator) || ancestorFieldWrapper.paths == null) continue;
                int index2 = 0;
                while (index2 < elementEnclosingScopes.size()) {
                    Map fieldSpecializationWrappers = (Map)Check_R_1385.this.specsPerElement.get(elementEnclosingScopes.get(index2));
                    AbstractWidthMissmatchCheck.SpecInfo specInfo = Check_R_1385.this.getWrapperForInstance((Hid)instanceHids.get(index2), (IRfNamedElement)instanceFieldOrFunctions.get(index2), fieldSpecializationWrappers, defaultEvaluator, ancestorFieldWrapper.paths);
                    IHidEvaluator fieldSpecializationEvaluator = specInfo.getEvaluator();
                    if (!(fieldSpecializationEvaluator instanceof ELParamValuesHidEvaluator)) continue block1;
                    hidEvaluators.add((ELParamValuesHidEvaluator)fieldSpecializationEvaluator);
                    String pathText = specInfo.getPath() == null ? ancestorFieldWrapper.getPathsText() : specInfo.getPath();
                    pathsText.put((IHidObject)hidObjects.get(index2), pathText);
                    ++index2;
                }
                Check_R_1385.this.checkSizes(implicitsInRightHSide, hidObjects, elements, elementTypes, hidEvaluators, this.parserPath, operator, pathsText, true, ancestorFieldWrapper, this.scope);
                if (IntStream.range(0, elements.size()).allMatch(index -> !Check_R_1385.this.shouldEvaluateWithNonEmptyEvaluator((IRfNamedElement)elements.get(index), (IRfNamedElement)elementTypes.get(index), true))) break;
            }
            return true;
        }

        private boolean checkForImplicitInOperands(Collection<IHidObject> operands) {
            for (IHidObject operand : operands) {
                if (!(operand instanceof RfHidImplicit)) continue;
                return true;
            }
            return false;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

