/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractTypeAndDirectionCheck;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfPort;

@CheckVersion(value="25.1.9")
@CheckID(value="R.1386")
@CheckName(value="R.1386")
@CheckLabel(labels={RuleLabel.MODULE, RuleLabel.INTERFACE, RuleLabel.PORT})
@CheckTitle(value="Specify type and direction for all module and interface ports")
@CheckDescription(value="Port types are sticky - and hold until the next type / direction change. Additionally, ports have a default type.\nThis applies to any construct with a port list. Because this is confusing and leads to some common mistakes it is not allowed.\nThis check verifies that modules and interfaces with at least one non-inout port, must declare the direction for every port.\n\nExamples:\nmodule foo(a, b, output bit [15:0] u, v, ref byte c[]); // not allowed\nmodule foo(input logic a, input logic b, output bit [15:0] u, output bit [15:0]v, ref byte c[]); // allowed\nmodule foo(logic a, logic b, output bit [15:0] u, inout bit [15:0] v, ref byte c[]); // allowed IFF skipInoutsDeclaredFirst\n\nCheck supports pre-waiving.")
public class Check_R_1386
extends AbstractTypeAndDirectionCheck {
    @CheckParameter(defaultValue="true", description="When true, it checks the port data type.", name="checkPortDataType", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckPortDataType;
    @CheckParameter(defaultValue="true", description="When true, it checks the port direction.", name="checkPortDirection", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckPortDirection;
    @CheckParameter(defaultValue="false", description="When true, it is possible to have implicit defined inouts first, followed by any explicit non-inout direction.", name="skipInoutsDeclaredFirst", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipInoutsDeclaredFirstValue;

    public Check_R_1386(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.implicitType = 2;
    }

    @Override
    protected List<RfDefElement> getAllElementsToCheck() {
        RfInterface[] allInterfaces;
        int n;
        ArrayList<RfDefElement> result = new ArrayList<RfDefElement>();
        RfModule[] allModules = this.fOVMProject.getRfProject().getAllModules();
        if (allModules != null && allModules.length > 0) {
            RfModule[] rfModuleArray = allModules;
            n = allModules.length;
            int n2 = 0;
            while (n2 < n) {
                RfModule module = rfModuleArray[n2];
                Collection defModules = module.getDeclarations();
                if (defModules != null && !defModules.isEmpty()) {
                    result.addAll(defModules);
                }
                ++n2;
            }
        }
        if ((allInterfaces = this.fOVMProject.getRfProject().getAllInterfaces()) != null && allInterfaces.length > 0) {
            RfInterface[] rfInterfaceArray = allInterfaces;
            int n3 = allInterfaces.length;
            n = 0;
            while (n < n3) {
                RfInterface intf = rfInterfaceArray[n];
                Collection defInterfaces = intf.getDeclarations();
                if (defInterfaces != null && !defInterfaces.isEmpty()) {
                    result.addAll(defInterfaces);
                }
                ++n;
            }
        }
        return result;
    }

    @Override
    protected List<RfField> getCheckedMembers(Object element) {
        if (!(element instanceof RfDefElement)) {
            return null;
        }
        ArrayList<RfField> result = new ArrayList<RfField>();
        List<RfPort> ports = ((RfDefElement)element).getPortsWithPrefix("", 2);
        if (ports != null && !ports.isEmpty()) {
            result.addAll(ports);
        }
        return result;
    }

    @Override
    protected String getMemberInfo(Object member) {
        if (!(member instanceof RfPort)) {
            return null;
        }
        return "Port '" + ((RfPort)member).getName() + "'";
    }

    @Override
    protected boolean shouldSkip() {
        return this.pSkipInoutsDeclaredFirstValue;
    }

    @Override
    protected boolean checkMemberDataType() {
        return this.pCheckPortDataType;
    }

    @Override
    protected boolean checkMemberDirection() {
        return this.pCheckPortDirection;
    }
}

