/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import ro.amiq.dvt.elaboration.core.ELSpecializationWrapper;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractMultipleOperandsWidthMissmatchCheck;
import ro.amiq.vlogdt.linter.rules.AbstractWidthMissmatchCheck;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="25.1.8")
@CheckID(value="R.1387")
@CheckName(value="R.1387")
@CheckLabel(labels={RuleLabel.PROCEDURAL_STATEMENT, RuleLabel.CASE, RuleLabel.CONDITIONAL, RuleLabel.WIDTH_MISMATCH})
@CheckTitle(value="Do not use case item expressions of different width than the case condition")
@CheckDescription(value="\nThis rule flags width mismatches between case statements and their select expressions.\nThis rule calculates the width of case expressions according to the following rules:\n  - for plus/minus or binary bitwise operators, the width is calculated as the maximum between the 2 operands.\n  - for multiplication operators, the width is the sum of the operands.\n  - for division operators, the resulting width is the one of the left-hand side operator.\n  - for concat operators, the width is calculated as the sum of all the operands.\nCase items where the expressions is a literal constant value are ignored.\nIn the case of implicit values, according to the LRM, chapter 5.7.1, unsized literals are considered as 32-bit signed integers, while sized literals get their dimension from the specified size.\n\nExamples:\n\nbit [2:0] a;\nbit [2:0] b;\nbit [5:0] c\n\ncase (c)\n  a: $display(\"\");      // NOT ALLOWED\n  b: $display(\"\");      // NOT ALLOWED\n  a + b: $display(\"\");  // NOT ALLOWED\n  a - b: $display(\"\");  // NOT ALLOWED\n  a * b: $display(\"\");  // ALLOWED\n  a \\ b: $display(\"\");  // NOT ALLOWED\n  c \\ b: $display(\"\");  // ALLOWED\n  {a, b}: $display(\"\");  // ALLOWED\nendcase\n\nCheck supports pre-waiving.")
public class Check_R_1387
extends AbstractMultipleOperandsWidthMissmatchCheck {
    public Check_R_1387(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        super.performCheckImpl();
        this.fOVMProject.getRfProject().visitHidObject(null, new AssignmentImplicitVisitor());
    }

    @Override
    public boolean checkOperator(RfHidOperator operator) {
        return operator.isCaseItemCondition();
    }

    @Override
    public String getHitMessageKind() {
        return null;
    }

    public void checkSizes(Collection<RfHidImplicit> implicitsLeft, Collection<RfHidImplicit> implicitsRight, IHidObject lhHidObject, IHidObject rhHidObject, Integer indexOfFirstRhHid, List<IHidObject> hidObjects, List<IRfNamedElement> elements, List<RfNamedElement> elementTypes, List<ELParamValuesHidEvaluator> hidEvaluators, ParserPath parserPath, RfHidOperator operator, Map<IHidObject, String> pathsText, boolean hasPathsText, ELSpecializationWrapper specsWrapper, IRfNamedElement scope) {
        HashMap<IHidObject, int[]> lhFieldDimensionsForHid = new HashMap<IHidObject, int[]>();
        HashMap<IHidObject, int[]> rhFieldDimensionsForHid = new HashMap<IHidObject, int[]>();
        int i = 0;
        while (i < hidObjects.size()) {
            Object hidSize = this.getSizeOfHid(hidObjects.get(i), elements.get(i), elementTypes.get(i), hidEvaluators.get(i), specsWrapper, scope);
            if (hidSize == null) {
                return;
            }
            if (((Object)hidSize).length == 1) {
                if (i < indexOfFirstRhHid) {
                    int[] nArray = new int[2];
                    nArray[0] = this.getNumberOfBitsUsedInInteger((int)hidSize[0]) - 1;
                    lhFieldDimensionsForHid.put(hidObjects.get(i), nArray);
                } else {
                    int[] nArray = new int[2];
                    nArray[0] = this.getNumberOfBitsUsedInInteger((int)hidSize[0]) - 1;
                    rhFieldDimensionsForHid.put(hidObjects.get(i), nArray);
                }
            } else if (i < indexOfFirstRhHid) {
                lhFieldDimensionsForHid.put(hidObjects.get(i), (int[])hidSize);
            } else {
                rhFieldDimensionsForHid.put(hidObjects.get(i), (int[])hidSize);
            }
            ++i;
        }
        for (RfHidImplicit implicit : implicitsLeft) {
            this.calculateSizeOfImplicit(implicit, lhFieldDimensionsForHid, scope);
        }
        for (RfHidImplicit implicit : implicitsRight) {
            this.calculateSizeOfImplicit(implicit, rhFieldDimensionsForHid, scope);
        }
        int[] lhSize = this.calculateSizeOfHid(lhHidObject, lhFieldDimensionsForHid);
        if (lhSize == null || lhSize.length == 0) {
            return;
        }
        int[] rhSize = this.calculateSizeOfHid(rhHidObject, rhFieldDimensionsForHid);
        if (rhSize == null || rhSize.length == 0) {
            return;
        }
        if (!Arrays.equals(lhSize, rhSize)) {
            this.addLocalHit(parserPath, operator, pathsText, hasPathsText, lhSize, rhSize);
        }
    }

    @Override
    protected int[] calculateSizeOfHid(IHidObject hidObject, Map<IHidObject, int[]> fieldDimensionsForHid) {
        if (hidObject instanceof RfHidOperator) {
            RfHidOperator operator = (RfHidOperator)hidObject;
            if (operator.isPlus() || operator.isBinaryBitwise()) {
                return this.getMaximumOfArrays(this.calculateSizeOfHid(operator.getLHValue(), fieldDimensionsForHid), this.calculateSizeOfHid(operator.getFirstRHValue(), fieldDimensionsForHid));
            }
            if (operator.isMinus()) {
                if (operator.getFirstRHValue() == null) {
                    return this.calculateSizeOfHid(operator.getLHValue(), fieldDimensionsForHid);
                }
                return this.getMaximumOfArrays(this.calculateSizeOfHid(operator.getLHValue(), fieldDimensionsForHid), this.calculateSizeOfHid(operator.getFirstRHValue(), fieldDimensionsForHid));
            }
            if (operator.isStar()) {
                return this.getSumOfArrays(this.calculateSizeOfHid(operator.getLHValue(), fieldDimensionsForHid), this.calculateSizeOfHid(operator.getFirstRHValue(), fieldDimensionsForHid));
            }
            if (operator.isDiv()) {
                return this.calculateSizeOfHid(operator.getLHValue(), fieldDimensionsForHid);
            }
            if (operator.isVLOGConcatenation(true)) {
                if (operator.getFirstRHValue() == null) {
                    return null;
                }
                int[] result = this.calculateSizeOfHid(operator.getFirstRHValue(), fieldDimensionsForHid);
                int i = 1;
                while (i < operator.getRHValues().size()) {
                    result = this.getSumOfArrays(result, this.calculateSizeOfHid((IHidObject)operator.getRHValues().get(i), fieldDimensionsForHid));
                    ++i;
                }
                return result;
            }
            return null;
        }
        return fieldDimensionsForHid.getOrDefault(hidObject, null);
    }

    private void addLocalHit(ParserPath parserPath, RfHidOperator operator, Map<IHidObject, String> pathsText, boolean hasPathsText, int[] lhSize, int[] rhSize) {
        StringBuilder hitMessage = new StringBuilder("");
        hitMessage.append("Width missmatch on case item condition  " + HidUtils.toNiceString((IHidObject)operator) + "!\nCase expression has width " + this.getWidthAsString(lhSize) + ", while case item expression side has width " + this.getWidthAsString(rhSize));
        if (hasPathsText) {
            hitMessage.append("\n\nHierarchy Paths for:");
            for (Map.Entry<IHidObject, String> pathsEntry : pathsText.entrySet()) {
                hitMessage.append("\n  '").append(HidUtils.toNiceString((IHidObject)pathsEntry.getKey())).append("': ").append(pathsEntry.getValue());
            }
        }
        this.addHit(parserPath, (HidOccurrence)operator.getOccurrence(), hitMessage.toString());
    }

    @Override
    public Collection<IHidObject> flattenToHidsFromOperator(RfHidOperator operator) {
        ArrayList<IHidObject> flattenedHids = new ArrayList<IHidObject>();
        Set flattenOP = HidUtils.flattenToOperators((IHidOperator)operator);
        for (IHidOperator op : flattenOP) {
            if (!(op instanceof RfHidOperator)) {
                return null;
            }
            operator = (RfHidOperator)op;
            if (!this.checkOperatorsInRHSide(operator)) {
                return null;
            }
            if (operator.getRHValues() == null) {
                if (operator.isMinus()) {
                    flattenedHids.add(operator.getLHValue());
                    continue;
                }
                return null;
            }
            if (!(operator.getLHValue() instanceof RfHidOperator) && !operator.isVLOGConcatenation(true)) {
                flattenedHids.add(operator.getLHValue());
            }
            for (IHidObject operand : operator.getRHValues()) {
                if (operand instanceof RfHidOperator) continue;
                flattenedHids.add(operand);
            }
        }
        return flattenedHids;
    }

    @Override
    protected boolean checkOperatorsInRHSide(RfHidOperator operator) {
        return operator.isVLOGConcatenation(true) || operator.isPlus() || operator.isMinus() || operator.isStar() || operator.isDiv() || operator.isBinaryBitwise();
    }

    class AssignmentImplicitVisitor
    implements IHidVisitor<RfHidOperator> {
        private ParserPath parserPath;
        private IRfNamedElement scope;

        AssignmentImplicitVisitor() {
        }

        public void setScope(IRfNamedElement scope) {
            this.scope = scope;
        }

        public boolean visit(RfHidOperator operator) {
            Collection<IHidObject> flattenedLhHids;
            Collection<IHidObject> flattenedRhHids;
            if (!Check_R_1387.this.checkOperator(operator)) {
                return true;
            }
            if (Check_R_1387.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1387.this.notifyCheckAlive();
            IHidObject lhHidObject = operator.getLHValue();
            IHidObject rhHidObject = operator.getFirstRHValue();
            if (lhHidObject == null || rhHidObject == null) {
                return true;
            }
            if (rhHidObject instanceof RfHidImplicit && "default".equals(((RfHidImplicit)rhHidObject).getName())) {
                return true;
            }
            if (rhHidObject instanceof RfHidOperator) {
                flattenedRhHids = Check_R_1387.this.flattenToHidsFromOperator((RfHidOperator)rhHidObject);
                if (flattenedRhHids == null) {
                    return true;
                }
            } else {
                flattenedRhHids = Arrays.asList(rhHidObject);
            }
            Collection implicitsInRightHSide = flattenedRhHids.stream().filter(hid -> hid instanceof RfHidImplicit && !((RfHidImplicit)hid).isStringLiteral()).map(RfHidImplicit.class::cast).collect(Collectors.toList());
            Collection nonImplicitsInRightHSide = flattenedRhHids.stream().filter(hid -> !(hid instanceof RfHidImplicit)).collect(Collectors.toList());
            if (lhHidObject instanceof RfHidOperator) {
                flattenedLhHids = Check_R_1387.this.flattenToHidsFromOperator((RfHidOperator)lhHidObject);
                if (flattenedLhHids == null) {
                    return true;
                }
            } else {
                flattenedLhHids = Arrays.asList(lhHidObject);
            }
            Collection implicitsInLeftHSide = flattenedLhHids.stream().filter(hid -> hid instanceof RfHidImplicit && !((RfHidImplicit)hid).isStringLiteral()).map(RfHidImplicit.class::cast).collect(Collectors.toList());
            Collection nonImplicitsInLeftHSide = flattenedLhHids.stream().filter(hid -> !(hid instanceof RfHidImplicit)).collect(Collectors.toList());
            ArrayList<IHidObject> hidObjects = new ArrayList<IHidObject>();
            ArrayList<RfHid> valueRfHids = new ArrayList<RfHid>();
            ArrayList<IRfNamedElement> elements = new ArrayList<IRfNamedElement>();
            ArrayList<RfNamedElement> elementTypes = new ArrayList<RfNamedElement>();
            ArrayList<IRfNamedElement> ancestorElements = new ArrayList<IRfNamedElement>();
            ArrayList<Hid> instanceHids = new ArrayList<Hid>();
            ArrayList<IRfNamedElement> instanceFieldOrFunctions = new ArrayList<IRfNamedElement>();
            ArrayList<IRfScopeElement> ancestorElementEnclosingScopes = new ArrayList<IRfScopeElement>();
            ArrayList<IRfScopeElement> elementEnclosingScopes = new ArrayList<IRfScopeElement>();
            ArrayList<Boolean> isElementTypeParameter = new ArrayList<Boolean>();
            for (IHidObject lhHid : nonImplicitsInLeftHSide) {
                if (Check_R_1387.this.checkHidAndPopulateArrays(lhHid, hidObjects, valueRfHids, elements, elementTypes, instanceHids, ancestorElements, instanceFieldOrFunctions, ancestorElementEnclosingScopes, elementEnclosingScopes, isElementTypeParameter)) continue;
                return true;
            }
            for (IHidObject rhHid : nonImplicitsInRightHSide) {
                if (Check_R_1387.this.checkHidAndPopulateArrays(rhHid, hidObjects, valueRfHids, elements, elementTypes, instanceHids, ancestorElements, instanceFieldOrFunctions, ancestorElementEnclosingScopes, elementEnclosingScopes, isElementTypeParameter)) continue;
                return true;
            }
            Integer indexOfFirstRhHid = flattenedLhHids.size();
            ArrayList<ELParamValuesHidEvaluator> hidEvaluators = new ArrayList<ELParamValuesHidEvaluator>();
            HashMap<IHidObject, String> pathsText = new HashMap<IHidObject, String>();
            if (ancestorElementEnclosingScopes.contains(null) || elementEnclosingScopes.contains(null) || ancestorElementEnclosingScopes.stream().anyMatch(ancestorElement -> Check_R_1387.this.specsPerElement.get(ancestorElement) == null) || ancestorElementEnclosingScopes.stream().distinct().count() != 1L || IntStream.range(0, elements.size()).allMatch(index -> !Check_R_1387.this.shouldEvaluateWithNonEmptyEvaluator((IRfNamedElement)elements.get(index), (IRfNamedElement)elementTypes.get(index), true))) {
                elements.forEach(element -> {
                    boolean bl = hidEvaluators.add(Check_R_1387.this.emptyEvaluator);
                });
                Check_R_1387.this.checkSizes(implicitsInLeftHSide, implicitsInRightHSide, lhHidObject, rhHidObject, indexOfFirstRhHid, hidObjects, elements, elementTypes, hidEvaluators, this.parserPath, operator, pathsText, false, null, this.scope);
                return true;
            }
            Map specializationWrappers = (Map)Check_R_1387.this.specsPerElement.get(ancestorElementEnclosingScopes.get(0));
            block2: for (ELSpecializationWrapper ancestorFieldWrapper : specializationWrappers.values()) {
                hidEvaluators.clear();
                pathsText.clear();
                IHidEvaluator defaultEvaluator = ancestorFieldWrapper.getHidEvaluator(Check_R_1387.this.elManager);
                if (!(defaultEvaluator instanceof ELParamValuesHidEvaluator) || ancestorFieldWrapper.paths == null) continue;
                int index2 = 0;
                while (index2 < elementEnclosingScopes.size()) {
                    Map fieldSpecializationWrappers = (Map)Check_R_1387.this.specsPerElement.get(elementEnclosingScopes.get(index2));
                    AbstractWidthMissmatchCheck.SpecInfo specInfo = Check_R_1387.this.getWrapperForInstance((Hid)instanceHids.get(index2), (IRfNamedElement)instanceFieldOrFunctions.get(index2), fieldSpecializationWrappers, defaultEvaluator, ancestorFieldWrapper.paths);
                    IHidEvaluator fieldSpecializationEvaluator = specInfo.getEvaluator();
                    if (!(fieldSpecializationEvaluator instanceof ELParamValuesHidEvaluator)) continue block2;
                    hidEvaluators.add((ELParamValuesHidEvaluator)fieldSpecializationEvaluator);
                    String pathText = specInfo.getPath() == null ? ancestorFieldWrapper.getPathsText() : specInfo.getPath();
                    pathsText.put((IHidObject)hidObjects.get(index2), pathText);
                    ++index2;
                }
                Check_R_1387.this.checkSizes(implicitsInLeftHSide, implicitsInRightHSide, lhHidObject, rhHidObject, indexOfFirstRhHid, hidObjects, elements, elementTypes, hidEvaluators, this.parserPath, operator, pathsText, true, ancestorFieldWrapper, this.scope);
                if (IntStream.range(0, elements.size()).allMatch(index -> !Check_R_1387.this.shouldEvaluateWithNonEmptyEvaluator((IRfNamedElement)elements.get(index), (IRfNamedElement)elementTypes.get(index), true))) break;
            }
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

