/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashMap;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.LintUtilsConstants;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="25.1.8")
@CheckID(value="R.1388")
@CheckName(value="R.1388")
@CheckLabel(labels={RuleLabel.SINGULAR_DATA_TYPE, RuleLabel.LOOP})
@CheckTitle(value="Do not use non-integer variables as loop indexes")
@CheckDescription(value="This rule flags variables used as loop indexes that have non-integer types.\nFor a variable to be considered a loop index, it must be used in all three parts of the for declaration (initialization, condition and step).\nThe accepted integer types are int, longint, shortint, integer and byte.\n\nExample:\n\nint i;\nfor (i = 0; i < 10; i++)\t// allowed\n\nreal r;\nfor (r = 0; r < 10; r++)\t// not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1388
extends OVMComplianceCheck {
    public Check_R_1388(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().accept(new LocalNamedElementVisitor());
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    class LocalNamedElementVisitor
    implements IRfNamedElementVisitor {
        LocalNamedElementVisitor() {
        }

        @Override
        public boolean visit(RfNamedElement namedElement) {
            if (!(namedElement instanceof RfActionBlock)) {
                return true;
            }
            RfActionBlock loopActionBlock = (RfActionBlock)namedElement;
            if (!loopActionBlock.isFor()) {
                return true;
            }
            Check_R_1388.this.notifyCheckAlive();
            if (Check_R_1388.this.checkPreWaivers(namedElement.getFile())) {
                return true;
            }
            RfHidHolder hidHolder = loopActionBlock.getHidHolder();
            if (hidHolder == null || hidHolder.getHidObjectsMap() == null || loopActionBlock.getDeclaration() == null) {
                return true;
            }
            ParserPath loopDeclaration = loopActionBlock.getDeclaration().getParserPath();
            ListContainer loopOperators = (ListContainer)hidHolder.getHidObjectsMap().get(loopDeclaration);
            if (loopOperators == null || loopOperators.isEmpty()) {
                return true;
            }
            HashMap<IRfNamedElement, Integer> loopIndexes = new HashMap<IRfNamedElement, Integer>();
            for (IHidObject operator : loopOperators) {
                if (!(operator instanceof RfHidOperator)) continue;
                if (((RfHidOperator)operator).isForInit()) {
                    IHidObject forInit = ((RfHidOperator)operator).getLHValue();
                    if (!(forInit instanceof RfHidOperator) || !((RfHidOperator)forInit).isAssignment()) continue;
                    IHidObject index = ((RfHidOperator)forInit).getLHValue();
                    IRfNamedElement member = null;
                    if (index instanceof RfHid) {
                        member = ((RfHid)index).getElement();
                    } else if (index instanceof RfHidAccess) {
                        Hid parent = ((RfHidAccess)index).getParentHid();
                        if (parent != null && parent instanceof RfHid) {
                            member = parent.getElement();
                        }
                    } else if (index instanceof RfHidImplicit) {
                        member = loopActionBlock.getLocalMember(RfField.class, ((RfHidImplicit)index).getName(), false);
                    }
                    if (member == null) continue;
                    loopIndexes.put(member, 1);
                    continue;
                }
                if (!((RfHidOperator)operator).isForStep() && !((RfHidOperator)operator).isForCondition()) continue;
                IHidObject lhHid = ((RfHidOperator)operator).getLHValue();
                Set flattenedHids = HidUtils.flattenToHids((IHidObject)lhHid, (Set)HidFlatteningOption.NONE_EXCLUDED);
                for (IHid stepHid : flattenedHids) {
                    IRfNamedElement parentElement;
                    Hid parentHid;
                    if (!(stepHid instanceof RfHid)) continue;
                    IRfNamedElement stepElement = ((RfHid)stepHid).getElement();
                    if (stepElement instanceof RfField) {
                        if (loopIndexes.containsKey(stepElement)) {
                            loopIndexes.put(stepElement, (Integer)loopIndexes.get(stepElement) + 1);
                        }
                        if (((RfHidOperator)operator).isForStep() && loopIndexes.containsKey(stepElement) && (Integer)loopIndexes.get(stepElement) == 3) {
                            RfNamedElement type = LintUtils.getAssociatedFinalType((RfField)stepElement);
                            if (type instanceof RfBitVectorScalarType) {
                                type = ((RfBitVectorScalarType)type).getScalarWithDefaultSign();
                            }
                            if (!LintUtilsConstants.INTEGER_SIGNED_TYPES.contains(type.getName())) {
                                Check_R_1388.this.addHit(namedElement, "For loop index '" + LintUtils.getNamedElementFullName((RfField)stepElement) + "' is not integer type!");
                                continue;
                            }
                        }
                    }
                    if ((parentHid = ((RfHid)stepHid).getParentHid()) == null || !((parentElement = parentHid.getElement()) instanceof RfField)) continue;
                    if (loopIndexes.containsKey(parentElement)) {
                        loopIndexes.put(parentElement, (Integer)loopIndexes.get(parentElement) + 1);
                    }
                    if (!((RfHidOperator)operator).isForStep() || !loopIndexes.containsKey(parentElement) || (Integer)loopIndexes.get(parentElement) != 3) continue;
                    RfNamedElement type = LintUtils.getAssociatedFinalType((RfField)parentElement);
                    if (type instanceof RfBitVectorScalarType) {
                        type = ((RfBitVectorScalarType)type).getScalarWithDefaultSign();
                    }
                    if (LintUtilsConstants.INTEGER_SIGNED_TYPES.contains(type.getName())) continue;
                    Check_R_1388.this.addHit(namedElement, "For loop index '" + LintUtils.getNamedElementFullName((RfField)parentElement) + "' is not integer type!");
                }
            }
            return true;
        }
    }
}

