/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractForLoopCheck;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="25.1.8")
@CheckID(value="R.1389")
@CheckName(value="R.1389")
@CheckLabel(labels={RuleLabel.PROCEDURAL_STATEMENT, RuleLabel.FOR})
@CheckTitle(value="Use the same variable for initialization, step and condition")
@CheckDescription(value="This check flags all variables used in initialization / step that are not also used in initialization / condition / step.\n\nExamples:\n\nfor (i = 0; i < N; i++); // allowed\nfor (i = 0; j < N; i++); // not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1389
extends AbstractForLoopCheck {
    private Set<IHidObject> initializationHidsToHit = new HashSet<IHidObject>();
    private Set<IHidObject> conditionHidsToHit = new HashSet<IHidObject>();
    private Set<IHidObject> stepHidsToHit = new HashSet<IHidObject>();

    public Check_R_1389(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.addHitOnMissingLoopHids = false;
    }

    @Override
    protected boolean checkLoopOperators(ListContainer<IHidObject> loopOperators) {
        this.initializationHidsToHit.clear();
        this.conditionHidsToHit.clear();
        this.stepHidsToHit.clear();
        HashSet<IHidObject> initializationHids = new HashSet<IHidObject>();
        HashSet<IHidObject> conditionHids = new HashSet<IHidObject>();
        HashSet<IHidObject> stepHids = new HashSet<IHidObject>();
        for (IHidObject operator : loopOperators) {
            if (!(operator instanceof RfHidOperator)) continue;
            RfHidOperator rfHidOperator = (RfHidOperator)operator;
            HashSet<IHidObject> currentHids = new HashSet<IHidObject>();
            if (rfHidOperator.isForInit()) {
                this.addHidsToSet((IHidObject)rfHidOperator, currentHids, true);
                initializationHids.addAll(currentHids);
                continue;
            }
            if (rfHidOperator.isForCondition()) {
                this.addHidsToSet((IHidObject)rfHidOperator, currentHids, false);
                conditionHids.addAll(currentHids);
                continue;
            }
            if (!rfHidOperator.isForStep()) continue;
            this.addHidsToSet((IHidObject)rfHidOperator, currentHids, true);
            stepHids.addAll(currentHids);
        }
        HashSet<IHidObject> allRequiredVariableHids = new HashSet<IHidObject>();
        if (initializationHids != null && !initializationHids.isEmpty()) {
            this.addNewHidsFromSet(allRequiredVariableHids, initializationHids);
        }
        if (stepHids != null && !stepHids.isEmpty()) {
            this.addNewHidsFromSet(allRequiredVariableHids, stepHids);
        }
        this.computeSetDifference(allRequiredVariableHids, initializationHids, conditionHids, stepHids);
        return this.initializationHidsToHit != null && !this.initializationHidsToHit.isEmpty() || this.conditionHidsToHit != null && !this.conditionHidsToHit.isEmpty() || this.stepHidsToHit != null && !this.stepHidsToHit.isEmpty();
    }

    private void addNewHidsFromSet(Set<IHidObject> allHids, Set<IHidObject> initializationHids) {
        for (IHidObject hidObject : initializationHids) {
            if (this.hasHid(hidObject, allHids)) continue;
            allHids.add(hidObject);
        }
    }

    private void addHidsToSet(IHidObject hidObject, Set<IHidObject> hidsSet, boolean onlyOperators) {
        Predicate<IHidObject> filterHids = hid -> {
            if (!onlyOperators && hid instanceof RfHid) {
                IRfNamedElement namedElement = ((RfHid)((Object)hid)).getElement();
                if (namedElement != null && (!ELUtils.isVLOGConstant((IRfNamedElement)namedElement) || ((IRfFieldElement)namedElement).isGenvar())) {
                    hidsSet.add((IHidObject)hid);
                }
            } else if (!onlyOperators && hid instanceof RfHidAccessArgs) {
                RfHidAccessArgs hidAccessArgs = (RfHidAccessArgs)((Object)hid);
                if (hidAccessArgs.isMethodCall(false) && hidAccessArgs.getParentHid() != null) {
                    this.addHidsToSet((IHidObject)hidAccessArgs.getParentHid().getParentHid(), hidsSet, onlyOperators);
                }
            } else if (!onlyOperators && hid instanceof RfHidAccess) {
                Hid parent = ((RfHidAccess)((Object)hid)).getParentHid();
                if (parent != null) {
                    IRfNamedElement namedElement = parent.getElement();
                    if (namedElement == null) {
                        return true;
                    }
                    if (namedElement instanceof RfField && ((RfField)namedElement).isConst() || ELUtils.isVLOGConstant((IRfNamedElement)namedElement)) {
                        return true;
                    }
                    hidsSet.add((IHidObject)hid);
                }
            } else if (onlyOperators && hid instanceof RfHidOperator) {
                RfHidOperator hidOperator = (RfHidOperator)hid;
                if (hidOperator.isAssignment() || hidsSet.isEmpty() && (hidOperator.isArithmeticAssignment() || hidOperator.isIncrementOrDecrement())) {
                    this.addHidsToSet(((RfHidOperator)hid).getLHValue(), hidsSet, false);
                    return false;
                }
            } else if (!onlyOperators && !(hid instanceof RfHidOperator)) {
                hidsSet.add((IHidObject)hid);
            }
            return true;
        };
        HidUtils.flattenToObjects(filterHids, (IHidObject)hidObject, EnumSet.of(HidFlatteningOption.IGNORE_CONSTANTS, HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS));
    }

    private void computeSetDifference(Set<IHidObject> allHids, Set<IHidObject> initializationHids, Set<IHidObject> conditionHids, Set<IHidObject> stepHids) {
        for (IHidObject hid : allHids) {
            if (initializationHids == null || initializationHids.isEmpty() || !this.hasHid(hid, initializationHids)) {
                this.initializationHidsToHit.add(hid);
            }
            if (conditionHids == null || conditionHids.isEmpty() || !this.hasHid(hid, conditionHids)) {
                this.conditionHidsToHit.add(hid);
            }
            if (stepHids != null && !stepHids.isEmpty() && this.hasHid(hid, stepHids)) continue;
            this.stepHidsToHit.add(hid);
        }
    }

    private boolean hasHid(IHidObject hidToFind, Set<IHidObject> SetOfHids) {
        if (hidToFind instanceof RfHidImplicit) {
            return this.hasHidImplicitReference((RfHidImplicit)hidToFind, SetOfHids);
        }
        if (hidToFind instanceof RfHidAccess) {
            hidToFind = ((RfHidAccess)hidToFind).getParentHid();
        }
        if (!(hidToFind instanceof RfHid)) {
            return false;
        }
        RfHid rfHidToFind = (RfHid)hidToFind;
        for (IHidObject hid : SetOfHids) {
            RfHid rfHid;
            if (hid instanceof RfHidImplicit) {
                String hidToFindName = HidUtils.toNiceString((IHidObject)hidToFind);
                String hidName = ((RfHidImplicit)hid).getName();
                if (hidToFindName == null || hidName == null) continue;
                if (hidName.equals(hidToFindName)) {
                    return true;
                }
            }
            if (hid instanceof RfHidAccess) {
                hid = ((RfHidAccess)hid).getParentHid();
            }
            if (!(hid instanceof RfHid) || !(rfHid = (RfHid)hid).equals((Object)rfHidToFind)) continue;
            return true;
        }
        return false;
    }

    private boolean hasHidImplicitReference(RfHidImplicit hidImplicit, Set<IHidObject> SetOfHids) {
        String hidToFindName = hidImplicit.getName();
        for (IHidObject hid : SetOfHids) {
            String hidName = HidUtils.toNiceString((IHidObject)hid);
            if (hidToFindName == null || hidName == null || !hidName.equals(hidToFindName)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void addHits(RfNamedElement namedElement) {
        this.addHitsForHids(namedElement, this.initializationHidsToHit, "initialization");
        this.addHitsForHids(namedElement, this.conditionHidsToHit, "condition");
        this.addHitsForHids(namedElement, this.stepHidsToHit, "step");
    }

    private void addHitsForHids(RfNamedElement namedElement, Set<IHidObject> hidsToHit, String section) {
        for (IHidObject hidObject : hidsToHit) {
            this.addHit(namedElement, this.getHitMessage(hidObject, section));
        }
    }

    protected String getHitMessage(IHidObject hid, String section) {
        return "For loop " + section + ("initialization".equals(section) ? " does not initialize" : " is missing") + " variable '" + HidUtils.toNiceString((IHidObject)hid) + "'!";
    }

    @Override
    protected String getHitMessage() {
        return null;
    }
}

