/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfAbstractBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="25.1.8")
@CheckID(value="R.1391")
@CheckName(value="R.1391")
@CheckLabel(labels={RuleLabel.PROCEDURAL_STATEMENT, RuleLabel.PERFORMANCE, RuleLabel.METHOD, RuleLabel.LOOP})
@CheckTitle(value="Do not call functions inside loop statements")
@CheckDescription(value="This check flags function calls used in conditions of loop statements.\nRecalculating a function's result each time the condition of a loop is evaluated can add a significant performance overhead.\nIn such cases, the function's return value should be precomputed.\n\nExamples:\n\nfor (i = 0; i < foo(); i++)\t\t// not allowed\n\nlimit = foo();\nfor (i = 0; i < limit; i++)\t\t// allowed\n\nwhile (x > bar())\t\t\t\t\t// not allowed\n\nlimit = bar();\nwhile (x > limit)\t\t\t\t\t// allowed\n\nCheck supports pre-waiving.")
public class Check_R_1391
extends OVMComplianceCheck {
    private static final String ERROR_MESSAGE = "Function call ''{0}'' found in {1}!";
    private static final String ERROR_EMPTY_PARAM = "'loopTypes' parameter cannot be empty!";
    private static final String ERROR_INVALID_PARAM = "''{0}'' is not a valid value for 'loopTypes' paramter!";
    private static final Set<String> LOOP_TYPES = new HashSet<String>(Arrays.asList("for", "while", "do-while", "repeat"));
    private final Map<String, DVTPair<RfFunction, Boolean>> pureFunctionCache = new HashMap<String, DVTPair<RfFunction, Boolean>>();
    @CheckParameter(defaultValue="for, while, do-while, repeat", description="Comma separated list of loop types to be checked. Possible values: for, while, do-while, repeat.", name="loopTypes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pLoopTypes;
    @CheckParameter(defaultValue="", description="Comma separated list of method full names to be skipped. Predefined method names should be prefixed with one of the following values: [fixed_size_array], [dynamic_array], [associative_array], [queue], [enum], [scalar]. Examples: [dynamic_array].size, [scalar].string.len.", name="skipMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pSkipMethods;
    @CheckParameter(defaultValue="false", description="When true, only loop calls of deterministic functions are reported. A deterministic function, also known as a pure function or a referentially transparent function, is a method with the following properties:\n- for the same input arguments, the result will be the same, because it depends only on the argument values and no other external state or variable;\n- the method doesn't create any side-effects, like changing a global or external static variable.", name="skipNonDeterministicFunctions", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipNonDeterministicFunctions;

    public Check_R_1391(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        if (this.pLoopTypes == null || this.pLoopTypes.isEmpty()) {
            this.signalParamError(ERROR_EMPTY_PARAM, true);
        }
        for (String loopType : this.pLoopTypes) {
            if (LOOP_TYPES.contains(loopType)) continue;
            this.signalParamError(MessageFormat.format(ERROR_INVALID_PARAM, loopType), true);
        }
    }

    @Override
    public void performCheckImpl() {
        this.pureFunctionCache.clear();
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        List<RfActionBlock> actionBlocks = rfProject.getAllActionBlocks();
        if (actionBlocks == null || actionBlocks.isEmpty()) {
            return;
        }
        List<RfActionBlock> forLoops = null;
        List<RfActionBlock> whileLoops = null;
        List<RfActionBlock> doWhileLoops = null;
        List<RfActionBlock> repeatLoops = null;
        Iterator<String> iterator = this.pLoopTypes.iterator();
        while (iterator.hasNext()) {
            String loopType;
            switch (loopType = iterator.next()) {
                case "for": {
                    forLoops = actionBlocks.stream().filter(RfAbstractBlock::isFor).collect(Collectors.toList());
                    this.checkLoops(forLoops, loopType);
                    break;
                }
                case "while": {
                    whileLoops = actionBlocks.stream().filter(RfActionBlock::isWhile).collect(Collectors.toList());
                    this.checkLoops(whileLoops, loopType);
                    break;
                }
                case "do-while": {
                    doWhileLoops = actionBlocks.stream().filter(RfActionBlock::isDoWhile).collect(Collectors.toList());
                    this.checkLoops(doWhileLoops, loopType);
                    break;
                }
                case "repeat": {
                    repeatLoops = actionBlocks.stream().filter(RfActionBlock::isRepeat).collect(Collectors.toList());
                    this.checkLoops(repeatLoops, loopType);
                    break;
                }
            }
        }
    }

    public void checkLoops(List<RfActionBlock> loops, final String loopType) {
        if (loops == null || loops.isEmpty()) {
            return;
        }
        for (RfActionBlock loop : loops) {
            RfDefElement loopDeclaration = loop.getDeclaration();
            if (loopDeclaration == null || this.checkPreWaivers(loopDeclaration.getParserPath())) continue;
            this.notifyCheckAlive();
            loop.visitHidObject(null, (IHidVisitor<?>)new HidOperatorVisitor(null){

                public boolean visit(HidOperator operator) {
                    switch (loopType) {
                        case "for": {
                            if (operator.isForCondition()) break;
                            return true;
                        }
                        case "while": {
                            if (operator.isWhileCondition()) break;
                            return true;
                        }
                        case "do-while": {
                            if (operator.isWhileCondition()) break;
                            return true;
                        }
                        case "repeat": {
                            if (operator.isRepeatCondition()) break;
                            return true;
                        }
                        default: {
                            return true;
                        }
                    }
                    Check_R_1391.this.checkLoopForMethodCall(operator, this.parserPath, String.valueOf(loopType) + " condition");
                    return true;
                }
            });
        }
    }

    public void checkLoopForMethodCall(HidOperator operator, ParserPath parserPath, String statementType) {
        Set flattenedHids = HidUtils.flattenToHids((IHidObject)operator, (Set)HidFlatteningOption.IMPLICITS_EXCLUDED);
        for (IHid hid : flattenedHids) {
            RfFunction func;
            IRfNamedElement elem;
            if (!hid.isMethodCall(false) || !((elem = hid.getElement()) instanceof RfFunction) || this.pSkipMethods.contains(LintUtils.getNamedElementFullName(func = (RfFunction)elem)) || this.pSkipNonDeterministicFunctions && this.isPureFunction(hid, func)) continue;
            this.addHit(parserPath, (HidOccurrence)operator.getOccurrence(), MessageFormat.format(ERROR_MESSAGE, HidUtils.toNiceString((IHidObject)hid), statementType));
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isPureFunction(IHid hid, final RfFunction func) {
        DVTPair<RfFunction, Boolean> pureFuncValue = this.pureFunctionCache.get(func.getFullName());
        if (pureFuncValue != null && func.equals(pureFuncValue.getKey())) {
            return (Boolean)pureFuncValue.getValue();
        }
        if (func.isPredefined() && hid instanceof RfHid) {
            void field;
            RfField rfField;
            IRfNamedElement parentElement;
            IRfNamedElement iRfNamedElement;
            Hid parentHid = ((RfHid)hid).getParentHid();
            boolean isPure = false;
            if (!(parentHid == null || (iRfNamedElement = (parentElement = parentHid.getElement())) instanceof RfField && (rfField = (RfField)iRfNamedElement) == (RfField)iRfNamedElement && field.isField())) {
                isPure = true;
            }
            this.pureFunctionCache.put(func.getFullName(), (DVTPair<RfFunction, Boolean>)new DVTPair((Object)func, (Object)isPure));
            return isPure;
        }
        final AtomicBoolean isPure = new AtomicBoolean(true);
        func.visitHidObject(null, new IHidVisitor<RfHid>(){

            public boolean visit(RfHid hidObject) {
                IRfNamedElement element = hidObject.getElement();
                if (element == null) {
                    return true;
                }
                if (element instanceof RfFunction) {
                    if (element instanceof RfPredefinedFunction var3_4 && predefinedFunction.getName().startsWith("$")) {
                        isPure.set(false);
                        return false;
                    }
                    if (Check_R_1391.this.isPureFunction((IHid)hidObject, (RfFunction)element)) {
                        return true;
                    }
                }
                if ((enclosingScope = (RfFunction)element.getEnclosingScope(RfFunction.class)) == null || !func.equals(enclosingScope)) {
                    isPure.set(false);
                    return false;
                }
                return true;
            }

            public Class<RfHid> getType() {
                return RfHid.class;
            }
        });
        this.pureFunctionCache.put(func.getFullName(), (DVTPair<RfFunction, Boolean>)new DVTPair((Object)func, (Object)isPure.get()));
        return isPure.get();
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

