/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.ExplicitImportInfo;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.ImportInfo;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="25.1.10")
@CheckID(value="R.1392")
@CheckName(value="R.1392")
@CheckLabel(labels={RuleLabel.PACKAGE, RuleLabel.NAME})
@CheckTitle(value="Do not use unnecessarily package qualified names")
@CheckDescription(value="This rule checks that the package name is not specified when used in the package itself or when already explicitly imported.\nSpecifying the package name is ultimately unnecessary.\n\nExample:\n\npackage p;\n  typedef int type1;\nendpackage\n\npackage p2;\n  typedef int type2;\n  class c1;\n    p::type1 a;\t\t// allowed\n    type2 b;\t\t\t// allowed\n    p2::type2 c;\t\t// not allowed\n  endclass\nendpackage\n\nCheck supports pre-waiving.")
public class Check_R_1392
extends OVMComplianceCheck {
    private Map<RfPackage, Map<RfPackage, Set<Object>>> importsPerPackage;
    private Map<String, RfPackage> packageNameToElement;

    public Check_R_1392(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        this.importsPerPackage = new HashMap<RfPackage, Map<RfPackage, Set<Object>>>();
        this.packageNameToElement = new HashMap<String, RfPackage>();
        List<RfPackage> packages = rfProject.getAllPackages(false);
        for (final RfPackage currPackage : packages) {
            NullProtectedList<ImportInfo> imports = currPackage.getAllImportDeclarations();
            this.importsPerPackage.put(currPackage, new HashMap());
            for (ImportInfo currImport : imports) {
                this.importsPerPackage.get(currPackage).putIfAbsent((RfPackage)currImport.getPackage(), new HashSet());
                if (currImport instanceof ExplicitImportInfo) {
                    IRfNamedElement element = ((ExplicitImportInfo)currImport).getElement();
                    this.importsPerPackage.get(currPackage).get(currImport.getPackage()).add(element);
                    continue;
                }
                this.importsPerPackage.get(currPackage).get(currImport.getPackage()).add("wildcard");
            }
            this.packageNameToElement.put(currPackage.getName(), currPackage);
            currPackage.visitHidObject(rfProject, new RfHidVisitor(){

                public boolean visit(RfHid hid) {
                    if (hid == null) {
                        return true;
                    }
                    Check_R_1392.this.notifyCheckAlive();
                    if (Check_R_1392.this.checkPreWaivers(this.parserPath)) {
                        return true;
                    }
                    IRfNamedElement hidNamedElement = hid.getElement();
                    if (!(hidNamedElement instanceof RfField || hidNamedElement instanceof RfFunction || hidNamedElement instanceof RfTypeAlias)) {
                        return true;
                    }
                    HidAccess parentAccess = hid.getParentAccess();
                    if (parentAccess == null) {
                        return true;
                    }
                    if (parentAccess.getAccessKind() != 2) {
                        return true;
                    }
                    Hid parentHid = parentAccess.getParentHid();
                    if (parentHid == null) {
                        return true;
                    }
                    if ((parentHid = parentHid.getAncestorHid()) == null) {
                        return true;
                    }
                    IRfNamedElement parentElement = parentHid.getElement();
                    if (!(parentElement instanceof RfPackage)) {
                        return true;
                    }
                    Set<Object> imported = null;
                    if (Check_R_1392.this.importsPerPackage.get(currPackage) != null) {
                        imported = Check_R_1392.this.importsPerPackage.get(currPackage).get(parentElement);
                    }
                    if (parentElement.equals(currPackage) || imported != null && !imported.isEmpty() && (imported.contains("wildcard") || imported.contains(hidNamedElement))) {
                        Check_R_1392.this.addHit(this.parserPath, hid, "Unnecessary reference to package '" + ((RfPackage)parentElement).getFullName() + "' inside package '" + currPackage.getFullName() + "'!");
                    }
                    return true;
                }
            });
        }
        rfProject.accept(new NamedElementVisitor());
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    private final class NamedElementVisitor
    implements IRfNamedElementVisitor {
        private NamedElementVisitor() {
        }

        @Override
        public boolean visit(RfNamedElement namedElement) {
            Set<Object> imported;
            RfPackage actualScope;
            String scopetype;
            DataType packageScope;
            RfPackage enclosingPackage;
            Check_R_1392.this.notifyCheckAlive();
            if (Check_R_1392.this.checkPreWaivers(namedElement.getFile())) {
                return true;
            }
            if (namedElement instanceof RfClass) {
                RfClass clazz = (RfClass)namedElement;
                RfClass parent = clazz.getParent();
                DataType extendedType = clazz.getExtendedType();
                enclosingPackage = clazz.getEnclosingPackage();
                if (parent instanceof RfSpecializedClass) {
                    this.analyzeSpecialisedClass(namedElement, extendedType);
                } else if (extendedType != null && (packageScope = extendedType.getPackageScope()) != null) {
                    scopetype = packageScope.getType();
                    actualScope = Check_R_1392.this.packageNameToElement.get(scopetype);
                    imported = null;
                    if (Check_R_1392.this.importsPerPackage.get(enclosingPackage) != null) {
                        imported = Check_R_1392.this.importsPerPackage.get(enclosingPackage).get(actualScope);
                    }
                    if (enclosingPackage.equals(actualScope) || imported != null && !imported.isEmpty() && (imported.contains("wildcard") || imported.contains(parent))) {
                        Check_R_1392.this.addHit(clazz, "Unnecessary reference to package '" + actualScope.getFullName() + "' inside package '" + enclosingPackage.getFullName() + "'!");
                    }
                }
            }
            if (namedElement instanceof RfAssociatedType) {
                RfAssociatedType associatedType = (RfAssociatedType)namedElement;
                IRfNamedElement type = associatedType.getAssociatedType();
                if (type instanceof RfTypeAlias || type instanceof RfClass) {
                    DataType fieldDataType = associatedType.getDataType();
                    enclosingPackage = associatedType.getEnclosingPackage();
                    if (fieldDataType != null && (packageScope = fieldDataType.getPackageScope()) != null) {
                        scopetype = packageScope.getType();
                        actualScope = Check_R_1392.this.packageNameToElement.get(scopetype);
                        imported = null;
                        if (Check_R_1392.this.importsPerPackage.get(enclosingPackage) != null) {
                            imported = Check_R_1392.this.importsPerPackage.get(enclosingPackage).get(actualScope);
                        }
                        if (enclosingPackage.equals(actualScope) || imported != null && !imported.isEmpty() && (imported.contains("wildcard") || imported.contains(type))) {
                            Check_R_1392.this.addHit(associatedType, "Unnecessary reference to package '" + actualScope.getFullName() + "' inside package '" + enclosingPackage.getFullName() + "'!");
                        }
                    }
                }
                if (type instanceof RfSpecializedClass) {
                    DataType dataType = associatedType.getDataType();
                    this.analyzeSpecialisedClass(namedElement, dataType);
                }
            }
            return true;
        }

        public void analyzeSpecialisedClass(RfNamedElement visitedElement, DataType classDataType) {
            ArrayList<DataType> parameterDataTypes = new ArrayList<DataType>();
            List<DataType> orderedParamAssignments = classDataType.getOrderedParamAssignments();
            Map<String, ArgInfo> namedParamAssignments = classDataType.getNamedParamAssignments();
            if (orderedParamAssignments != null) {
                parameterDataTypes.addAll(orderedParamAssignments);
            }
            if (namedParamAssignments != null) {
                parameterDataTypes.addAll(namedParamAssignments.values().stream().map(ArgInfo::getDataType).collect(Collectors.toList()));
            }
            if (parameterDataTypes == null || parameterDataTypes.isEmpty()) {
                return;
            }
            for (DataType parameterType : parameterDataTypes) {
                if (parameterType.getOrderedParamAssignments() != null || parameterType.getNamedParamAssignments() != null) {
                    this.analyzeSpecialisedClass(visitedElement, parameterType);
                    continue;
                }
                if (!(visitedElement instanceof RfClass) && !(visitedElement instanceof RfField)) continue;
                RfNamedElement field = visitedElement;
                RfPackage packageScope = field.getEnclosingPackage();
                DataType actualScopeDataType = parameterType.getPackageScope();
                String typeName = parameterType.getType();
                if (actualScopeDataType == null) continue;
                String actualScopeType = actualScopeDataType.getType();
                RfPackage actualScope = Check_R_1392.this.packageNameToElement.get(actualScopeType);
                Set<Object> imported = null;
                if (Check_R_1392.this.importsPerPackage.get(packageScope) != null) {
                    imported = Check_R_1392.this.importsPerPackage.get(packageScope).get(actualScope);
                }
                if (actualScope == null || !packageScope.equals(actualScope) && (imported == null || imported.isEmpty() || !imported.contains("wildcard") && !imported.contains(typeName))) continue;
                Check_R_1392.this.addHit(field, "Unnecessary reference to package '" + actualScope.getFullName() + "' inside package '" + packageScope.getFullName() + "'!");
            }
        }
    }
}

