/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractPackageImportCheck;
import ro.amiq.vlogdt.model.reflection.ExplicitImportInfo;
import ro.amiq.vlogdt.model.reflection.ImportInfo;

@CheckVersion(value="25.1.8")
@CheckID(value="R.1393")
@CheckName(value="R.1393")
@CheckLabel(labels={RuleLabel.PACKAGE, RuleLabel.IMPORT})
@CheckTitle(value="Do not use type imports")
@CheckDescription(value="For clarity, when a type from a package is used, it's recommended to not explicitly import it.\nInstead, it's better to use the fully qualified name of the type.\nThat way, when a usage is fully scoped, it's clearly an imported one, and when it's not, it's declared in the same package.\nOn top of that, in case there are any unused imported types, you don't risk poluting the current namespace with unnecessary elements.\n\nExample:\nimport my_pkg::my_type;    // not allowed\n\nmy_pkg::my_type my_field;  // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1393
extends AbstractPackageImportCheck {
    public Check_R_1393(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected boolean skipImportType(ImportInfo importInfo) {
        return !(importInfo instanceof ExplicitImportInfo);
    }

    @Override
    protected String getErrorMessage(ImportInfo importInfo) {
        return "Not allowed type import '" + importInfo.getPackageName() + "::" + ((ExplicitImportInfo)importInfo).getElementName() + "'!";
    }
}

