/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintDHUtils;
import ro.amiq.vlogdt.model.reflection.ExplicitImportInfo;
import ro.amiq.vlogdt.model.reflection.ImportInfo;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogPreprocessingInfo;

@CheckVersion(value="25.1.8")
@CheckID(value="R.1394")
@CheckName(value="R.1394")
@CheckLabel(labels={RuleLabel.DEAD_CODE, RuleLabel.FILE})
@CheckTitle(value="Do not use files irrelevant for design elaboration")
@CheckDescription(value="Do not use as compiler arguments source code files that are not required in order to perform the design elaboration.\nBy default the rule will report the source code files that are used as compilation arguments, but are not necessary for the design elaboration.")
public class Check_R_1394
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of top module names or instance paths.", name="moduleValue", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pModuleValue;
    @CheckParameter(defaultValue="true", description="When true, the unused top files are reported.", name="unusedTopFiles", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pUnusedTopFiles;
    @CheckParameter(defaultValue="false", description="When true, the unused files included by unused top files are reported.", name="unusedIncludedByUnusedTopFiles", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pUnusedIncludedByUnusedTopFiles;
    @CheckParameter(defaultValue="false", description="When true, the unused files included by used top files are reported.", name="unusedIncludedByUsedTopFiles", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pUnusedIncludedByUsedTopFiles;
    @CheckParameter(defaultValue="false", description="When true, enables the analysis of every possible combination of parameter values, ensuring all branches within conditional generate blocks are explored.", name="analyzeAllGenerateBranches", isVisible=false, required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAnalyzeAllGenerateBranches;

    public Check_R_1394(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        super.preBuildNotification(aRfProject);
    }

    @Override
    public void performCheckImpl() {
        VlogFileInstance topFileInstance;
        List<ParserPath> files = this.fOVMProject.getAllFilesInOrder();
        if (files.isEmpty()) {
            return;
        }
        HashSet<ParserPath> compiledUnusedFiles = new HashSet<ParserPath>(files);
        RfProject rfProject = this.fOVMProject.getRfProject();
        List<Object> topDesignElements = null;
        if (this.pModuleValue.isEmpty()) {
            LintDHUtils.GetTopsResult topsResult = LintDHUtils.getTops(this.fOVMProject.getProject(), true);
            topDesignElements = topsResult == null || topsResult.isEmpty() ? Collections.emptyList() : topsResult.getTops();
        } else {
            topDesignElements = new ArrayList();
            for (String modulePathName : this.pModuleValue) {
                this.notifyCheckAlive();
                ElementPath elementPath = null;
                elementPath = !modulePathName.contains(".") ? LintDHUtils.computeElementPathFromModuleName(rfProject, modulePathName) : LintDHUtils.getElementPathFromHierarchyPath(modulePathName);
                if (elementPath == null) {
                    this.addHit(new ParserPath("none"), 0, "The specified module path '" + modulePathName + "' is not in the design hierarchy!", null);
                    continue;
                }
                ELInstance eLInstance = Check_R_1394.instanceFor(rfProject, elementPath);
                if (eLInstance == null) {
                    this.addHit(new ParserPath("none"), 0, "The specified module path '" + modulePathName + "' is not in the design hierarchy!", null);
                    continue;
                }
                IRfNamedElement topNamedElement = eLInstance.getBinding(false);
                topDesignElements.add(topNamedElement);
            }
        }
        Set<IRfNamedElement> visited = Collections.newSetFromMap(new IdentityHashMap());
        Set<IRfNamedElement> namedElements = Collections.newSetFromMap(new IdentityHashMap());
        HashSet<ParserPath> parserPaths = new HashSet<ParserPath>();
        for (IRfNamedElement iRfNamedElement : topDesignElements) {
            this.notifyCheckAlive();
            Check_R_1394.addNamedElement(namedElements, iRfNamedElement);
            Check_R_1394.visitNamedElement(visited, namedElements, parserPaths, this.pAnalyzeAllGenerateBranches, this, iRfNamedElement);
            Map<ElementPath, ELInstance> designHierarchyTree = LintDHUtils.computeDHWithElaborationForElement(rfProject, iRfNamedElement);
            if (designHierarchyTree == null) continue;
            this.visitDesignElement(visited, parserPaths, namedElements, designHierarchyTree);
        }
        block2: while (true) {
            this.notifyCheckAlive();
            Set<IRfFileDef> set = this.collectFileDefs(namedElements);
            Set<IRfNamedElement> newNamedElements = this.collectFirstLevelNamedElements(set);
            newNamedElements.removeAll(namedElements);
            if (newNamedElements.isEmpty()) break;
            Iterator<IRfNamedElement> iterator = newNamedElements.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block2;
                IRfNamedElement newNamedElement = iterator.next();
                this.notifyCheckAlive();
                Check_R_1394.addNamedElement(namedElements, newNamedElement);
                Check_R_1394.visitNamedElement(visited, namedElements, parserPaths, this.pAnalyzeAllGenerateBranches, this, newNamedElement);
            }
            break;
        }
        for (IRfNamedElement iRfNamedElement : namedElements) {
            this.notifyCheckAlive();
            ParserPath parserPath = Check_R_1394.getParserPath(iRfNamedElement);
            if (parserPath == null) continue;
            parserPaths.add(parserPath);
        }
        compiledUnusedFiles.removeAll(parserPaths);
        HashSet<ParserPath> hashSet = new HashSet<ParserPath>();
        HashSet<ParserPath> includedByOtherFile = new HashSet<ParserPath>();
        VlogPreprocessingInfo preprocessingInfo = rfProject.getPreprocessingTable();
        VlogFileInstance vlogFileInstance = topFileInstance = preprocessingInfo == null ? null : preprocessingInfo.getTopFileInstance();
        if (topFileInstance != null) {
            Iterator iterator = compiledUnusedFiles.iterator();
            while (iterator.hasNext()) {
                this.notifyCheckAlive();
                ParserPath parserPath = (ParserPath)iterator.next();
                boolean isIncludedByOtherFile = true;
                List<VlogFileInstance> fileInstances = topFileInstance.getFileInstances(parserPath);
                if (fileInstances == null) continue;
                for (VlogFileInstance fileInstance : fileInstances) {
                    this.notifyCheckAlive();
                    IDVTFileInstance includingInstance = fileInstance.getIncludingInstance();
                    if (includingInstance == null) continue;
                    if (includingInstance == topFileInstance) {
                        isIncludedByOtherFile = false;
                        break;
                    }
                    String shortFileName = ((VlogFileInstance)includingInstance).getShortFileName();
                    if (shortFileName.startsWith("__vlog__") && shortFileName.endsWith(".libfile")) {
                        isIncludedByOtherFile = false;
                        break;
                    }
                    if (compiledUnusedFiles.contains(includingInstance.getParserPath())) continue;
                    hashSet.add(parserPath);
                }
                if (!isIncludedByOtherFile) continue;
                includedByOtherFile.add(parserPath);
            }
        }
        this.addHitsForUselessFiles(compiledUnusedFiles, hashSet, includedByOtherFile);
    }

    private Set<IRfFileDef> collectFileDefs(Set<IRfNamedElement> namedElements) {
        Set<IRfFileDef> fileDefs = Collections.newSetFromMap(new IdentityHashMap());
        for (IRfNamedElement namedElement : namedElements) {
            IRfFileDef fileDef;
            IRfDefElement declaration;
            this.notifyCheckAlive();
            if (namedElement == null || (declaration = namedElement.getDeclaration()) == null || (fileDef = declaration.getDefFile()) == null) continue;
            fileDefs.add(fileDef);
        }
        return fileDefs;
    }

    private Set<IRfNamedElement> collectFirstLevelNamedElements(Set<IRfFileDef> fileDefs) {
        if (fileDefs == null || fileDefs.isEmpty()) {
            return Collections.emptySet();
        }
        Set<IRfNamedElement> namedElements = Collections.newSetFromMap(new IdentityHashMap());
        for (IRfFileDef fileDef : fileDefs) {
            Collection<RfDefElement> inFileDefs;
            if (!(fileDef instanceof RfFileDef) || (inFileDefs = ((RfFileDef)fileDef).getChildren()) == null) continue;
            for (RfDefElement defElement : inFileDefs) {
                RfNamedElement namedElement = defElement.getNamedElement();
                Check_R_1394.addNamedElement(namedElements, namedElement);
            }
        }
        return namedElements;
    }

    private static ELInstance instanceFor(RfProject rfProject, ElementPath elementPath) {
        if (rfProject == null) {
            return null;
        }
        ELManager elManager = rfProject.getELManager();
        if (elManager == null) {
            return null;
        }
        IELMemory memory = elManager.getMemory();
        if (memory == null) {
            return null;
        }
        return memory.instanceFor(elementPath);
    }

    public static ParserPath getParserPath(IRfNamedElement namedElement) {
        if (namedElement == null) {
            return null;
        }
        IRfDefElement declaration = namedElement.getDeclaration();
        if (declaration == null) {
            return null;
        }
        return declaration.getParserPath();
    }

    public static ParserPath getParserPath(IReparseInfo reparseInfo) {
        if (reparseInfo == null) {
            return null;
        }
        return reparseInfo.getLastReparseMacroFile();
    }

    private void visitDesignElement(Set<IRfNamedElement> visited, Set<ParserPath> parserPaths, Set<IRfNamedElement> namedElements, Map<ElementPath, ELInstance> treeMap) {
        for (ELInstance instance : treeMap.values()) {
            IRfNamedElement designElement;
            this.notifyCheckAlive();
            if (instance == null || (designElement = instance.getBinding(false)) == null) continue;
            Check_R_1394.addNamedElement(namedElements, designElement);
            Check_R_1394.visitNamedElement(visited, namedElements, parserPaths, this.pAnalyzeAllGenerateBranches, this, designElement);
        }
    }

    private static void addDefineParserPath(Set<ParserPath> definesParserPaths, IReparseInfo reparseInfo) {
        if (reparseInfo == null) {
            return;
        }
        reparseInfo.collectParserPaths(definesParserPaths);
    }

    private static void addNamedElement(Set<IRfNamedElement> namedElements, Hid hid) {
        if (hid == null) {
            return;
        }
        Hid parentHid = hid;
        do {
            Check_R_1394.addNamedElement(namedElements, parentHid.getElement());
            HidAccess parentAccess = parentHid.getParentAccess();
            if (parentAccess == null) continue;
            Check_R_1394.addNamedElement(namedElements, parentAccess.getAssociatedType());
        } while ((parentHid = parentHid.getParentHid()) != null);
    }

    private static boolean addNamedElement(Set<IRfNamedElement> namedElements, IRfNamedElement element) {
        if (element == null) {
            return false;
        }
        if (element instanceof RfProject) {
            return false;
        }
        if (element.isPredefined()) {
            return false;
        }
        if (element.getDeclaration() == null) {
            return false;
        }
        return namedElements.add(element);
    }

    private static void visitImportedNamedElements(Set<IRfNamedElement> visited, Set<IRfNamedElement> namedElements, Set<ParserPath> parserPaths, IRfNamedElement element, boolean analyzeAllGenerateBranches, OVMComplianceCheck linterCheck) {
        List<ExplicitImportInfo> explicitImports;
        if (!(element instanceof RfNamedElement)) {
            return;
        }
        List<ImportInfo> imports = ((RfNamedElement)element).getWildcardImports();
        if (imports != null && !imports.isEmpty()) {
            for (ImportInfo importInfo : imports) {
                IRfPackageElement package1 = importInfo.getPackage();
                Check_R_1394.addNamedElement(namedElements, (IRfNamedElement)package1);
                Check_R_1394.visitNamedElement(visited, namedElements, parserPaths, analyzeAllGenerateBranches, linterCheck, (IRfNamedElement)package1);
            }
        }
        if ((explicitImports = ((RfNamedElement)element).getExplicitImports()) != null && !explicitImports.isEmpty()) {
            for (ExplicitImportInfo importInfo : explicitImports) {
                IRfPackageElement package1 = importInfo.getPackage();
                Check_R_1394.addNamedElement(namedElements, (IRfNamedElement)package1);
                Check_R_1394.visitNamedElement(visited, namedElements, parserPaths, analyzeAllGenerateBranches, linterCheck, (IRfNamedElement)package1);
            }
        }
    }

    private static void visitNamedElement(Set<IRfNamedElement> visited, Set<IRfNamedElement> namedElements, Set<ParserPath> parserPaths, boolean analyzeAllGenerateBranches, OVMComplianceCheck linterCheck, IRfNamedElement namedElement) {
        if (visited.contains(namedElement)) {
            return;
        }
        visited.add(namedElement);
        namedElement.visitHidObject(null, (IHidVisitor)new HidObjectVisitor(visited, namedElement, parserPaths, namedElements, analyzeAllGenerateBranches, linterCheck));
    }

    private void addHitsForUselessFiles(Set<ParserPath> compiledUnusedFiles, Set<ParserPath> includedByUsedFile, Set<ParserPath> includedByOtherFile) {
        for (ParserPath unusedFile : compiledUnusedFiles) {
            String path = unusedFile.path;
            String fileName = path.substring(path.lastIndexOf(File.separator) + 1);
            if (fileName.startsWith("__vlog__")) continue;
            if (includedByUsedFile.contains(unusedFile)) {
                if (!this.pUnusedIncludedByUsedTopFiles) continue;
                this.addHit(unusedFile, 1, "Unused file '" + unusedFile.path + "' included by a used top file!", null);
                continue;
            }
            if (includedByOtherFile.contains(unusedFile)) {
                if (!this.pUnusedIncludedByUnusedTopFiles) continue;
                this.addHit(unusedFile, 1, "Unused file '" + unusedFile.path + "' included by an unused top file!", null);
                continue;
            }
            if (!this.pUnusedTopFiles) continue;
            this.addHit(unusedFile, 1, "Unused top file '" + unusedFile.path + "'!", null);
        }
    }

    private static class HidObjectVisitor
    implements IHidVisitor<IHidObject> {
        private Set<IRfNamedElement> visited;
        private IRfNamedElement designElement;
        private Set<ParserPath> parserPaths;
        private Set<IRfNamedElement> namedElements;
        private OVMComplianceCheck complianceCheck;
        private boolean analyzeAllGenerateBranches;
        private boolean isGenerateBlockScope;

        public HidObjectVisitor(Set<IRfNamedElement> visited, IRfNamedElement designElement, Set<ParserPath> parserPaths, Set<IRfNamedElement> namedElements, boolean analyzeAllGenerateBranches, OVMComplianceCheck complianceCheck) {
            this.visited = visited;
            this.designElement = designElement;
            this.parserPaths = parserPaths;
            this.namedElements = namedElements;
            this.analyzeAllGenerateBranches = analyzeAllGenerateBranches;
            this.complianceCheck = complianceCheck;
            Check_R_1394.visitImportedNamedElements(visited, namedElements, parserPaths, designElement, analyzeAllGenerateBranches, complianceCheck);
        }

        public boolean enterDataTypes() {
            return true;
        }

        public boolean enterBindInstances() {
            return false;
        }

        public void setScope(IRfNamedElement scope) {
            if (!this.analyzeAllGenerateBranches && scope instanceof RfGenerateBlock && scope != this.designElement) {
                this.isGenerateBlockScope = true;
                return;
            }
            Check_R_1394.visitImportedNamedElements(this.visited, this.namedElements, this.parserPaths, scope, this.analyzeAllGenerateBranches, this.complianceCheck);
            this.collectAssociatedTypes(scope);
        }

        /*
         * Unable to fully structure code
         */
        private void collectAssociatedTypes(IRfNamedElement scope) {
            if (!(scope instanceof RfNamedElement)) {
                return;
            }
            membersIterator = ((RfNamedElement)scope).getLocalMembersIterator(true);
            if (membersIterator != null && membersIterator.hasNext()) ** GOTO lbl11
            return;
lbl-1000:
            // 1 sources

            {
                localMember = membersIterator.next();
                if (!(localMember instanceof RfAssociatedType)) continue;
                associatedType = ((RfAssociatedType)localMember).getAssociatedType();
                Check_R_1394.addNamedElement(this.namedElements, associatedType);
lbl11:
                // 3 sources

                ** while (membersIterator.hasNext())
            }
lbl12:
            // 1 sources

        }

        public void endScope(IRfNamedElement scope) {
            if (scope instanceof RfGenerateBlock && scope != this.designElement) {
                this.isGenerateBlockScope = false;
            }
        }

        public boolean visit(IHidObject hidObject) {
            this.complianceCheck.notifyCheckAlive();
            if (this.isGenerateBlockScope) {
                return true;
            }
            if (hidObject instanceof Hid) {
                Check_R_1394.addNamedElement(this.namedElements, (Hid)hidObject);
                IReparseInfo reparseInfo = ((IHid)hidObject).getReparseInfo();
                Check_R_1394.addDefineParserPath(this.parserPaths, reparseInfo);
            } else {
                Set hids = HidUtils.flattenToHids((IHidObject)hidObject, Collections.emptySet());
                for (IHid hid : hids) {
                    if (hid instanceof Hid) {
                        Check_R_1394.addNamedElement(this.namedElements, (Hid)hid);
                    }
                    IReparseInfo reparseInfo = hid.getReparseInfo();
                    Check_R_1394.addDefineParserPath(this.parserPaths, reparseInfo);
                }
            }
            return true;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

