/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import org.apache.commons.lang.RandomStringUtils;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.parser.VlogException;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.parser.VlogMacroParameter;
import ro.amiq.vlogdt.parser.VlogMacroText;

@CheckVersion(value="25.1.9")
@CheckID(value="R.1395")
@CheckName(value="R.1395")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.MACRO, RuleLabel.ARGUMENT})
@CheckTitle(value="Macro arguments in arithmetical expression should be enclosed in parentheses")
@CheckDescription(value="Macro arguments used in arithmetic expressions must be enclosed in parentheses in order to ensure that the intended order of operations is preserved when the macro is pre-processed and the argument value is replaced in the source file as it is.\nIf parentheses are missing the order of operations might change the end result of the expression.\n\nRelated check: SVTB.10.1.1 Macros used in arithmetic expressions must be enclosed in parenthesis\n\nImplementation notes:\nSince a macro definition has no syntactic or semantic meaning until it's actually used, the rule analyses the macro literal definition by searching for the argument usages and, for each usage, it checks if that argument is either a left hand side or right hand side operand of an arithmetical expression (addition, subtraction, multiplication and division).\nIf the argument is an operand without being enclosed in parentheses, the check will report an error.\n\nExamples:\n\n`define diff(a, b) a - b        // not allowed\n`define diff2(a, b) (a) - (b)   // allowed\n\nclass my_class;\n\tinteger result, a, b, c, d;\n\n\tfunction void foo()\n\t\tresult = `diff(a + b, c + d);     // after pre-processing, this actually becomes a + b - c + d, which might not be the intended result.\n\t\tresult = `diff2(a + b, c + d);    // after pre-processing, this actually becomes (a + b) - (c + d), which is the expected result.\n\tendfunction\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1395
extends OVMComplianceCheck {
    public Check_R_1395(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (VlogMacroInfo macro : this.fOVMProject.getAllMacros()) {
            VlogFileInstance fileInstance = macro.getFileInstance();
            if (fileInstance == null || fileInstance.getShortFileName().startsWith("__vlog__")) continue;
            this.notifyCheckAlive();
            if (this.checkPreWaivers(fileInstance.getParserPath()) || !macro.isReplacementMacro()) continue;
            List<VlogMacroInfo> macroLayers = macro.getMacroZoneLayers();
            try {
                for (VlogMacroInfo macroLayer : macroLayers) {
                    List<VlogMacroParameter> parameters;
                    VlogMacroText macroText = macroLayer.getMacroText();
                    if (macroText == null || (parameters = macroText.getMacroParameters()) == null || parameters.isEmpty()) continue;
                    String[] generatedParams = new String[parameters.size()];
                    int i = 0;
                    while (i < parameters.size()) {
                        generatedParams[i] = RandomStringUtils.randomAlphabetic((int)16);
                        ++i;
                    }
                    String replacedString = macroText.getReplacement(fileInstance, generatedParams);
                    int i2 = 0;
                    while (i2 < parameters.size()) {
                        int startIndex = -1;
                        while ((startIndex = replacedString.indexOf(generatedParams[i2], startIndex + 1)) >= 0) {
                            int endIndex = startIndex + generatedParams[i2].length();
                            int prevCharOffset = DVTStringUtil.getLastNWSDifferentFromCharReverseIndex((String)replacedString.substring(0, startIndex), (char)'\\');
                            int nextCharOffset = DVTStringUtil.getFirstNWSDifferentFromCharIndex((String)replacedString.substring(endIndex, replacedString.length()), (char)'\\');
                            char prevChar = '\u0000';
                            char nextChar = '\u0000';
                            int prevCharIndex = startIndex - prevCharOffset - 1;
                            int nextCharIndex = endIndex + nextCharOffset;
                            if (prevCharIndex >= 0) {
                                prevChar = replacedString.charAt(prevCharIndex);
                            }
                            if (nextCharIndex < replacedString.length()) {
                                nextChar = replacedString.charAt(nextCharIndex);
                            }
                            if (prevChar == '(' && nextChar == ')' || !this.isArithmentic(prevChar) && !this.isArithmentic(nextChar)) continue;
                            this.addHit(fileInstance.getParserPath(), macroLayer.getLine(), "Argument '" + parameters.get(i2).getName() + "' of macro '" + macroLayer.getName() + "' is used without parentheses in arithmetical expression!", null);
                        }
                        ++i2;
                    }
                }
            }
            catch (VlogException e) {
                this.fOVMProject.notifyCheckException(this, e);
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    private boolean isArithmentic(char charArg) {
        return charArg == '+' || charArg == '-' || charArg == '*' || charArg == '/';
    }

    private boolean checkPreWaivers(ParserPath path) {
        if (path == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this);
    }
}

