/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;

@CheckVersion(value="25.1.9")
@CheckID(value="R.1396")
@CheckName(value="R.1396")
@CheckLabel(labels={RuleLabel.MODULE, RuleLabel.PORT, RuleLabel.DESIGN_INSTANTIATION})
@CheckTitle(value="Do not leave DUT input ports unconnected")
@CheckDescription(value="For all DUT instances from the top modules, all input/inout ports must be properly connected in the top module.\nModules that call run_test are considered top modules.\n\nExample:\n\nmodule dut(\n    input pif1,\n    output reg pif2\n  );\n...\nendmodule\n\nmodule top;\n  reg r;\n\n  dut u_dut (   // NOT ALLOWED: input port 'pif1' is not connected\n\t  .pif2(r)\n  );\nendmodule\n\nCheck supports pre-waiving.")
public class Check_R_1396
extends OVMComplianceCheck {
    public Check_R_1396(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Set<RfNamedElement> topModules = LintUtils.getTopModulesCallingRunTest(this.fOVMProject);
        if (topModules == null || topModules.isEmpty()) {
            return;
        }
        for (RfNamedElement module : topModules) {
            ParserPath parserPath = module.getDeclaration().getParserPath();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
            module.accept(null, element -> {
                ListContainer portConnections;
                this.notifyCheckAlive();
                if (!(element instanceof RfInstance)) {
                    return true;
                }
                RfInstance instance = (RfInstance)element;
                RfNamedElement instanceType = LintUtils.getAssociatedFinalType(instance);
                if (!(instanceType instanceof RfModule)) {
                    return true;
                }
                List<RfPort> declarationInputPorts = this.getDeclarationInputPorts(instance);
                if (declarationInputPorts == null || declarationInputPorts.isEmpty()) {
                    return true;
                }
                RfHidHolder hidHolder = instance.getHidHolder();
                if (hidHolder != null && hidHolder.getHidObjectsMap() != null && (portConnections = (ListContainer)hidHolder.getHidObjectsMap().get(parserPath)) != null) {
                    for (IHidObject portHidObj : portConnections) {
                        RfHid portHid;
                        IRfNamedElement portElement;
                        IHidObject lhValue;
                        if (!(portHidObj instanceof IHidOperator)) continue;
                        IHidOperator portOperator = (IHidOperator)portHidObj;
                        if (PortConnectionUtils.isDotStarConnected((IHidOperator)portOperator)) {
                            declarationInputPorts.clear();
                            break;
                        }
                        if (portOperator.getOccurrence() != null && !portOperator.getOccurrence().hasQualifier(HidQualifierCache.IS_PORT_CONNECTION_QUALIFIER) || !((lhValue = portOperator.getLHValue()) instanceof RfHid) || !((portElement = (portHid = (RfHid)lhValue).getElement()) instanceof RfPort)) continue;
                        RfPort port = (RfPort)portElement;
                        declarationInputPorts.remove(port);
                    }
                }
                for (RfPort inputPort : declarationInputPorts) {
                    this.addHit(instance, "DUT input port '" + inputPort.getFullName() + "' is not properly connected!");
                }
                return true;
            });
        }
    }

    private List<RfPort> getDeclarationInputPorts(RfInstance instance) {
        RfNamedElement instanceType = LintUtils.getAssociatedFinalType(instance);
        return instanceType.getPortsWithPrefix("", 2).stream().filter(port -> port.isInput() || port.isInout()).collect(Collectors.toList());
    }
}

