/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="25.1.11")
@CheckID(value="R.1397")
@CheckName(value="R.1397")
@CheckLabel(labels={RuleLabel.ASSIGNMENT, RuleLabel.DESIGN})
@CheckTitle(value="Do not write a variable multiple times in design elements")
@CheckDescription(value="This rule flags any instance where a single variable is assigned more than once within the same procedural or continuous assignment context in a module or interface.\nParallel or conflicting assignments to the same variable can lead to unpredictable behavior and race conditions.\n\nExample:\n\nmodule mod1;\n  reg foo;\n  always_ff @(posedge clk) begin\n    foo = 0;\n  end\n\n  always_comb begin\n    foo = 1;\n  end\nendmodule\n\nCheck supports pre-waiving.")
public class Check_R_1397
extends OVMComplianceCheck {
    private static final long ASSIGN_QUALIFIERS = HidUtils.toQualifiersSet((HidOperatorQualifier[])new HidOperatorQualifier[]{HidOperatorQualifier.IS_DECLARATION_ASSIGN, HidOperatorQualifier.IS_CONTINUOUS_ASSIGN, HidOperatorQualifier.IS_PROCEDURAL_CONTINUOUS_ASSIGN, HidOperatorQualifier.IS_ALIAS, HidOperatorQualifier.IS_NONBLOCKING_ASSIGN, HidOperatorQualifier.IS_BLOCKING_ASSIGN});

    public Check_R_1397(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        ArrayList<RfInstanceHolder> modulesAndInterfaces = new ArrayList<RfInstanceHolder>();
        modulesAndInterfaces.addAll(Arrays.asList(rfProject.getAllModules()));
        modulesAndInterfaces.addAll(Arrays.asList(rfProject.getAllInterfaces()));
        for (RfInstanceHolder holder : modulesAndInterfaces) {
            final HashMap fieldsModifiedPerMethod = new HashMap();
            final HashMap modifiedVariables = new HashMap();
            if (holder.getDeclaration() == null) continue;
            this.checkPreWaivers(holder.getDeclaration().getParserPath());
            holder.visitHidObject(rfProject, (IHidVisitor<?>)new HidOperatorVisitor(null){

                public boolean visit(HidOperator operator) {
                    Check_R_1397.this.notifyCheckAlive();
                    if (operator.hasOccurrence(HidOperatorQualifier.IS_CONTINUOUS_ASSIGN)) {
                        Set fieldContinuousAssignments;
                        CustomHid customHid;
                        IHidObject lhValue = operator.getLHValue();
                        if (lhValue instanceof RfHid) {
                            customHid = new CustomHid((RfHid)lhValue);
                            modifiedVariables.putIfAbsent(customHid, new HashSet());
                            fieldContinuousAssignments = (Set)modifiedVariables.get(customHid);
                            fieldContinuousAssignments.add(new Location(operator.getLine(), this.parserPath.path));
                        }
                        if (lhValue instanceof RfHidAccess && ((RfHidAccess)lhValue).getParentHid() != null) {
                            customHid = new CustomHid((RfHid)((RfHidAccess)lhValue).getParentHid());
                            modifiedVariables.putIfAbsent(customHid, new HashSet());
                            fieldContinuousAssignments = (Set)modifiedVariables.get(customHid);
                            fieldContinuousAssignments.add(new Location(operator.getLine(), this.parserPath.path));
                        }
                    }
                    return true;
                }
            });
            ArrayList<RfFunction> allMethods = new ArrayList<RfFunction>();
            List<RfFunction> localFunctions = holder.getLocalFunctions();
            List<RfFunction> localTasks = holder.getLocalTasks();
            if (localFunctions != null) {
                allMethods.addAll(localFunctions);
            }
            if (localTasks != null) {
                allMethods.addAll(localTasks);
            }
            for (RfFunction method : allMethods) {
                fieldsModifiedPerMethod.put(method, new HashSet());
                final Set currentMethodWrites = (Set)fieldsModifiedPerMethod.get(method);
                method.visitHidObject(rfProject, new IHidVisitor<IHidObject>(){

                    public boolean visit(IHidObject hidObject) {
                        RfHidOperator operator;
                        RfHid hid;
                        IRfNamedElement element;
                        Check_R_1397.this.notifyCheckAlive();
                        if (hidObject instanceof RfHid && (element = (hid = (RfHid)hidObject).getElement()) != null && element instanceof RfFunction) {
                            currentMethodWrites.add(new CustomHid(hid));
                        }
                        if (hidObject instanceof RfHidOperator && ((operator = (RfHidOperator)hidObject).isIncrementOrDecrement() || operator.hasOccurrence(ASSIGN_QUALIFIERS))) {
                            IHidObject lhValue = operator.getLHValue();
                            if (lhValue instanceof RfHid) {
                                currentMethodWrites.add(new CustomHid((RfHid)lhValue));
                            }
                            if (lhValue instanceof RfHidAccess && ((RfHidAccess)lhValue).getParentHid() != null) {
                                currentMethodWrites.add(new CustomHid((RfHid)((RfHidAccess)lhValue).getParentHid()));
                            }
                        }
                        return true;
                    }

                    public Class<IHidObject> getType() {
                        return IHidObject.class;
                    }
                });
            }
            Collection<? extends IRfBlockElement> localGenerateBlocks = holder.getLocalGenerateBlocks();
            Collection<? extends IRfActionBlockElement> localActionBlocks = holder.getLocalActionBlocks();
            ArrayList<Object> blockList = new ArrayList<Object>();
            if (localGenerateBlocks != null) {
                blockList.addAll(localGenerateBlocks);
            }
            if (localActionBlocks != null) {
                blockList.addAll(localActionBlocks);
            }
            ArrayList<? extends IRfInstanceElement> allModuleInstances = new ArrayList<IRfInstanceElement>();
            if (blockList != null) {
                for (final IRfNamedElement iRfNamedElement : blockList) {
                    Collection blockLocalInstances;
                    if (iRfNamedElement instanceof RfGenerateBlock && (blockLocalInstances = ((IRfBlockElement)iRfNamedElement).getLocalInstances()) != null) {
                        allModuleInstances.addAll(blockLocalInstances);
                    }
                    iRfNamedElement.visitHidObject((IRfSingleLangProject)rfProject, (IHidVisitor)new IHidVisitor<IHidObject>(){

                        public boolean visit(IHidObject hidObject) {
                            RfHidOperator operator;
                            RfHid hid;
                            IRfNamedElement element;
                            Check_R_1397.this.notifyCheckAlive();
                            if (hidObject instanceof RfHid && (element = (hid = (RfHid)hidObject).getElement()) != null && element instanceof RfFunction) {
                                HidAccess accesses;
                                if (hid.getAccesses() != null && (accesses = (HidAccess)hid.getAccesses().get(0)) instanceof RfHidAccessArgs) {
                                    List<? extends IHidObject> args = ((RfHidAccessArgs)accesses).getArgumentValues();
                                    for (IHidObject iHidObject : args) {
                                        RfField field;
                                        IRfNamedElement signatureArgElement;
                                        if (!(iHidObject instanceof RfHidOperator)) continue;
                                        IHidObject lhValue = ((RfHidOperator)iHidObject).getLHValue();
                                        IHidObject rhValue = null;
                                        if (((RfHidOperator)iHidObject).getRHValues() != null) {
                                            rhValue = (IHidObject)((RfHidOperator)iHidObject).getRHValues().get(0);
                                        }
                                        if (rhValue == null || !(rhValue instanceof RfHid)) continue;
                                        RfHid calledArg = (RfHid)rhValue;
                                        if (!(lhValue instanceof RfHid) || !((signatureArgElement = ((RfHid)lhValue).getElement()) instanceof RfField) || !(field = (RfField)signatureArgElement).isInout() && !field.isOutput()) continue;
                                        CustomHid customHid = new CustomHid(calledArg);
                                        modifiedVariables.putIfAbsent(customHid, new HashSet());
                                        Set methodFieldActionBlocks = (Set)modifiedVariables.get(customHid);
                                        methodFieldActionBlocks.add(iRfNamedElement);
                                    }
                                }
                                Check_R_1397.this.handleMethodCalledInActionBlock(fieldsModifiedPerMethod, (RfFunction)element, modifiedVariables, iRfNamedElement);
                            }
                            if (hidObject instanceof RfHidOperator && ((operator = (RfHidOperator)hidObject).isIncrementOrDecrement() || operator.hasOccurrence(ASSIGN_QUALIFIERS))) {
                                Set methodFieldActionBlocks;
                                CustomHid customHid;
                                IHidObject lhValue = operator.getLHValue();
                                if (lhValue instanceof RfHid) {
                                    customHid = new CustomHid((RfHid)lhValue);
                                    modifiedVariables.putIfAbsent(customHid, new HashSet());
                                    methodFieldActionBlocks = (Set)modifiedVariables.get(customHid);
                                    methodFieldActionBlocks.add(iRfNamedElement);
                                }
                                if (lhValue instanceof RfHidAccess && ((RfHidAccess)lhValue).getParentHid() != null) {
                                    customHid = new CustomHid((RfHid)((RfHidAccess)lhValue).getParentHid());
                                    modifiedVariables.putIfAbsent(customHid, new HashSet());
                                    methodFieldActionBlocks = (Set)modifiedVariables.get(customHid);
                                    methodFieldActionBlocks.add(iRfNamedElement);
                                }
                            }
                            return true;
                        }

                        public Class<IHidObject> getType() {
                            return IHidObject.class;
                        }
                    });
                }
            }
            Collection<? extends IRfInstanceElement> collection = holder.getLocalInstances();
            allModuleInstances.addAll(collection);
            for (IRfInstanceElement iRfInstanceElement : allModuleInstances) {
                RfHidHolder hidHolder;
                this.notifyCheckAlive();
                if (!(iRfInstanceElement instanceof RfInstance) || (hidHolder = ((RfInstance)iRfInstanceElement).getHidHolder()) == null || iRfInstanceElement.getDeclaration() == null) continue;
                ParserPath instanceLocation = iRfInstanceElement.getDeclaration().getParserPath();
                ListContainer listContainer = (ListContainer)hidHolder.getHidObjectsMap().get(instanceLocation);
                for (IHidObject port : listContainer) {
                    IRfNamedElement element;
                    if (!(port instanceof RfHidOperator)) continue;
                    IHidObject lhValue = ((RfHidOperator)port).getLHValue();
                    IHidObject rhValue = null;
                    if (((RfHidOperator)port).getRHValues() != null) {
                        rhValue = (IHidObject)((RfHidOperator)port).getRHValues().get(0);
                    }
                    if (rhValue == null || !(lhValue instanceof RfHid) || !(rhValue instanceof RfHid) || !((element = ((RfHid)lhValue).getElement()) instanceof RfPort) || !((RfPort)element).isInout() && !((RfPort)element).isOutput()) continue;
                    CustomHid customHid = new CustomHid((RfHid)rhValue);
                    modifiedVariables.putIfAbsent(customHid, new HashSet());
                    Set methodFieldActionBlocks = (Set)modifiedVariables.get(customHid);
                    methodFieldActionBlocks.add(iRfInstanceElement);
                }
            }
            for (Map.Entry entry : modifiedVariables.entrySet()) {
                String message;
                Set modifiers = (Set)entry.getValue();
                CustomHid customHid = (CustomHid)entry.getKey();
                IRfNamedElement variable = customHid.fElement;
                if (modifiers.size() <= 1 || (message = this.getErrorMessage(customHid, modifiers)) == null) continue;
                this.addHit((RfNamedElement)variable, message);
            }
        }
    }

    private String getErrorMessage(CustomHid customHid, Set<Object> modifiers) {
        StringBuilder message = new StringBuilder();
        RfNamedElement element = (RfNamedElement)customHid.fElement;
        if (element == null) {
            return null;
        }
        message.append("Field '" + LintUtils.getNamedElementFullName(element) + "' is written in the following places:\n");
        RfFileDef elementFile = element.getFile();
        if (elementFile == null) {
            return null;
        }
        String path = elementFile.getParserPath().path;
        ArrayList<Object> orderedModifiers = new ArrayList<Object>(modifiers);
        orderedModifiers.sort(new SafeLineComparator());
        for (Object e : orderedModifiers) {
            Object actionBlock;
            int line;
            if (e instanceof Location) {
                line = ((Location)e).line;
                path = ((Location)e).path;
                message.append("Continuous assignment").append(this.link(" at line " + line + " of " + LintUtils.getFileShortName(path), path, line)).append("\n");
                continue;
            }
            if (e instanceof IRfInstanceElement) {
                line = ((IRfInstanceElement)e).getLine();
                if (e instanceof RfInstance) {
                    path = ((RfInstance)e).getFile().getParserPath().path;
                }
                message.append("Port connection").append(this.link(" at line " + line + " of " + LintUtils.getFileShortName(path), path, line)).append("\n");
                continue;
            }
            if (e instanceof IRfActionBlockElement) {
                line = ((IRfActionBlockElement)e).getLine();
                actionBlock = (IRfActionBlockElement)e;
                if (actionBlock instanceof RfActionBlock) {
                    path = ((RfActionBlock)actionBlock).getFile().getParserPath().path;
                }
                message.append("Inside procedural block").append(this.link(" at line " + line + " of " + LintUtils.getFileShortName(path), path, line)).append("\n");
                continue;
            }
            if (!(e instanceof RfGenerateBlock)) continue;
            line = ((RfGenerateBlock)e).getLine();
            actionBlock = (RfGenerateBlock)e;
            path = ((RfNamedElement)actionBlock).getFile().getParserPath().path;
            message.append("Inside generate block").append(this.link(" at line " + line + " of " + LintUtils.getFileShortName(path), path, line)).append("\n");
        }
        return message.toString();
    }

    private void handleMethodCalledInActionBlock(Map<RfFunction, Set<CustomHid>> fieldsModifiedPerMethod, RfFunction method, Map<CustomHid, Set<Object>> modifiedVariables, IRfNamedElement actionBlock) {
        Set<CustomHid> methodFields = fieldsModifiedPerMethod.get(method);
        if (methodFields == null) {
            return;
        }
        for (CustomHid methodCustomHid : methodFields) {
            IRfNamedElement methodField = methodCustomHid.fElement;
            if (methodField instanceof RfFunction) {
                this.handleMethodCalledInActionBlock(fieldsModifiedPerMethod, (RfFunction)methodField, modifiedVariables, actionBlock);
                continue;
            }
            modifiedVariables.putIfAbsent(methodCustomHid, new HashSet());
            Set<Object> methodFieldActionBlocks = modifiedVariables.get(methodCustomHid);
            methodFieldActionBlocks.add(actionBlock);
        }
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private static class CustomHid {
        public IRfNamedElement fElement;
        public RfHid fHid;

        public CustomHid(RfHid hid) {
            this.fElement = hid.getElement();
            this.fHid = hid;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.fElement == null ? 0 : this.fElement.hashCode());
            result = 31 * result + (this.fHid == null ? 0 : this.fHid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CustomHid other = (CustomHid)obj;
            if (this.fElement == null ? other.fElement != null : !this.fElement.equals(other.fElement)) {
                return false;
            }
            return !(this.fHid == null ? other.fHid != null : !this.fHid.equals((Object)other.fHid));
        }
    }

    private static class Location {
        public Integer line;
        public String path;

        public Location(Integer line, String path) {
            this.line = line;
            this.path = path;
        }

        public Integer getLine() {
            return this.line;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Location other = (Location)obj;
            return (this.line == null ? other.line == null : this.line.equals(other.line)) && (this.path == null ? other.path == null : this.path.equals(other.path));
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + (this.line != null ? this.line.hashCode() : 0);
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            return result;
        }
    }

    public static class SafeLineComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) {
            Integer line1 = this.extractLine(o1);
            Integer line2 = this.extractLine(o2);
            if (line1 == null && line2 == null) {
                return 0;
            }
            if (line1 == null) {
                return 1;
            }
            if (line2 == null) {
                return -1;
            }
            return Integer.compare(line1, line2);
        }

        private Integer extractLine(Object obj) {
            if (obj instanceof Location) {
                return ((Location)obj).getLine();
            }
            if (obj instanceof IRfInstanceElement) {
                return ((IRfInstanceElement)obj).getLine();
            }
            if (obj instanceof IRfActionBlockElement) {
                return ((IRfActionBlockElement)obj).getLine();
            }
            if (obj instanceof RfGenerateBlock) {
                return ((RfGenerateBlock)obj).getLine();
            }
            return null;
        }
    }
}

