/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="25.1.10")
@CheckID(value="R.1398")
@CheckName(value="R.1398")
@CheckLabel(labels={RuleLabel.LITERAL_VALUE, RuleLabel.CONDITIONAL_DIRECTIVE, RuleLabel.ASSIGNMENT, RuleLabel._4_STATE})
@CheckTitle(value="Do not assign X or Z literal values unless they are enclosed in `ifdef/`ifndef guards")
@CheckDescription(value="This rule checks that all assignments of X or Z literal values are enclosed in `ifdef/`ifndef guards.\n\nExamples:\n\nbit a = 1'bx;   // not allowed\n`ifndef A\n  bit a = 1'bx; // allowed\n`endif\n\nCheck supports pre-waiving.")
public class Check_R_1398
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of allowed guard names. If empty, any guard name is allowed.", name="allowedGuardNames", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pAllowedGuardNames;
    @CheckParameter(defaultValue="negative", description="Comma separated list of guard branches polarities where assignments of X or Z literal values are allowed: positive, negative.", name="guardPolarity", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pGuardPolarity;
    private static final String X = "X";
    private static final String Z = "Z";
    private boolean isNegativePolarityAllowed;
    private boolean isPositivePolarityAllowed;

    public Check_R_1398(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        if (this.pGuardPolarity.isEmpty() || !this.pGuardPolarity.contains("negative") && !this.pGuardPolarity.contains("positive")) {
            this.signalParamError("Invalid values for 'guardPolarity' parameter!", true);
        }
        this.isNegativePolarityAllowed = this.pGuardPolarity.contains("negative");
        this.isPositivePolarityAllowed = this.pGuardPolarity.contains("positive");
    }

    @Override
    public void performCheckImpl() {
        RfClass[] allClasses;
        Map<ParserPath, List<LintUtils.DirectiveInfo>> allDirectives = LintUtils.getAllDirectives(this.fOVMProject.getAllFilesInOrder(), this.fOVMProject.getRfProject().getPreprocessingTable(), this.getWSParser());
        OperatorVisitor visitor = new OperatorVisitor(allDirectives);
        this.fOVMProject.getRfProject().visitHidObject(null, visitor);
        RfClass[] rfClassArray = allClasses = this.fOVMProject.getRfProject().getAllClasses();
        int n = allClasses.length;
        int n2 = 0;
        while (n2 < n) {
            RfClass clazz = rfClassArray[n2];
            DataType extendedDataType = clazz.getExtendedType();
            if (extendedDataType != null && extendedDataType.getParamValuesHolder() != null) {
                extendedDataType.getParamValuesHolder().visitHidObject(null, visitor);
            }
            ++n2;
        }
    }

    public boolean checkHidImplicit(RfHidImplicit hidImplicit) {
        String numberString;
        return hidImplicit.isNumber() && hidImplicit.getType() != 283 && ((numberString = hidImplicit.getName()).toUpperCase().contains(X) || numberString.toUpperCase().contains(Z));
    }

    public String getHitInfo(RfHidOperator hidOperator) {
        if (hidOperator.isAssociation()) {
            IHidObject lhValue = hidOperator.getLHValue();
            if (!(lhValue instanceof RfHid)) {
                return null;
            }
            IRfNamedElement element = ((RfHid)lhValue).getElement();
            if (!(element instanceof RfNamedElement)) {
                return null;
            }
            RfNamedElement namedElement = (RfNamedElement)element;
            if (namedElement.getKindName() == null) {
                return null;
            }
            return "assigned to " + namedElement.getKindName() + " '" + LintUtils.getNamedElementFullName(namedElement);
        }
        if (hidOperator.isAssignment()) {
            return "assigned in '" + HidUtils.toNiceString((IHidObject)hidOperator);
        }
        if (hidOperator.isReturnStatement()) {
            return "used in return statement '" + HidUtils.toNiceString((IHidObject)hidOperator);
        }
        return null;
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class OperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        private ParserPath parserPath;
        private Map<ParserPath, List<LintUtils.DirectiveInfo>> allDirectives;

        public OperatorVisitor(Map<ParserPath, List<LintUtils.DirectiveInfo>> allDirectives) {
            this.allDirectives = allDirectives;
        }

        public boolean visit(RfHidOperator hidOperator) {
            if (!(hidOperator.isAssignment() || hidOperator.isReturnStatement() || hidOperator.isAssociation())) {
                return true;
            }
            if (Check_R_1398.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1398.this.notifyCheckAlive();
            if (LintUtils.isOffsetInsideGuard(this.allDirectives, this.parserPath, hidOperator.getOccurrence().getOffset(), Check_R_1398.this.pAllowedGuardNames, Check_R_1398.this.isPositivePolarityAllowed, Check_R_1398.this.isNegativePolarityAllowed)) {
                return true;
            }
            Set flattenHids = hidOperator.getRHHids(EnumSet.of(HidFlatteningOption.IGNORE_HIDS));
            if (flattenHids == null || flattenHids.isEmpty()) {
                return true;
            }
            for (IHid hid : flattenHids) {
                if (!(hid instanceof RfHidImplicit) || !Check_R_1398.this.checkHidImplicit((RfHidImplicit)hid)) continue;
                String hitInfo = Check_R_1398.this.getHitInfo(hidOperator);
                if (hitInfo == null) {
                    return true;
                }
                Check_R_1398.this.addHit(this.parserPath, hidOperator, hidOperator.getQualifiers(), "Value " + HidUtils.toNiceString((IHidObject)hid) + " " + hitInfo + "'!");
            }
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

