/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;
import ro.amiq.vlogdt.utils.Utils;

@CheckVersion(value="25.1.11")
@CheckID(value="R.1399")
@CheckName(value="R.1399")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.RETURN, RuleLabel.PERFORMANCE})
@CheckTitle(value="Functions should have a single return statement")
@CheckDescription(value="This check flags functions that have multiple return statements.\nFor some simulators it is prefered for functions to have a single return statement, as it results in better simulation performance.\nIt is recommended to replace the multiple return statements with assignments and use only one such statement.\n\nExample:\n\nfunction logic foo(logic a, logic b, logic c);\t\t// not allowed\n  if (a == 1'b1) return b;\n  return c;\nendfunction\n\nfunction logic foo(logic a, logic b, logic c);\t\t// allowed\n  logic x;\n  x = c;\n  if (a == 1'b1) x = b;\n  return x;\nendfunction\n\nCheck supports pre-waiving.")
public class Check_R_1399
extends OVMComplianceCheck {
    private static final String ERROR_MESSAGE = "Function ''{0}'' has multiple return statements in {1}!";

    public Check_R_1399(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject == null) {
            return;
        }
        NullProtectedList<RfNamedElement> functions = this.fOVMProject.getAllFunctions();
        if (functions == null || functions.isEmpty()) {
            return;
        }
        for (RfNamedElement elem : functions) {
            Map<ParserPath, List<Integer>> returnStatements;
            RfDefElement declaration;
            RfFunction function;
            if (!(elem instanceof RfFunction) || (function = (RfFunction)elem).isPredefined() || (declaration = function.getDeclaration()) == null || this.checkPreWaivers(declaration.getParserPath())) continue;
            this.notifyCheckAlive();
            if (function.isConstructor() || function.isVoid()) continue;
            LocalHidOperatorVisitor operatorVisitor = new LocalHidOperatorVisitor(null);
            function.visitHidObject(null, (IHidVisitor<?>)operatorVisitor);
            if (operatorVisitor.getNofReturnStatements() < 2 || (returnStatements = operatorVisitor.getReturnStatements()) == null) continue;
            this.addHitOnFunctionDefinition(function, MessageFormat.format(ERROR_MESSAGE, function.getName(), this.buildErrorMessageInfo(returnStatements)));
        }
    }

    private StringBuilder buildErrorMessageInfo(Map<ParserPath, List<Integer>> returnStatements) {
        StringBuilder linesString = new StringBuilder();
        Set<Map.Entry<ParserPath, List<Integer>>> entrySet = returnStatements.entrySet();
        for (Map.Entry<ParserPath, List<Integer>> entry : entrySet) {
            linesString.append("\n    " + Utils.getInstance().getFileName(entry.getKey().path) + " at ");
            linesString.append((CharSequence)this.buildErrorMessageInfoPerEntry(entry));
            linesString.append(";");
        }
        linesString.delete(linesString.length() - 1, linesString.length());
        return linesString;
    }

    private StringBuilder buildErrorMessageInfoPerEntry(Map.Entry<ParserPath, List<Integer>> entry) {
        StringBuilder linesString = new StringBuilder();
        ParserPath path = entry.getKey();
        List<Integer> lines = entry.getValue();
        Collections.sort(lines);
        if (lines.size() > 1) {
            linesString.append("lines ");
        } else {
            linesString.append("line ");
        }
        for (Integer line : lines) {
            linesString.append(this.link(line.toString(), path.path, line)).append(", ");
        }
        linesString.delete(linesString.length() - 2, linesString.length());
        return linesString;
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private static final class LocalHidOperatorVisitor
    extends HidOperatorVisitor {
        private Map<ParserPath, List<Integer>> returnStatements = new HashMap<ParserPath, List<Integer>>();
        private int nofReturnStatements = 0;

        public LocalHidOperatorVisitor(HidOperatorQualifier[] qualifiers) {
            super(qualifiers);
        }

        public boolean visit(HidOperator operator) {
            if (!operator.isReturnStatement()) {
                return true;
            }
            if (!this.returnStatements.containsKey(this.parserPath)) {
                this.returnStatements.put(this.parserPath, new ArrayList());
            }
            this.returnStatements.get(this.parserPath).add(operator.getLine());
            ++this.nofReturnStatements;
            return true;
        }

        public Map<ParserPath, List<Integer>> getReturnStatements() {
            return this.returnStatements;
        }

        public int getNofReturnStatements() {
            return this.nofReturnStatements;
        }
    }
}

