/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.buildconfig.ElaborationDebugZone;
import ro.amiq.dvt.buildconfig.ElaborationExpressionControl;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELBuildPhase;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.core.ELManagerConfiguration;
import ro.amiq.dvt.elaboration.core.ELSpecializationWrapper;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.ui.trace.connections.model.TCConnSignal;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfComputedListType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="25.2.15")
@CheckID(value="R.1400")
@CheckName(value="R.1400")
@CheckLabel(labels={RuleLabel.DESIGN, RuleLabel.SYNTHESIS, RuleLabel.SELECT})
@CheckTitle(value="Undriven bits and part selects")
@CheckDescription(value="This rule checks that all bits of a signal are driven.\n\nExamples:\n\nlogic [3:0] sig_a;\t// allowed\nlogic [3:0] sig_b;\t// not allowed (first bit is not driven)\n\nsig_a[0] = 1'b0;\nsig_a[1:2] = 2'b10;\nsig_a[3] = 1'b1;\n\nsig_b[1:3] = 3'b101;\n\nCheck supports pre-waiving.")
public class Check_R_1400
extends OVMComplianceCheck {
    public Map<RfField, Map<ElementPath, boolean[]>> fieldsWithDimensions;
    public Map<RfField, Set<ElementPath>> fieldsWithAccessedPaths;
    private ELManager manager;
    private ELParamValuesHidEvaluator emptyEvaluator;
    private Map<IRfNamedElement, Map<ELSpecializationWrapper, ELSpecializationWrapper>> specsPerElement;
    private Set<RfInstance> visitedInstancesWithPortConnections;
    Map<IRfInstanceElement, Set<DummyPort>> dummyPortMap;
    private static final EnumSet<HidFlatteningOption> HID_FLATTENING = EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS);
    private static final String ERROR_MESSAGE = "Signal {0} has undriven bits: {1}";
    private static final String ERROR_MESSAGE_MULTIPLE_PATHS = "Signal {0} has undriven bits for the following hierarchy paths: {1}";

    public Check_R_1400(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        ELManager elabManager = rfProject.getELManager();
        RfMixedLangProject mixedLangProjectParent = rfProject.getMixedLangProjectParent();
        this.manager = new ELManager(mixedLangProjectParent, IELMemory.ELMemoryType.STANDARD, ELBuildPhase.NONE, ELManagerConfiguration.newDummyWithControlConfig((boolean)false, EnumSet.noneOf(ElaborationExpressionControl.class), new HashSet(), (boolean)false), mixedLangProjectParent.getNonElabConstantsManager(), EnumSet.noneOf(ElaborationDebugZone.class));
        IELMemory elabMem = elabManager != null ? elabManager.getMemory() : null;
        this.manager.addToMemory(elabMem);
        this.emptyEvaluator = ELParamValues.EMPTY.getHidEvaluator(this.manager);
        this.specsPerElement = rfProject.getMixedLangProjectParent().getLinterElabSpecs();
        RfField[] allFields = rfProject.getAllFields();
        this.fieldsWithDimensions = new HashMap<RfField, Map<ElementPath, boolean[]>>();
        this.fieldsWithAccessedPaths = new HashMap<RfField, Set<ElementPath>>();
        this.visitedInstancesWithPortConnections = new HashSet<RfInstance>();
        this.dummyPortMap = new HashMap<IRfInstanceElement, Set<DummyPort>>();
        RfField[] rfFieldArray = allFields;
        int n = allFields.length;
        int n2 = 0;
        while (n2 < n) {
            RfField field = rfFieldArray[n2];
            RfNamedElement scope = field.getEnclosingScope();
            if (scope instanceof RfModule) {
                IRfNamedElement associatedType;
                RfModule scopeModule = (RfModule)scope;
                RfDefElement declaration = field.getDeclaration();
                if (declaration != null && !this.checkPreWaivers(field.getDeclaration().getParserPath()) && (associatedType = field.getAssociatedType()) instanceof RfComputedListType) {
                    RfComputedListType.Dimension lastDimension = ((RfComputedListType)associatedType).getLastDimension();
                    Map<ELSpecializationWrapper, ELSpecializationWrapper> specWrappers = this.specsPerElement.get(scopeModule);
                    if (specWrappers != null) {
                        for (ELSpecializationWrapper specWrapper : specWrappers.values()) {
                            for (ElementPath path : specWrapper.paths) {
                                Integer nofBits = this.computeRangeSize(lastDimension, specWrapper, field, scopeModule);
                                if (nofBits == null) continue;
                                if (this.fieldsWithDimensions.get(field) == null) {
                                    this.fieldsWithDimensions.put(field, new HashMap());
                                }
                                this.fieldsWithDimensions.get(field).put(path, new boolean[nofBits.intValue()]);
                            }
                        }
                    }
                }
            }
            ++n2;
        }
        this.notifyCheckAlive();
        rfProject.visitHidObject(null, (IHidVisitor<?>)new AssignmentVisitor(null));
        for (Map.Entry<RfField, Map<ElementPath, boolean[]>> entry : this.fieldsWithDimensions.entrySet()) {
            boolean[] undrivenBits;
            String undrivenBitsMessage;
            RfField field = entry.getKey();
            Map<ElementPath, boolean[]> pathsWithBitsDriven = entry.getValue();
            if (this.fieldsWithAccessedPaths.containsKey(field)) {
                StringBuilder undrivenBitsWithPaths = new StringBuilder();
                Set<ElementPath> accessedPaths = this.fieldsWithAccessedPaths.get(field);
                for (Map.Entry<ElementPath, boolean[]> pathEntry : pathsWithBitsDriven.entrySet()) {
                    boolean[] undrivenBits2;
                    String undrivenBitsMessage2;
                    ElementPath path = pathEntry.getKey();
                    if (!this.isAmongAccessedPaths(path, accessedPaths) || (undrivenBitsMessage2 = this.computeUndrivenBitsMessage(undrivenBits2 = pathEntry.getValue())).isEmpty()) continue;
                    undrivenBitsWithPaths.append("\n    " + path + ": " + undrivenBitsMessage2);
                }
                String undrivenBitsWithPathsMessage = undrivenBitsWithPaths.toString();
                if (undrivenBitsWithPathsMessage.isEmpty()) continue;
                this.addHit(field, MessageFormat.format(ERROR_MESSAGE_MULTIPLE_PATHS, field, undrivenBitsWithPathsMessage));
                continue;
            }
            Collection<boolean[]> undrivenBitsForAllPaths = pathsWithBitsDriven.values();
            if (undrivenBitsForAllPaths == null || undrivenBitsForAllPaths.isEmpty() || (undrivenBitsMessage = this.computeUndrivenBitsMessage(undrivenBits = undrivenBitsForAllPaths.iterator().next())).isEmpty()) continue;
            this.addHit(field, MessageFormat.format(ERROR_MESSAGE, field, undrivenBitsMessage));
        }
    }

    private Integer computeRangeSize(RfComputedListType.Dimension dimension, ELSpecializationWrapper specWrapper, RfField field, RfModule scopeModule) {
        if (dimension instanceof RfComputedListType.RangeDimension) {
            return ((RfComputedListType.RangeDimension)dimension).getSize();
        }
        if (dimension instanceof RfComputedListType.ExpressionDimension) {
            IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)field, null, (boolean)false, (ELManager)this.manager);
            BitVectorContext context = BitVectorContext.of((IRfNamedElement)scopeModule, (boolean)false);
            IHidObject expression = ((RfComputedListType.ExpressionDimension)dimension).expression;
            if (!(expression instanceof RfHidOperator)) {
                return null;
            }
            if (!((RfHidOperator)expression).isRangeOrPartSelect()) {
                return null;
            }
            RfHidOperator range = (RfHidOperator)expression;
            IHidObject left = range.getLHValue();
            ListContainer rh = range.getRHValues();
            if (rh.size() != 1) {
                return null;
            }
            IHidObject right = (IHidObject)rh.get(0);
            guardian.updateElements((IRfNamedElement)field, (IRfNamedElement)scopeModule);
            IELParamValue leftValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)left, (IHidEvaluator)specWrapper.getHidEvaluator(this.manager), (BitVectorContext)context, (IHidEvaluationGuardian)guardian));
            if (ELUtils.isUnsuccessfulEval((IELParamValue)leftValue) || !(leftValue instanceof ELParamValues.ParamValueNumber)) {
                return null;
            }
            guardian.updateElements((IRfNamedElement)field, (IRfNamedElement)scopeModule);
            IELParamValue rightValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)right, (IHidEvaluator)specWrapper.getHidEvaluator(this.manager), (BitVectorContext)context, (IHidEvaluationGuardian)guardian));
            if (ELUtils.isUnsuccessfulEval((IELParamValue)rightValue) || !(rightValue instanceof ELParamValues.ParamValueNumber)) {
                return null;
            }
            return Math.abs(leftValue.intValue() - rightValue.intValue()) + 1;
        }
        return null;
    }

    private String computeUndrivenBitsMessage(boolean[] undrivenBits) {
        StringBuilder bitsNotDriven = new StringBuilder();
        int bitIndex = 0;
        while (bitIndex < undrivenBits.length) {
            if (!undrivenBits[bitIndex]) {
                int sequenceStart = bitIndex;
                bitsNotDriven.append(bitIndex);
                while (bitIndex + 1 < undrivenBits.length && !undrivenBits[bitIndex + 1]) {
                    ++bitIndex;
                }
                if (bitIndex != sequenceStart) {
                    bitsNotDriven.append("-" + bitIndex);
                }
                bitsNotDriven.append(", ");
            }
            ++bitIndex;
        }
        if (bitsNotDriven.length() > 0) {
            bitsNotDriven.replace(bitsNotDriven.length() - 2, bitsNotDriven.length(), "");
        }
        return bitsNotDriven.toString();
    }

    private boolean isAmongAccessedPaths(ElementPath needle, Set<ElementPath> haystack) {
        for (ElementPath suffix : haystack) {
            if (!needle.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    private Collection<IHidObject> flattenToHidsFromOperator(RfHidOperator operator) {
        ArrayList<IHidObject> flattenedHids = new ArrayList<IHidObject>();
        IHidObject lh = operator.getLHValue();
        if (lh instanceof RfHidOperator) {
            flattenedHids.addAll(this.flattenToHidsFromOperator((RfHidOperator)lh));
        } else {
            flattenedHids.add(lh);
        }
        ListContainer rhValues = operator.getRHValues();
        if (rhValues != null) {
            for (IHidObject rh : rhValues) {
                if (rh instanceof RfHidOperator) {
                    flattenedHids.addAll(this.flattenToHidsFromOperator((RfHidOperator)rh));
                    continue;
                }
                flattenedHids.add(rh);
            }
        }
        return flattenedHids;
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class AssignmentVisitor
    extends HidOperatorVisitor {
        public AssignmentVisitor(HidOperatorQualifier[] qualifiers) {
            super(qualifiers);
        }

        public boolean visit(HidOperator operator) {
            if (Check_R_1400.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (!(operator.hasOccurrence(HidQualifierCache.ALL_SIMPLE_ASSIGN_QUALIFIERS) || operator.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN) || operator.hasOccurrence(HidOperatorQualifier.IS_PORT_CONNECTION) || operator.hasOccurrence(HidOperatorQualifier.IS_ALIAS))) {
                return true;
            }
            Check_R_1400.this.notifyCheckAlive();
            IHidObject lhValue = operator.getLHValue();
            if (operator.hasOccurrence(HidOperatorQualifier.IS_ALIAS)) {
                if (!(operator instanceof RfHidOperator)) {
                    return true;
                }
                Collection<IHidObject> hids = Check_R_1400.this.flattenToHidsFromOperator((RfHidOperator)operator);
                for (IHidObject hid : hids) {
                    if (hid instanceof RfHidImplicit) continue;
                    this.handleHid(hid);
                }
                return true;
            }
            if (operator.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN)) {
                if (!(lhValue instanceof RfHidImplicit)) {
                    return true;
                }
                String fieldName = ((RfHidImplicit)lhValue).getName();
                if (fieldName == null) {
                    return true;
                }
                if (!(this.scope instanceof RfNamedElement)) {
                    return true;
                }
                RfField field = ((RfNamedElement)this.scope).getLocalMember(RfField.class, fieldName, false);
                if (field == null) {
                    return true;
                }
                Check_R_1400.this.fieldsWithDimensions.remove(field);
                return true;
            }
            if (operator.hasOccurrence(HidOperatorQualifier.IS_PORT_CONNECTION)) {
                if (!(this.scope instanceof RfInstance)) {
                    return true;
                }
                RfInstance instance = (RfInstance)this.scope;
                if (Check_R_1400.this.visitedInstancesWithPortConnections.contains(this.scope)) {
                    return true;
                }
                Map portConnections = DesignUtils.mapInstancePortConnections((DesignUtils.DesignRequest)DesignUtils.DesignRequest.of((IRfNamedElement)this.scope), Check_R_1400.this.dummyPortMap, HID_FLATTENING);
                Check_R_1400.this.visitedInstancesWithPortConnections.add((RfInstance)this.scope);
                if (portConnections == null || portConnections.isEmpty()) {
                    return true;
                }
                for (Map.Entry portConnection : portConnections.entrySet()) {
                    IRfPortElement port = (IRfPortElement)portConnection.getKey();
                    if (port instanceof RfField) {
                        Check_R_1400.this.fieldsWithDimensions.remove((RfField)port);
                    }
                    Set connSignals = (Set)portConnection.getValue();
                    for (TCConnSignal connSignal : connSignals) {
                        IHid signalHid = connSignal.getSignalHid();
                        if (!(signalHid instanceof RfHid)) {
                            RfField signal;
                            String signalName = connSignal.getSignalName();
                            RfNamedElement instanceModule = instance.getEnclosingScope();
                            if (!(instanceModule instanceof RfModule) || (signal = ((RfModule)instanceModule).getFieldWithPrefix(signalName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE)) == null) continue;
                            Check_R_1400.this.fieldsWithDimensions.remove(signal);
                            continue;
                        }
                        IRfNamedElement signal = ((RfHid)signalHid).getElement();
                        if (!(signal instanceof RfField)) continue;
                        Check_R_1400.this.fieldsWithDimensions.remove(signal);
                    }
                }
            }
            return this.handleHid(lhValue);
        }

        private boolean handleHid(IHidObject hidObject) {
            if (hidObject instanceof RfHid) {
                IRfNamedElement elem = ((RfHid)hidObject).getElement();
                if (!(elem instanceof RfField)) {
                    return true;
                }
                Check_R_1400.this.fieldsWithDimensions.remove(elem);
                return true;
            }
            if (hidObject instanceof RfHidAccess) {
                IHidObject select;
                RfHidAccess access = (RfHidAccess)hidObject;
                Hid parent = access.getParentHid();
                if (parent == null) {
                    return true;
                }
                IRfNamedElement elem = parent.getElement();
                if (!(elem instanceof RfField)) {
                    return true;
                }
                RfField field = (RfField)elem;
                List selects = access.getSelects();
                if (selects.size() != 1) {
                    Check_R_1400.this.fieldsWithDimensions.remove(field);
                    return true;
                }
                HidAccess parentAccess = parent.getParentAccess();
                ElementPath path = null;
                if (parentAccess != null) {
                    String[] parts = HidUtils.toString((IHidObject)parentAccess, (boolean)true, (boolean)true).split("\\.");
                    path = ElementPath.create(Arrays.asList(parts));
                }
                if ((select = (IHidObject)selects.get(0)) instanceof RfHid) {
                    Check_R_1400.this.fieldsWithDimensions.remove(field);
                    return true;
                }
                if (select instanceof RfHidOperator) {
                    this.markPartSelect(field, (RfHidOperator)select, path);
                    return true;
                }
                if (select instanceof RfHidImplicit) {
                    this.markBitSelect(field, (RfHidImplicit)select, path);
                    return true;
                }
            }
            return true;
        }

        private void markPartSelect(RfField field, RfHidOperator select, ElementPath accessPath) {
            Map<ElementPath, boolean[]> pathsWithBitsDriven = Check_R_1400.this.fieldsWithDimensions.get(field);
            if (pathsWithBitsDriven == null) {
                return;
            }
            if (!select.isRangeOrPartSelect()) {
                Check_R_1400.this.fieldsWithDimensions.remove(field);
                return;
            }
            ListContainer rhValues = select.getRHValues();
            if (rhValues == null || rhValues.size() != 1) {
                return;
            }
            IHidObject lh = select.getLHValue();
            if (!(lh instanceof RfHidImplicit)) {
                Check_R_1400.this.fieldsWithDimensions.remove(field);
                return;
            }
            IHidObject rh = (IHidObject)rhValues.get(0);
            if (!(rh instanceof RfHidImplicit)) {
                Check_R_1400.this.fieldsWithDimensions.remove(field);
                return;
            }
            IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)field, null, (boolean)false, (ELManager)Check_R_1400.this.manager);
            BitVectorContext context = BitVectorContext.of((IRfNamedElement)field.getEnclosingScope(), (boolean)false);
            guardian.updateElements((IRfNamedElement)field, (IRfNamedElement)field.getEnclosingScope());
            IELParamValue lhValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)lh, (IHidEvaluator)Check_R_1400.this.emptyEvaluator, (BitVectorContext)context, (IHidEvaluationGuardian)guardian));
            if (ELUtils.isUnsuccessfulEval((IELParamValue)lhValue) || !(lhValue instanceof ELParamValues.ParamValueNumber)) {
                return;
            }
            guardian.updateElements((IRfNamedElement)field, (IRfNamedElement)field.getEnclosingScope());
            IELParamValue rhValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)rh, (IHidEvaluator)Check_R_1400.this.emptyEvaluator, (BitVectorContext)context, (IHidEvaluationGuardian)guardian));
            if (ELUtils.isUnsuccessfulEval((IELParamValue)rhValue) || !(rhValue instanceof ELParamValues.ParamValueNumber)) {
                return;
            }
            int start = Math.min(lhValue.intValue(), rhValue.intValue());
            int end = Math.max(lhValue.intValue(), rhValue.intValue());
            for (Map.Entry<ElementPath, boolean[]> entry : pathsWithBitsDriven.entrySet()) {
                ElementPath fullPath = entry.getKey();
                boolean[] bitsDriven = entry.getValue();
                if (accessPath != null && !fullPath.endsWith(accessPath)) continue;
                int bit = start;
                while (bit <= end && bit < bitsDriven.length) {
                    bitsDriven[bit] = true;
                    ++bit;
                }
            }
            if (accessPath == null) {
                return;
            }
            if (Check_R_1400.this.fieldsWithAccessedPaths.get(field) == null) {
                Check_R_1400.this.fieldsWithAccessedPaths.put(field, new HashSet());
            }
            Check_R_1400.this.fieldsWithAccessedPaths.get(field).add(accessPath);
        }

        private void markBitSelect(RfField field, RfHidImplicit select, ElementPath accessPath) {
            Map<ElementPath, boolean[]> pathsWithBitsDriven = Check_R_1400.this.fieldsWithDimensions.get(field);
            if (pathsWithBitsDriven == null) {
                return;
            }
            IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)field, null, (boolean)false, (ELManager)Check_R_1400.this.manager);
            BitVectorContext context = BitVectorContext.of((IRfNamedElement)field.getEnclosingScope(), (boolean)false);
            guardian.updateElements((IRfNamedElement)field, (IRfNamedElement)field.getEnclosingScope());
            IELParamValue value = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)select, (IHidEvaluator)Check_R_1400.this.emptyEvaluator, (BitVectorContext)context, (IHidEvaluationGuardian)guardian));
            if (ELUtils.isUnsuccessfulEval((IELParamValue)value) || !(value instanceof ELParamValues.ParamValueNumber)) {
                return;
            }
            int bit = value.intValue();
            for (Map.Entry<ElementPath, boolean[]> entry : pathsWithBitsDriven.entrySet()) {
                ElementPath fullPath = entry.getKey();
                boolean[] bitsDriven = entry.getValue();
                if (accessPath != null && !fullPath.endsWith(accessPath) || bit >= bitsDriven.length) continue;
                bitsDriven[bit] = true;
            }
            if (accessPath == null) {
                return;
            }
            if (Check_R_1400.this.fieldsWithAccessedPaths.get(field) == null) {
                Check_R_1400.this.fieldsWithAccessedPaths.put(field, new HashSet());
            }
            Check_R_1400.this.fieldsWithAccessedPaths.get(field).add(accessPath);
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }
    }
}

