/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.elaboration.core.ELSpecializationWrapper;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractMultipleOperandsAllAssignmentsWidthMissmatchCheck;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="25.2.14")
@CheckID(value="R.1401")
@CheckName(value="R.1401")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.WIDTH_MISMATCH, RuleLabel.ASSIGNMENT})
@CheckTitle(value="Width mismatch on assignments")
@CheckDescription(value="This rule reports assignments where the left hand side has a different width than the resulting width of the right hand side.\nReturn statements and method arguments are also checked.\n\nExample:\nbit [0:0] a;\nbit [1:0] b;\nbit [2:0] c;\n\na = b;         // NOT ALLOWED\na = b + c;     // NOT ALLOWED\na = b & c;     // NOT ALLOWED\nc = a + b;     // ALLOWED\nb = &c;        // NOT ALLOWED\nb = (a == c);  // NOT ALLOWED\nb |= c[3];     // NOT ALLOWED\na >>= &b;      // ALLOWED\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="ignoreIntTypeVariables", defaultValue="false", isVisible=false)
public class Check_R_1401
extends AbstractMultipleOperandsAllAssignmentsWidthMissmatchCheck {
    @CheckParameter(defaultValue="true", description="When true, assignments where the right-hand side contains only implicit values will be ignored for truncation. Default value: true", name="skipImplicitTruncation", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private Boolean pSkipImplicitTruncation;

    public Check_R_1401(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public boolean checkOperator(RfHidOperator operator) {
        return operator.isAssignment() || operator.isArithmeticAssignment() || operator.isModuloAssignment() || operator.isLogicalAssignment() || operator.isReturnStatement() || operator.hasOccurrence(HidQualifierCache.IS_DECLARATION_ASSIGN_QUALIFIER);
    }

    @Override
    protected Collection<IHidObject> flattenToHidsFromOperator(RfHidOperator operator) {
        ArrayList<IHidObject> flattenedHids = new ArrayList<IHidObject>();
        Set flattenOP = HidUtils.flattenToOperators((IHidOperator)operator);
        for (IHidOperator op : flattenOP) {
            if (!(op instanceof RfHidOperator)) {
                return null;
            }
            operator = (RfHidOperator)op;
            if (!(operator.getLHValue() instanceof RfHidOperator) && !operator.isVLOGConcatenation(true)) {
                flattenedHids.add(operator.getLHValue());
            }
            if (operator.getOperatorKind() != IHidOperatorConstants.OperatorKind.BINARY_OPERATOR && !operator.isVLOGConcatenation(true)) continue;
            if (operator.getRHValues() == null) {
                return null;
            }
            for (IHidObject operand : operator.getRHValues()) {
                if (operand instanceof RfHidOperator) continue;
                flattenedHids.add(operand);
            }
        }
        return flattenedHids;
    }

    @Override
    public void checkSizes(List<RfHidImplicit> implicitsInRight, IHidObject lhValueHidObject, List<IHidObject> nonImplicitsInRightHSide, IHidObject rhHidObject, List<IHidObject> hidObjects, List<IRfNamedElement> elements, List<RfNamedElement> elementTypes, List<ELParamValuesHidEvaluator> hidEvaluators, ParserPath parserPath, RfHidOperator operator, Map<IHidObject, String> pathsText, boolean hasPathsText, ELSpecializationWrapper specsWrapper, String missmatchType, IRfNamedElement scope) {
        HashMap<IHidObject, int[]> fieldDimensionsForHid = new HashMap<IHidObject, int[]>();
        ArrayList<int[]> fieldDimensionsInfo = new ArrayList<int[]>();
        fieldDimensionsInfo.add(this.getElementSize(hidObjects.get(0), elements.get(0), hidEvaluators.get(0), specsWrapper, scope));
        int index = 1;
        while (index < hidObjects.size()) {
            fieldDimensionsInfo.add(this.getSizeOfHid(hidObjects.get(index), elements.get(index), elementTypes.get(index), hidEvaluators.get(index), specsWrapper, scope));
            ++index;
        }
        for (RfHidImplicit implicit : implicitsInRight) {
            fieldDimensionsInfo.add(this.getSizeOfHid((IHidObject)implicit, null, null, this.emptyEvaluator, null, scope));
        }
        if (fieldDimensionsInfo.contains(null)) {
            return;
        }
        List fieldDimensionsInfoExpanded = fieldDimensionsInfo.stream().map(dimensions -> {
            int[] nArray;
            if (((int[])dimensions).length == 1) {
                int[] nArray2 = new int[2];
                nArray = nArray2;
                nArray2[0] = this.getNumberOfBitsUsedInInteger(dimensions[0]) - 1;
            } else {
                nArray = dimensions;
            }
            return nArray;
        }).collect(Collectors.toList());
        int maxNrOfDimensions = fieldDimensionsInfoExpanded.stream().mapToInt(fieldDimensions -> ((int[])fieldDimensions).length).max().orElse(0);
        fieldDimensionsInfoExpanded = fieldDimensionsInfoExpanded.stream().map(arr -> ((int[])arr).length == maxNrOfDimensions ? arr : Arrays.copyOf(arr, maxNrOfDimensions)).collect(Collectors.toList());
        int[] lhDimensionsInfo = (int[])fieldDimensionsInfoExpanded.get(0);
        int i = 1;
        while (i < hidObjects.size()) {
            fieldDimensionsForHid.put(hidObjects.get(i), (int[])fieldDimensionsInfoExpanded.get(i));
            ++i;
        }
        i = 0;
        while (i < implicitsInRight.size()) {
            fieldDimensionsForHid.put((IHidObject)implicitsInRight.get(i), (int[])fieldDimensionsInfoExpanded.get(hidObjects.size() + i));
            ++i;
        }
        int[] rhSize = this.calculateSizeOfHid(rhHidObject, fieldDimensionsForHid);
        if (rhSize == null) {
            return;
        }
        boolean isMissmatch = false;
        if (this.pSkipImplicitTruncation.booleanValue() && hidObjects.size() == 1) {
            i = 0;
            while (i < lhDimensionsInfo.length) {
                if (rhSize[i] > lhDimensionsInfo[i]) {
                    isMissmatch = true;
                    break;
                }
                i += 2;
            }
        } else {
            i = 0;
            while (i < lhDimensionsInfo.length) {
                if (rhSize[i] != lhDimensionsInfo[i]) {
                    isMissmatch = true;
                    break;
                }
                i += 2;
            }
        }
        if (!isMissmatch) {
            return;
        }
        StringBuilder hitMessage = new StringBuilder("");
        hitMessage.append("Width mismatch on " + missmatchType + ": " + HidUtils.toNiceString((IHidObject)operator) + "!");
        hitMessage.append("\nLeft side has size: " + Arrays.toString(lhDimensionsInfo) + ", while right side has size: " + Arrays.toString(rhSize) + "!");
        if (hasPathsText) {
            hitMessage.append("\n\nHierarchy Paths for:");
            for (Map.Entry<IHidObject, String> pathsEntry : pathsText.entrySet()) {
                hitMessage.append("\n  '").append(HidUtils.toNiceString((IHidObject)pathsEntry.getKey())).append("': ").append(pathsEntry.getValue());
            }
        }
        this.addHit(parserPath, (HidOccurrence)operator.getOccurrence(), hitMessage.toString());
    }

    @Override
    protected boolean checkOperatorsInRHSide(RfHidOperator operator) {
        return true;
    }

    @Override
    protected boolean checkRhSideHid(IHidObject hidObject) {
        return true;
    }
}

