/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="25.2.14")
@CheckID(value="R.1402")
@CheckName(value="R.1402")
@CheckLabel(labels={RuleLabel.RANDOMIZATION, RuleLabel.CONCATENATION, RuleLabel.CONSTRAINT, RuleLabel.DISTRIBUTION})
@CheckTitle(value="Do not use concatenations in distributions")
@CheckDescription(value="Using concatenations in distributions where the intention is evenly distributing the concatenated elements may produce unexpected results.\nThe weight of each element should be individually assigned.\n\nExamples:\n\ntypedef enum {A, B, C} custom_enum\n\nrand custom_enum data;\n\nconstraint c1 {\n    data dist { A := 40, {B, C} :/ 60 }\t\t// not allowed\n}\n\nconstraint c2 {\n    data dist { A := 40, B := 30, C := 30 }\t// allowed\n}\n\nCheck supports pre-waiving.")
public class Check_R_1402
extends OVMComplianceCheck {
    private static final String ERROR_MESSAGE = "Concatenation {0} is used in a distribution!";

    public Check_R_1402(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        NullProtectedList<RfNamedElement> allConstraints = this.fOVMProject.getAllConstraints();
        if (allConstraints != null && !allConstraints.isEmpty()) {
            for (RfNamedElement constraint : allConstraints) {
                constraint.visitHidObject(this.fOVMProject.getRfProject(), (IHidVisitor<?>)new ConstraintVisitor(null));
            }
        }
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), (IHidVisitor<?>)new HidOperatorVisitor(null){

            public boolean visit(HidOperator operator) {
                if (!operator.isWithClauseConstraint()) {
                    return true;
                }
                IHidObject constraint = operator.getLHValue();
                constraint.visitHidObject((IRfSingleLangProject)Check_R_1402.this.fOVMProject.getRfProject(), (IHidVisitor)new ConstraintVisitor(null, this.parserPath));
                return true;
            }
        });
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class ConstraintVisitor
    extends HidOperatorVisitor {
        public ConstraintVisitor(HidOperatorQualifier[] qualifiers) {
            super(qualifiers);
        }

        public ConstraintVisitor(HidOperatorQualifier[] qualifiers, ParserPath parserPath) {
            super(qualifiers);
            this.parserPath = parserPath;
        }

        public boolean visit(HidOperator operator) {
            if (Check_R_1402.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (operator == null) {
                return true;
            }
            if (!operator.hasOccurrence(HidQualifierCache.IS_DISTRIBUTION_QUALIFIER)) {
                return true;
            }
            Check_R_1402.this.notifyCheckAlive();
            ListContainer rhValues = operator.getRHValues();
            if (rhValues == null || rhValues.size() != 1) {
                return true;
            }
            IHidObject rhValue = (IHidObject)rhValues.get(0);
            if (!(rhValue instanceof RfHidOperator)) {
                return true;
            }
            ListContainer distItems = ((RfHidOperator)rhValue).getRHValues();
            if (distItems == null || distItems.isEmpty()) {
                return true;
            }
            for (IHidObject distItem : distItems) {
                RfHidOperator lhOperator;
                IHidObject lhValue;
                if (!(distItem instanceof RfHidOperator) || !((lhValue = ((RfHidOperator)distItem).getLHValue()) instanceof RfHidOperator) || !(lhOperator = (RfHidOperator)lhValue).hasOccurrence(HidQualifierCache.IS_CONCATENATION_QUALIFIER)) continue;
                Check_R_1402.this.addHit(this.parserPath, (HidOccurrence)lhOperator.getOccurrence(), MessageFormat.format(Check_R_1402.ERROR_MESSAGE, HidUtils.toNiceString((IHidObject)lhOperator)), true);
            }
            return true;
        }
    }
}

